/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.toolchain.launchers.common;

import com.oracle.truffle.llvm.toolchain.launchers.common.Driver;
import com.oracle.truffle.llvm.toolchain.launchers.linux.LinuxLinker;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ClangLike
extends Driver {
    public static final String NATIVE_PLATFORM = "native";
    public static final String XCRUN = "/usr/bin/xcrun";
    protected final boolean needLinkerFlags;
    protected final boolean needCompilerFlags;
    protected final boolean verbose;
    protected final boolean help;
    protected final boolean cxx;
    protected final boolean earlyExit;
    protected final Driver.OS os;
    protected final String[] args;
    protected final String platform;
    protected final int outputFlagPos;

    protected ClangLike(String[] args, boolean cxx, Driver.OS os, String platform) {
        super(cxx ? "clang++" : "clang");
        this.cxx = cxx;
        this.os = os;
        this.platform = platform;
        boolean mayHaveInputFiles = false;
        boolean mayBeLinkerInvocation = true;
        boolean isVerbose = false;
        boolean showHelp = false;
        boolean shouldExitEarly = false;
        boolean keepArgs = true;
        int outputFlagIdx = -1;
        block19: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!mayHaveInputFiles && !arg.startsWith("-")) {
                mayHaveInputFiles = true;
            }
            if (ClangLike.stageSelectionFlag(arg)) {
                mayBeLinkerInvocation = false;
                continue;
            }
            switch (arg) {
                case "-o": {
                    outputFlagIdx = i;
                    continue block19;
                }
                case "-v": {
                    isVerbose = true;
                    continue block19;
                }
                case "--help": {
                    showHelp = true;
                    continue block19;
                }
                case "-fembed-bitcode": {
                    System.err.println("Using `-fembed-bitcode` is not supported.");
                    System.err.println("Try calling the the wrapped tool directly: " + this.exe);
                    System.exit(1);
                    continue block19;
                }
                case "--graalvm-help": {
                    showHelp = true;
                    shouldExitEarly = true;
                    continue block19;
                }
                case "--graalvm-print-cmd": {
                    isVerbose = true;
                    shouldExitEarly = true;
                    continue block19;
                }
                case "-Wl,--gc-sections": 
                case "-Wa,--noexecstack": {
                    keepArgs = false;
                    args[i] = null;
                }
            }
        }
        this.args = keepArgs ? args : (String[])Arrays.stream(args).filter(Objects::nonNull).toArray(String[]::new);
        this.needLinkerFlags = mayBeLinkerInvocation & mayHaveInputFiles;
        this.needCompilerFlags = mayHaveInputFiles;
        this.verbose = isVerbose;
        this.help = showHelp;
        this.earlyExit = shouldExitEarly;
        this.outputFlagPos = outputFlagIdx;
    }

    private static boolean stageSelectionFlag(String s) {
        switch (s) {
            case "-E": 
            case "-fsyntax-only": 
            case "-S": 
            case "-c": {
                return true;
            }
        }
        return false;
    }

    public static void runClangXX(String[] args) {
        new ClangLike(args, true, Driver.OS.getCurrent(), NATIVE_PLATFORM).run();
    }

    public static void runClang(String[] args) {
        new ClangLike(args, false, Driver.OS.getCurrent(), NATIVE_PLATFORM).run();
    }

    protected final void run() {
        List<String> sulongArgs = this.getArgs();
        this.runDriver(sulongArgs, Arrays.asList(this.args), this.verbose, this.help, this.earlyExit);
    }

    protected List<String> getArgs() {
        ArrayList<String> sulongArgs = new ArrayList<String>();
        if (this.os == Driver.OS.DARWIN && Files.isExecutable(Paths.get(XCRUN, new String[0])) && Files.isExecutable(Paths.get(this.exe, new String[0]))) {
            sulongArgs.add(XCRUN);
            sulongArgs.add("--sdk");
            sulongArgs.add("macosx");
        }
        sulongArgs.add(this.exe);
        if (this.needCompilerFlags) {
            sulongArgs.addAll(Arrays.asList("-flto=full", "-g", "-O1", "-I" + this.getSulongHome().resolve("include")));
            if (this.cxx) {
                sulongArgs.add("-stdlib=libc++");
            }
        }
        if (this.needLinkerFlags) {
            sulongArgs.add("-L" + this.getSulongHome().resolve(this.platform).resolve("lib"));
            if (this.os == Driver.OS.LINUX) {
                sulongArgs.addAll(Arrays.asList("-fuse-ld=" + this.getLLVMExecutable("ld.lld"), "-Wl," + String.join((CharSequence)",", LinuxLinker.getLinkerFlags())));
            } else if (this.os == Driver.OS.DARWIN) {
                sulongArgs.add("-fuse-ld=/usr/bin/ld");
            }
        }
        return sulongArgs;
    }
}

