/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.netbeans;

import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class JavaDetailsProvider
extends DetailsProvider.Basic {
    private static final String FO_INDEXABLE = "org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable";
    private static final String INDEXABLE = "org.netbeans.modules.parsing.spi.indexing.Indexable";
    private static final String CLASSPATH_ENTRY = "org.netbeans.api.java.classpath.ClassPath$Entry";
    long lastHeapId;
    String lastSeparator;

    public JavaDetailsProvider() {
        super(FO_INDEXABLE, INDEXABLE, CLASSPATH_ENTRY);
    }

    @Override
    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (FO_INDEXABLE.equals(className)) {
            String root = DetailsUtils.getInstanceFieldString(instance, "root", heap);
            String relpath = DetailsUtils.getInstanceFieldString(instance, "relativePath", heap);
            if (root != null && relpath != null) {
                return root.concat(this.getFileSeparator(heap)).concat(relpath);
            }
        } else {
            if (INDEXABLE.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "delegate", heap);
            }
            if (CLASSPATH_ENTRY.equals(className)) {
                return DetailsUtils.getInstanceFieldString(instance, "url", heap);
            }
        }
        return null;
    }

    private String getFileSeparator(Heap heap) {
        if (this.lastHeapId != (long)System.identityHashCode(heap)) {
            this.lastSeparator = heap.getSystemProperties().getProperty("file.separator", "/");
        }
        return this.lastSeparator;
    }
}

