/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.model;

import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.BrowserUtils;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.ChildrenComputer;
import org.graalvm.visualvm.lib.profiler.heapwalk.model.HeapWalkerNode;

public abstract class AbstractHeapWalkerNode
extends HeapWalkerNode {
    private HeapWalkerNode parent;
    private Icon icon;
    private String name;
    private String type;
    private String value;
    private String size;
    private String retainedSize;
    private HeapWalkerNode[] children;
    private int mode = 1;
    private Map<Object, Integer> indexes;

    public AbstractHeapWalkerNode(HeapWalkerNode parent) {
        this(parent, parent == null ? 1 : parent.getMode());
    }

    public AbstractHeapWalkerNode(HeapWalkerNode parent, int mode) {
        this.parent = parent;
        this.mode = mode;
    }

    @Override
    public HeapWalkerNode getChild(int i) {
        return this.getChildren()[i];
    }

    @Override
    public HeapWalkerNode[] getChildren() {
        if (this.children == null) {
            this.children = this.computeChildren();
            this.indexes = null;
        }
        return this.children;
    }

    private Map<Object, Integer> getIndexes() {
        if (this.indexes == null) {
            HeapWalkerNode[] chldrn = this.getChildren();
            this.indexes = new HashMap<Object, Integer>(chldrn.length * 4 / 3);
            for (int i = 0; i < chldrn.length; ++i) {
                this.indexes.put((Object)chldrn[i], i);
            }
        }
        return this.indexes;
    }

    @Override
    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = this.computeIcon();
        }
        return this.icon;
    }

    public int getIndexOfChild(Object object) {
        Integer index = this.getIndexes().get(object);
        return index != null ? index : -1;
    }

    public boolean isLeaf() {
        return this.getNChildren() == 0;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    public int getNChildren() {
        if (this.getChildren() == null) {
            return 0;
        }
        return this.getChildren().length;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.computeName();
        }
        return this.name;
    }

    public void setParent(HeapWalkerNode parent) {
        this.parent = parent;
    }

    @Override
    public HeapWalkerNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public String getSimpleType() {
        return BrowserUtils.getSimpleType(this.getType());
    }

    @Override
    public String getType() {
        if (this.type == null) {
            this.type = this.computeType();
        }
        return this.type;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            this.value = this.computeValue();
        }
        return this.value;
    }

    @Override
    public String getDetails() {
        return null;
    }

    @Override
    public String getSize() {
        if (this.size == null) {
            this.size = this.computeSize();
        }
        return this.size;
    }

    @Override
    public String getRetainedSize() {
        if (this.retainedSize == null) {
            this.retainedSize = this.computeRetainedSize();
        }
        return this.retainedSize;
    }

    @Override
    public boolean currentlyHasChildren() {
        return this.children != null;
    }

    protected ChildrenComputer getChildrenComputer() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Object getNodeID() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof HeapWalkerNode)) {
            return false;
        }
        HeapWalkerNode n = (HeapWalkerNode)((Object)o);
        return this.getNodeID().equals(n.getNodeID());
    }

    public int hashCode() {
        return this.getNodeID().hashCode();
    }

    protected abstract Icon computeIcon();

    protected abstract String computeName();

    protected abstract String computeType();

    protected abstract String computeValue();

    protected abstract String computeSize();

    protected abstract String computeRetainedSize();

    protected void setChildren(HeapWalkerNode[] children) {
        this.changeChildren(children);
    }

    protected HeapWalkerNode[] computeChildren() {
        ChildrenComputer ch = this.getChildrenComputer();
        if (ch != null) {
            return BrowserUtils.lazilyCreateChildren(this, ch);
        }
        return new HeapWalkerNode[0];
    }

    void changeChildren(final HeapWalkerNode[] children) {
        Runnable childrenChanger = new Runnable(){

            @Override
            public void run() {
                AbstractHeapWalkerNode.access$002(AbstractHeapWalkerNode.this, children);
                AbstractHeapWalkerNode.this.indexes = null;
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(childrenChanger);
            }
            catch (Exception exception) {}
        } else {
            childrenChanger.run();
        }
    }

    static /* synthetic */ HeapWalkerNode[] access$002(AbstractHeapWalkerNode x0, HeapWalkerNode[] x1) {
        x0.children = x1;
        return x1;
    }
}

