/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.impl;

import java.io.File;
import java.io.IOException;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.JFRSnapshotSupport;

class JFRSnapshotImpl
extends JFRSnapshot {
    private final Storage storage;

    public JFRSnapshotImpl(File file) throws IOException {
        this(file, new Storage());
    }

    public JFRSnapshotImpl(File file, Storage storage) throws IOException {
        super(file);
        this.storage = storage;
    }

    public boolean supportsDelete() {
        return false;
    }

    protected Storage createStorage() {
        return this.storage;
    }

    public boolean supportsUserRemove() {
        return true;
    }

    protected void remove() {
        File file = this.getFile();
        if (JFRSnapshotSupport.getStorageDirectory().equals(file.getParentFile())) {
            Utils.delete((File)file, (boolean)true);
        }
        this.setFile(null);
        this.getStorage().deleteCustomPropertiesStorage();
    }
}

