/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.browser;

import java.util.List;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.JFRSnapshot;
import org.graalvm.visualvm.jfr.model.JFRDataDescriptor;
import org.graalvm.visualvm.jfr.model.JFREventTypeVisitor;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRModelFactory;
import org.graalvm.visualvm.jfr.views.browser.BrowserViewSupport;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.util.RequestProcessor;

class JFRSnapshotBrowserView
extends DataSourceView {
    private JFRModel model;

    JFRSnapshotBrowserView(JFRSnapshot snapshot) {
        super((DataSource)snapshot, "Browser", Icons.getImage((String)"GeneralIcons.Find"), 38, false);
    }

    protected void willBeAdded() {
        JFRSnapshot snapshot = (JFRSnapshot)this.getDataSource();
        this.model = JFRModelFactory.getJFRModelFor((DataSource)snapshot);
    }

    protected DataViewComponent createComponent() {
        if (this.model == null) {
            BrowserViewSupport.MasterViewSupport masterView = new BrowserViewSupport.MasterViewSupport(this.model){

                @Override
                void firstShown() {
                }

                @Override
                void reloadEvents() {
                }
            };
            return new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(true));
        }
        final BrowserViewSupport.EventsTableViewSupport eventsTable = new BrowserViewSupport.EventsTableViewSupport(){};
        final BrowserViewSupport.EventsTreeViewSupport eventsTree = new BrowserViewSupport.EventsTreeViewSupport(this.model.getEventsCount()){

            @Override
            void reloadEvents(JFREventVisitor visitor) {
                JFRSnapshotBrowserView.this.initialize(null, new JFREventVisitor[]{visitor});
            }

            @Override
            void eventsSelected(String eventType, long eventsCount, List<JFRDataDescriptor> dataDescriptors) {
                JFRSnapshotBrowserView.this.initialize(null, new JFREventVisitor[]{eventsTable.getVisitor(eventType, eventsCount, dataDescriptors)});
            }
        };
        BrowserViewSupport.MasterViewSupport masterView = new BrowserViewSupport.MasterViewSupport(this.model){

            @Override
            void firstShown() {
                JFRSnapshotBrowserView.this.initialize(eventsTree, new JFREventVisitor[]{this, eventsTree.getVisitor()});
            }

            @Override
            void reloadEvents() {
            }
        };
        DataViewComponent dvc = new DataViewComponent(masterView.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        dvc.configureDetailsView(new DataViewComponent.DetailsViewConfiguration(0.35, 0.0, -1.0, -1.0, -1.0, -1.0));
        dvc.addDetailsView(eventsTree.getDetailsView(), 1);
        dvc.addDetailsView(eventsTable.getDetailsView(), 2);
        return dvc;
    }

    private void initialize(final JFREventTypeVisitor typeVisitor, final JFREventVisitor ... visitors) {
        new RequestProcessor("JFR Events Browser Initializer").post(new Runnable(){

            @Override
            public void run() {
                if (typeVisitor != null) {
                    JFRSnapshotBrowserView.this.model.visitEventTypes(typeVisitor);
                }
                JFRSnapshotBrowserView.this.model.visitEvents(visitors);
            }
        });
    }
}

