/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.gc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.time.Duration;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.jfr.views.gc.GcNode;
import org.graalvm.visualvm.jfr.views.gc.GcRenderers;
import org.graalvm.visualvm.jfr.views.gc.JFRSnapshotGcViewProvider;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.components.HTMLLabel;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.components.HTMLTextAreaSearchUtils;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTableModel;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;

final class GcViewSupport {
    GcViewSupport() {
    }

    static class GcTlabConfigurationSupport
    extends JPanel
    implements JFREventVisitor {
        private volatile boolean initialized = false;
        private HTMLTextArea area;

        GcTlabConfigurationSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("TLAB configuration", null, 50, (JComponent)this, null);
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.GCTLABConfiguration".equals(typeName)) {
                try {
                    final StringBuilder s = new StringBuilder();
                    s.append("<table border='0' cellpadding='0' cellspacing='0' width='100%'>");
                    s.append("<tr><td nowrap><b>TLABs Used:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(event.getBoolean("usesTLABs")).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Minimum TLAB Size:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.bytesFormat().format(new Object[]{event.getLong("minTLABSize")})).append("</td></tr>");
                    s.append("<tr><td nowrap><b>TLAB Refill Waste Limit:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.bytesFormat().format(new Object[]{event.getLong("tlabRefillWasteLimit")})).append("</td></tr>");
                    s.append("</table>");
                    this.initialized = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            area.setText(s.toString());
                            area.setCaretPosition(0);
                        }
                    });
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public void done() {
            if (!this.initialized) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        area.setText("&lt;unknown&gt;");
                        area.setCaretPosition(0);
                        initialized = true;
                    }
                });
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)this.area), "South");
        }
    }

    static class GcSurvivorConfigurationSupport
    extends JPanel
    implements JFREventVisitor {
        private volatile boolean initialized = false;
        private HTMLTextArea area;

        GcSurvivorConfigurationSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Survivor configuration", null, 40, (JComponent)this, null);
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.GCSurvivorConfiguration".equals(typeName)) {
                try {
                    final StringBuilder s = new StringBuilder();
                    s.append("<table border='0' cellpadding='0' cellspacing='0' width='100%'>");
                    s.append("<tr><td nowrap><b>Initial Tenuring Threshold:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.numberFormat().format(event.getLong("initialTenuringThreshold"))).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Maximum Tenuring Threshold:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.numberFormat().format(event.getLong("maxTenuringThreshold"))).append("</td></tr>");
                    s.append("</table>");
                    this.initialized = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            area.setText(s.toString());
                            area.setCaretPosition(0);
                        }
                    });
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public void done() {
            if (!this.initialized) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        area.setText("&lt;unknown&gt;");
                        area.setCaretPosition(0);
                        initialized = true;
                    }
                });
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)this.area), "South");
        }
    }

    static class GcYoungGenConfigurationSupport
    extends JPanel
    implements JFREventVisitor {
        private volatile boolean initialized = false;
        private HTMLTextArea area;

        GcYoungGenConfigurationSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Young Generation configuration", null, 30, (JComponent)this, null);
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.YoungGenerationConfiguration".equals(typeName)) {
                try {
                    final StringBuilder s = new StringBuilder();
                    s.append("<table border='0' cellpadding='0' cellspacing='0' width='100%'>");
                    s.append("<tr><td nowrap><b>Minimum Size:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.bytesFormat().format(new Object[]{event.getLong("minSize")})).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Maximum Size:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.bytesFormat().format(new Object[]{event.getLong("maxSize")})).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Yount Generation Ratio:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.numberFormat().format(event.getLong("newRatio"))).append("</td></tr>");
                    s.append("</table>");
                    this.initialized = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            area.setText(s.toString());
                            area.setCaretPosition(0);
                        }
                    });
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public void done() {
            if (!this.initialized) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        area.setText("&lt;unknown&gt;");
                        area.setCaretPosition(0);
                        initialized = true;
                    }
                });
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)this.area), "South");
        }
    }

    static class GcHeapConfigurationSupport
    extends JPanel
    implements JFREventVisitor {
        private volatile boolean initialized = false;
        private HTMLTextArea area;

        GcHeapConfigurationSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Heap configuration", null, 20, (JComponent)this, null);
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.GCHeapConfiguration".equals(typeName)) {
                try {
                    final StringBuilder s = new StringBuilder();
                    s.append("<table border='0' cellpadding='0' cellspacing='0' width='100%'>");
                    s.append("<tr><td nowrap><b>Initial Size:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.bytesFormat().format(new Object[]{event.getLong("initialSize")})).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Minimum Size:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.bytesFormat().format(new Object[]{event.getLong("minSize")})).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Maximum Size:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.bytesFormat().format(new Object[]{event.getLong("maxSize")})).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Compressed Oops:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(event.getBoolean("usesCompressedOops")).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Compressed Oops Mode:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(event.getString("compressedOopsMode")).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Address Size:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.numberFormat().format(event.getLong("heapAddressBits"))).append(" bits</td></tr>");
                    s.append("<tr><td nowrap><b>Object Alignment:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.bytesFormat().format(new Object[]{event.getLong("objectAlignment")})).append("</td></tr>");
                    s.append("</table>");
                    this.initialized = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            area.setText(s.toString());
                            area.setCaretPosition(0);
                        }
                    });
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public void done() {
            if (!this.initialized) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        area.setText("&lt;unknown&gt;");
                        area.setCaretPosition(0);
                        initialized = true;
                    }
                });
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)this.area), "South");
        }
    }

    static class GcConfigurationSupport
    extends JPanel
    implements JFREventVisitor {
        private volatile boolean initialized = false;
        private HTMLTextArea area;

        GcConfigurationSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("GC configuration", null, 10, (JComponent)this, null);
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.GCConfiguration".equals(typeName)) {
                try {
                    final StringBuilder s = new StringBuilder();
                    s.append("<table border='0' cellpadding='0' cellspacing='0' width='100%'>");
                    s.append("<tr><td nowrap><b>Young GC:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(event.getString("youngCollector")).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Old GC:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(event.getString("oldCollector")).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Concurrent Threads:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.numberFormat().format(event.getLong("concurrentGCThreads"))).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Parallel Threads:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.numberFormat().format(event.getLong("parallelGCThreads"))).append("</td></tr>");
                    s.append("<tr><td nowrap><b>System.gc() Disabled:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(event.getBoolean("isExplicitGCDisabled")).append("</td></tr>");
                    s.append("<tr><td nowrap><b>System.gc() Concurrent:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(event.getBoolean("isExplicitGCConcurrent")).append("</td></tr>");
                    s.append("<tr><td nowrap><b>Uses Dynamic Threads:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(event.getBoolean("usesDynamicGCThreads")).append("</td></tr>");
                    s.append("<tr><td nowrap><b>GC Time Ratio:</b>&nbsp;&nbsp;&nbsp;&nbsp;</td><td width='100%'>").append(Formatters.numberFormat().format(event.getLong("gcTimeRatio"))).append("</td></tr>");
                    s.append("</table>");
                    this.initialized = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            area.setText(s.toString());
                            area.setCaretPosition(0);
                        }
                    });
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public void done() {
            if (!this.initialized) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        area.setText("&lt;unknown&gt;");
                        area.setCaretPosition(0);
                        initialized = true;
                    }
                });
            }
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea("<nobr><b>Progress:</b> reading data...</nobr>");
            this.area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
            this.add((Component)HTMLTextAreaSearchUtils.createSearchPanel((HTMLTextArea)this.area), "South");
        }
    }

    static final class DataViewSupport
    extends JPanel {
        private DataModel tableModel;
        private ProfilerTreeTable table;

        DataViewSupport() {
            this.initComponents();
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView("Data", null, 10, (JComponent)this, null);
        }

        void setData(GcNode root, boolean aggregated, boolean phases) {
            this.tableModel.setRoot((TreeNode)((Object)root));
            if (root.getChildCount() > 0) {
                this.table.setShowsRootHandles(aggregated || phases);
                if (aggregated) {
                    if (!this.table.isColumnVisible(4)) {
                        this.table.setColumnVisibility(4, true);
                    }
                } else if (this.table.isColumnVisible(4)) {
                    this.table.setColumnVisibility(4, false);
                }
            }
        }

        private void initComponents() {
            this.tableModel = new DataModel();
            this.table = new ProfilerTreeTable((ProfilerTreeTableModel)this.tableModel, true, true, new int[]{0});
            this.table.setRootVisible(false);
            this.table.setShowsRootHandles(true);
            this.table.setMainColumn(0);
            this.table.setFitWidthColumn(0);
            this.table.setSortColumn(1);
            this.table.setDefaultSortOrder(SortOrder.DESCENDING);
            this.table.setDefaultSortOrder(0, SortOrder.ASCENDING);
            GcRenderers.NameRenderer nameRenderer = new GcRenderers.NameRenderer();
            this.table.setTreeCellRenderer((ProfilerRenderer)nameRenderer);
            GcRenderers.GcIdRenderer gcidRenderer = new GcRenderers.GcIdRenderer();
            this.table.setColumnRenderer(1, (ProfilerRenderer)gcidRenderer);
            this.table.setDefaultSortOrder(1, SortOrder.ASCENDING);
            this.table.setDefaultColumnWidth(1, gcidRenderer.getPreferredWidth());
            this.table.setColumnVisibility(1, GcRenderers.GcIdRenderer.isInitiallyVisible());
            this.table.setSortColumn(1);
            GcRenderers.LongestPauseRenderer longestPauseRenderer = new GcRenderers.LongestPauseRenderer();
            this.table.setColumnRenderer(2, (ProfilerRenderer)longestPauseRenderer);
            this.table.setDefaultColumnWidth(2, longestPauseRenderer.getPreferredWidth());
            this.table.setColumnVisibility(2, GcRenderers.LongestPauseRenderer.isInitiallyVisible());
            GcRenderers.SumOfPausesRenderer sumOfPausesRenderer = new GcRenderers.SumOfPausesRenderer();
            this.table.setColumnRenderer(3, (ProfilerRenderer)sumOfPausesRenderer);
            this.table.setDefaultColumnWidth(3, sumOfPausesRenderer.getPreferredWidth());
            this.table.setColumnVisibility(3, GcRenderers.SumOfPausesRenderer.isInitiallyVisible());
            GcRenderers.CountRenderer countRenderer = new GcRenderers.CountRenderer();
            this.table.setColumnRenderer(4, (ProfilerRenderer)countRenderer);
            this.table.setDefaultColumnWidth(4, countRenderer.getPreferredWidth());
            this.table.setColumnVisibility(4, GcRenderers.CountRenderer.isInitiallyVisible());
            this.setLayout(new BorderLayout());
            this.add((Component)new ProfilerTableContainer((ProfilerTable)this.table, false, null), "Center");
        }

        private static class DataModel
        extends ProfilerTreeTableModel.Abstract {
            DataModel() {
                super((TreeNode)((Object)new GcNode.Root()));
            }

            public int getColumnCount() {
                return 5;
            }

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return JTree.class;
                    }
                    case 1: {
                        return Long.class;
                    }
                    case 2: {
                        return Duration.class;
                    }
                    case 3: {
                        return Duration.class;
                    }
                    case 4: {
                        return Long.class;
                    }
                }
                return null;
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return GcRenderers.NameRenderer.getDisplayName();
                    }
                    case 1: {
                        return GcRenderers.GcIdRenderer.getDisplayName();
                    }
                    case 2: {
                        return GcRenderers.LongestPauseRenderer.getDisplayName();
                    }
                    case 3: {
                        return GcRenderers.SumOfPausesRenderer.getDisplayName();
                    }
                    case 4: {
                        return GcRenderers.CountRenderer.getDisplayName();
                    }
                }
                return null;
            }

            public Object getValueAt(TreeNode node, int column) {
                if (node == null) {
                    return null;
                }
                GcNode fnode = (GcNode)((Object)node);
                switch (column) {
                    case 0: {
                        return fnode;
                    }
                    case 1: {
                        return this.toLong(fnode.gcid, -1L);
                    }
                    case 2: {
                        return fnode.longestPause;
                    }
                    case 3: {
                        return fnode.sumOfPauses;
                    }
                    case 4: {
                        return this.toLong(fnode.count, 0L);
                    }
                }
                return null;
            }

            public void setValueAt(Object o, TreeNode node, int column) {
            }

            public boolean isCellEditable(TreeNode node, int column) {
                return false;
            }

            private Long toLong(long value, long noValue) {
                return value == noValue ? null : Long.valueOf(value);
            }
        }
    }

    static abstract class MasterViewSupport
    extends JPanel {
        private Aggregation lastPrimary;
        private boolean lastPhase;
        private int prefHeight = -1;
        private JLabel firstLabel;
        private JComboBox firstCombo;
        private JComboBox secondCombo;
        private JCheckBox secondChoice;
        private JButton updateButton;
        private HTMLLabel statusValueLabel;

        MasterViewSupport(JFRModel model) {
            this.initComponents(model);
        }

        DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView("GC", null, (JComponent)this);
        }

        abstract void firstShown();

        abstract void changeAggregation(Aggregation var1, Aggregation var2);

        void showProgress() {
            this.updateButton.setEnabled(false);
            this.updateButton.setVisible(false);
            this.statusValueLabel.setVisible(true);
        }

        void hideProgress() {
            this.statusValueLabel.setVisible(false);
            this.updateButton.setVisible(true);
        }

        private void handleAggregationChanged(boolean updateSecondary) {
            if (updateSecondary) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.secondCombo.getModel();
                while (model.getSize() > 1) {
                    model.removeElementAt(1);
                }
            }
            this.updateButton.setEnabled(this.lastPrimary != this.firstCombo.getSelectedItem() || this.lastPhase != this.secondChoice.isSelected());
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            if (this.prefHeight == -1) {
                this.prefHeight = pref.height;
            } else {
                pref.height = this.prefHeight;
            }
            return pref;
        }

        private void initComponents(JFRModel model) {
            this.setOpaque(false);
            if (model == null) {
                this.setLayout(new BorderLayout());
                this.add((Component)MessageComponent.notAvailable(), "Center");
            } else if (!model.containsEvent(JFRSnapshotGcViewProvider.EventChecker.class)) {
                this.setLayout(new BorderLayout());
                this.add((Component)MessageComponent.noData("GC", JFRSnapshotGcViewProvider.EventChecker.checkedTypes()), "Center");
            } else {
                this.setLayout(new GridBagLayout());
                this.setBorder(BorderFactory.createEmptyBorder(11, 5, 20, 5));
                this.firstLabel = new JLabel();
                this.firstLabel.setText("Aggregation:");
                this.firstLabel.setOpaque(false);
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add((Component)this.firstLabel, constraints);
                this.firstCombo = new JComboBox<Object>(new Object[]{Aggregation.NONE, Aggregation.NAME, Aggregation.CAUSE});
                this.firstCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.handleAggregationChanged(true);
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 1;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 8, 0, 0);
                this.add((Component)this.firstCombo, constraints);
                this.secondCombo = new JComboBox<Object>(new Object[]{Aggregation.NONE, Aggregation.NAME, Aggregation.CAUSE});
                boolean hasPhases = model.containsEvent(JFRSnapshotGcViewProvider.EventChecker_Phases.class);
                this.secondChoice = new JCheckBox(hasPhases ? "Show GC Phases" : "Show GC Phases (no phases recorded)");
                this.secondChoice.setOpaque(false);
                this.secondChoice.setEnabled(hasPhases);
                this.secondChoice.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.handleAggregationChanged(false);
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 3;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 12, 0, 0);
                this.add((Component)this.secondChoice, constraints);
                this.lastPrimary = (Aggregation)((Object)this.firstCombo.getSelectedItem());
                this.lastPhase = this.secondChoice.isSelected();
                JSeparator updateSeparator = new JSeparator(1);
                updateSeparator.setOpaque(false);
                constraints = new GridBagConstraints();
                constraints.gridx = 4;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 12, 0, 0);
                this.add((Component)updateSeparator, constraints);
                this.updateButton = new JButton("Update Data");
                this.updateButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        updateButton.setEnabled(false);
                        lastPrimary = (Aggregation)((Object)firstCombo.getSelectedItem());
                        lastPhase = secondChoice.isSelected();
                        this.changeAggregation((Aggregation)((Object)firstCombo.getSelectedItem()), secondChoice.isSelected() ? Aggregation.PHASE : Aggregation.NONE);
                    }
                });
                constraints = new GridBagConstraints();
                constraints.gridx = 5;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 12, 0, 0);
                this.add((Component)this.updateButton, constraints);
                this.statusValueLabel = new HTMLLabel("<nobr><b>Progress:</b> reading data...</nobr>");
                constraints = new GridBagConstraints();
                constraints.gridx = 6;
                constraints.gridy = 2;
                constraints.gridwidth = 1;
                constraints.fill = 0;
                constraints.anchor = 17;
                constraints.insets = new Insets(4, 20, 0, 0);
                this.add((Component)this.statusValueLabel, constraints);
                this.statusValueLabel.setVisible(false);
                constraints = new GridBagConstraints();
                constraints.gridx = 7;
                constraints.gridy = 2;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.gridwidth = 0;
                constraints.fill = 1;
                constraints.anchor = 18;
                constraints.insets = new Insets(0, 0, 0, 0);
                this.add((Component)Spacer.create(), constraints);
                Dimension cpuD = this.firstCombo.getPreferredSize();
                Dimension memoryD = this.secondCombo.getPreferredSize();
                Dimension maxD = new Dimension(Math.max(cpuD.width, memoryD.width), Math.max(cpuD.height, memoryD.height));
                this.firstCombo.setPreferredSize(maxD);
                this.firstCombo.setMinimumSize(maxD);
                this.secondCombo.setPreferredSize(maxD);
                this.secondCombo.setMinimumSize(maxD);
                Dimension sepD = updateSeparator.getPreferredSize();
                sepD.height = maxD.height - 2;
                sepD.width = 5;
                updateSeparator.setPreferredSize(sepD);
                updateSeparator.setMinimumSize(sepD);
                this.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && this.isShowing()) {
                            this.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.firstShown();
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    static enum Aggregation {
        NONE{

            public String toString() {
                return "None";
            }
        }
        ,
        NAME{

            public String toString() {
                return "Name";
            }
        }
        ,
        CAUSE{

            public String toString() {
                return "Cause";
            }
        }
        ,
        PHASE{

            public String toString() {
                return "GC Phase";
            }
        };

    }
}

