/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.sampler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.Format;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.model.JFRStackTrace;
import org.graalvm.visualvm.jfr.model.JFRThread;
import org.graalvm.visualvm.jfr.utils.ValuesConverter;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.jfr.views.sampler.JFRSnapshotSamplerViewProvider;
import org.graalvm.visualvm.jfr.views.sampler.JFRThreadInfoSupport;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.StackTraceSnapshotBuilder;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.cpu.SnapshotCPUView;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.PercentRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.openide.util.NbBundle;

final class CPUSamplerViewSupport {
    CPUSamplerViewSupport() {
    }

    static final class ThreadsCPUViewSupport
    extends JPanel
    implements JFREventVisitor {
        private final boolean hasData;
        private Map<String, Double> eventData;
        private String[] names;
        private double[] values;
        private TreadsAllocTableModel tableModel;
        private ProfilerTable table;

        ThreadsCPUViewSupport(JFRModel model) {
            this.hasData = model.containsEvent(JFRSnapshotSamplerViewProvider.ThreadCPUChecker.class);
            this.initComponents();
        }

        @Override
        public void init() {
            if (this.hasData) {
                this.eventData = new HashMap<String, Double>();
            }
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if (!this.hasData) {
                return true;
            }
            if ("jdk.ThreadCPULoad".equals(typeName)) {
                try {
                    String threadName = event.getThread("eventThread").getName();
                    double utilization = 100.0 * (double)(event.getFloat("user") + event.getFloat("system"));
                    Double _utilization = this.eventData.get(threadName);
                    if (_utilization == null || _utilization < utilization) {
                        this.eventData.put(threadName, utilization);
                    }
                }
                catch (JFRPropertyNotAvailableException e) {
                    System.err.println(">>> " + e);
                }
            }
            return false;
        }

        @Override
        public void done() {
            if (this.hasData) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThreadsCPUViewSupport.access$102(this, new String[eventData.size()]);
                        ThreadsCPUViewSupport.access$302(this, new double[eventData.size()]);
                        int i = 0;
                        for (Map.Entry entry : eventData.entrySet()) {
                            ((ThreadsCPUViewSupport)this).names[i] = (String)entry.getKey();
                            ((ThreadsCPUViewSupport)this).values[i++] = (Double)entry.getValue();
                        }
                        tableModel.fireTableDataChanged();
                        eventData.clear();
                        eventData = null;
                    }
                });
            }
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(CPUSamplerViewSupport.class, (String)"LBL_ThreadAlloc"), null, 20, (JComponent)this, null);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (!this.hasData) {
                this.setLayout(new BorderLayout());
                this.add((Component)MessageComponent.noData("Thread CPU load", JFRSnapshotSamplerViewProvider.ThreadCPUChecker.checkedTypes()), "Center");
            } else {
                this.tableModel = new TreadsAllocTableModel();
                this.table = new ProfilerTable((TableModel)this.tableModel, true, true, null);
                this.table.setMainColumn(0);
                this.table.setFitWidthColumn(0);
                this.table.setSortColumn(1);
                this.table.setDefaultSortOrder(SortOrder.DESCENDING);
                this.table.setDefaultSortOrder(0, SortOrder.ASCENDING);
                HideableBarRenderer percentRenderer = new HideableBarRenderer((ProfilerRenderer)new PercentRenderer(){

                    protected String getValueString(Object value, int row, Format format) {
                        String s = super.getValueString(value, row, format);
                        if (s.startsWith("(")) {
                            s = s.substring(1, s.length() - 1);
                        }
                        return s;
                    }
                });
                LabelRenderer threadRenderer = new LabelRenderer();
                threadRenderer.setIcon(Icons.getIcon((String)"ProfilerIcons.Thread"));
                threadRenderer.setFont(threadRenderer.getFont().deriveFont(1));
                this.table.setColumnRenderer(0, (ProfilerRenderer)threadRenderer);
                this.table.setColumnRenderer(1, (ProfilerRenderer)percentRenderer);
                percentRenderer.setMaxValue(9999999L);
                this.table.setDefaultColumnWidth(1, percentRenderer.getOptimalWidth());
                percentRenderer.setMaxValue(100L);
                this.add((Component)new ProfilerTableContainer(this.table, false, null), "Center");
            }
        }

        static /* synthetic */ String[] access$102(ThreadsCPUViewSupport x0, String[] x1) {
            x0.names = x1;
            return x1;
        }

        static /* synthetic */ double[] access$302(ThreadsCPUViewSupport x0, double[] x1) {
            x0.values = x1;
            return x1;
        }

        private class TreadsAllocTableModel
        extends AbstractTableModel {
            private TreadsAllocTableModel() {
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return "Thread";
                }
                if (columnIndex == 1) {
                    return "Top Utilization";
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return String.class;
                }
                return Double.class;
            }

            @Override
            public int getRowCount() {
                return ThreadsCPUViewSupport.this.names == null ? 0 : ThreadsCPUViewSupport.this.names.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return ThreadsCPUViewSupport.this.names[rowIndex];
                }
                if (columnIndex == 1) {
                    return ThreadsCPUViewSupport.this.values[rowIndex];
                }
                return null;
            }
        }
    }

    private static class JFREventWithStack
    implements Comparable<JFREventWithStack> {
        private final long eventTime;
        private final Map<String, Object> threadInfo;

        JFREventWithStack(String type, JFREvent event, JFRModel model) throws JFRPropertyNotAvailableException {
            JFRThread thread;
            JFRStackTrace stack;
            if ("jdk.ThreadEnd".equals(type)) {
                stack = null;
            } else {
                stack = event.getStackTrace("eventStackTrace");
                if (stack == null) {
                    throw new JFRPropertyNotAvailableException("Must define stackTrace to include into sampled snapshot");
                }
            }
            boolean profilingEvent = "jdk.ExecutionSample".equals(type) || "jdk.NativeMethodSample".equals(type);
            JFRThread jFRThread = thread = profilingEvent ? event.getThread("sampledThread") : event.getThread("eventThread");
            if (thread == null) {
                throw new JFRPropertyNotAvailableException("Must define eventThread to include into sampled snapshot");
            }
            Instant eventTimeI = event.getInstant("eventTime");
            if (eventTimeI == null) {
                throw new JFRPropertyNotAvailableException("Must define eventTime to include into sampled snapshot");
            }
            this.eventTime = ValuesConverter.instantToRelativeNanos(eventTimeI, model);
            this.threadInfo = profilingEvent ? JFRThreadInfoSupport.getThreadInfo(thread, stack, event.getString("state")) : JFRThreadInfoSupport.getThreadInfo(thread, stack, JFREventWithStack.getState(type));
        }

        long getRelativeTime() {
            return this.eventTime;
        }

        long getThreadId() {
            return (Long)this.threadInfo.get("tid");
        }

        Map<String, Object> getThreadInfo() {
            return this.threadInfo;
        }

        boolean isThreadEnd() {
            return this.threadInfo.get("stack") == null;
        }

        private static Thread.State getState(String type) {
            switch (type) {
                case "jdk.JavaMonitorWait": {
                    return Thread.State.WAITING;
                }
                case "jdk.JavaMonitorEnter": {
                    return Thread.State.BLOCKED;
                }
                case "jdk.ThreadPark": {
                    return Thread.State.WAITING;
                }
                case "jdk.ThreadSleep": {
                    return Thread.State.TIMED_WAITING;
                }
            }
            return Thread.State.RUNNABLE;
        }

        @Override
        public int compareTo(JFREventWithStack o) {
            return Long.compare(this.eventTime, o.eventTime);
        }
    }

    static final class CPUViewSupport
    extends JPanel
    implements JFREventVisitor {
        private final JFRModel model;
        private final boolean hasData;
        private List<JFREventWithStack> data;
        private Set<String> ignoredEvents;

        CPUViewSupport(JFRModel model) {
            this.model = model;
            this.hasData = true;
            this.initComponents();
        }

        @Override
        public void init() {
            if (this.hasData) {
                this.data = new ArrayList<JFREventWithStack>();
                this.ignoredEvents = new HashSet<String>();
            }
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if (!this.hasData) {
                return true;
            }
            try {
                if (!this.ignoredEvents.contains(typeName)) {
                    this.data.add(new JFREventWithStack(typeName, event, this.model));
                }
            }
            catch (JFRPropertyNotAvailableException e) {
                this.ignoredEvents.add(typeName);
            }
            return false;
        }

        @Override
        public void done() {
            if (this.hasData) {
                StackTraceSnapshotBuilder builder = new StackTraceSnapshotBuilder();
                HashMap<Long, Map<String, Object>> threads = new HashMap<Long, Map<String, Object>>();
                Collections.sort(this.data);
                long baseTime = System.nanoTime();
                for (JFREventWithStack ev : this.data) {
                    if (ev.isThreadEnd()) {
                        threads.remove(ev.getThreadId());
                        continue;
                    }
                    threads.put(ev.getThreadId(), ev.getThreadInfo());
                    builder.addStacktrace((Map[])this.getAllThreads(threads), baseTime + ev.getRelativeTime());
                }
                this.data = null;
                this.ignoredEvents = null;
                threads = null;
                try {
                    final CPUResultsSnapshot snapshot = builder.createSnapshot(ValuesConverter.instantToMillis(this.model.getFirstEventTime()));
                    builder = null;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.removeAll();
                            this.add((Component)this.createView(snapshot), "Center");
                        }
                    });
                }
                catch (CPUResultsSnapshot.NoDataAvailableException ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.removeAll();
                            String msg = "<html><b>No CPU samples data recorded.</b><br><br><br>To analyze the CPU samples make sure the JFR snapshot contains events with stack trace information.<br><br></html>";
                            this.add((Component)MessageComponent.scrollable(msg), "Center");
                        }
                    });
                }
            }
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(CPUSamplerViewSupport.class, (String)"LBL_Cpu_samples"), null, 10, (JComponent)this, null);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
        }

        private SnapshotCPUView createView(CPUResultsSnapshot snapshot) {
            return new SnapshotCPUView(snapshot, true, null, null, null, null){

                protected boolean profileMethodEnabled() {
                    return false;
                }

                protected boolean profileMethodSupported() {
                    return false;
                }

                protected boolean profileClassSupported() {
                    return false;
                }

                protected boolean showSourceSupported() {
                    return false;
                }

                protected void showSource(ClientUtils.SourceCodeSelection value) {
                }

                protected void selectForProfiling(ClientUtils.SourceCodeSelection value) {
                }
            };
        }

        private Map<String, Object>[] getAllThreads(Map<Long, Map<String, Object>> threads) {
            Collection<Map<String, Object>> allThreds = threads.values();
            return allThreds.toArray(new Map[0]);
        }
    }
}

