/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayDump;
import org.graalvm.visualvm.lib.jfluid.heap.ClassDump;
import org.graalvm.visualvm.lib.jfluid.heap.HprofByteBuffer;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayLazyList;

class PrimitiveArrayDump
extends ArrayDump
implements PrimitiveArrayInstance {
    private static final int charSize = 2;

    PrimitiveArrayDump(ClassDump cls, long offset) {
        super(cls, offset);
    }

    @Override
    public long getSize() {
        long elementSize = this.dumpClass.getHprof().getValueSize(this.getType());
        return (long)(this.dumpClass.classDumpSegment.getMinimumInstanceSize() + HPROF_ARRAY_OVERHEAD) + elementSize * (long)this.getLength();
    }

    @Override
    public List getValues() {
        HprofByteBuffer dumpBuffer = this.dumpClass.getHprofBuffer();
        HprofHeap heap = this.dumpClass.getHprof();
        byte type = this.getType();
        long offset = this.getArrayStartOffset();
        return new PrimitiveArrayLazyList(dumpBuffer, this.getLength(), offset, heap.getValueSize(type), type);
    }

    char[] getChars(int start, int length) {
        assert (this.getType() == 5);
        char[] chars = new char[length];
        long offset = this.getArrayStartOffset() + (long)start * 2L;
        HprofByteBuffer dumpBuffer = this.dumpClass.getHprofBuffer();
        for (int i = 0; i < length; ++i) {
            chars[i] = dumpBuffer.getChar(offset + (long)(i * 2));
        }
        return chars;
    }

    byte[] getBytes(int start, int length) {
        assert (this.getType() == 8);
        byte[] bytes = new byte[length];
        long offset = this.getArrayStartOffset() + (long)start;
        HprofByteBuffer dumpBuffer = this.dumpClass.getHprofBuffer();
        for (int i = 0; i < length; ++i) {
            bytes[i] = dumpBuffer.get(offset + (long)i);
        }
        return bytes;
    }

    private long getArrayStartOffset() {
        int idSize = this.dumpClass.getHprofBuffer().getIDSize();
        return this.fileOffset + 1L + (long)idSize + 4L + 4L + 1L;
    }

    private byte getType() {
        HprofByteBuffer dumpBuffer = this.dumpClass.getHprofBuffer();
        int idSize = dumpBuffer.getIDSize();
        return dumpBuffer.get(this.fileOffset + 1L + (long)idSize + 4L + 4L);
    }
}

