/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.instrumentation;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.utils.Wildcards;

class RootMethods {
    String[] classNames;
    boolean[] classesWildcard;
    boolean[] markerMethods;
    String[] methodNames;
    String[] methodSignatures;

    RootMethods(ClientUtils.SourceCodeSelection[] roots) {
        this.classNames = new String[roots.length];
        this.methodNames = new String[roots.length];
        this.methodSignatures = new String[roots.length];
        this.classesWildcard = new boolean[roots.length];
        this.markerMethods = new boolean[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            ClientUtils.SourceCodeSelection s = roots[i];
            if (s.definedViaSourceLines()) {
                this.classNames = new String[]{s.getClassName()};
            } else if (s.definedViaMethodName()) {
                this.classNames[i] = s.getClassName().replace('.', '/').intern();
                String rootName = this.classNames[i];
                if (Wildcards.isPackageWildcard(rootName)) {
                    this.classesWildcard[i] = true;
                    this.classNames[i] = Wildcards.unwildPackage(rootName);
                } else {
                    this.methodNames[i] = s.getMethodName().intern();
                    this.methodSignatures[i] = s.getMethodSignature().intern();
                    this.classesWildcard[i] = false;
                }
            } else {
                this.methodSignatures = new String[0];
                this.methodNames = this.methodSignatures;
                this.classNames = this.methodSignatures;
            }
            this.markerMethods[i] = s.isMarkerMethod();
        }
    }

    List getRootClassNames() {
        if (this.classNames.length > 0) {
            ArrayList<String> rootClasses = new ArrayList<String>();
            for (int i = 0; i < this.classNames.length; ++i) {
                String name = this.classNames[i].replace('/', '.');
                if (rootClasses.contains(name)) continue;
                rootClasses.add(name);
            }
            return rootClasses;
        }
        return null;
    }
}

