/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;

public class ResultsSnapshot {
    protected static final Logger LOGGER = Logger.getLogger(ResultsSnapshot.class.getName());
    private static final int SNAPSHOT_VERSION = 1;
    protected long beginTime;
    protected long timeTaken;

    public ResultsSnapshot() {
    }

    protected ResultsSnapshot(long beginTime, long timeTaken) {
        this.beginTime = beginTime;
        this.timeTaken = timeTaken;
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public void readFromStream(DataInputStream in) throws IOException {
        int version = in.readInt();
        if (version != 1) {
            throw new IOException("Stored version not supported: " + version);
        }
        this.beginTime = in.readLong();
        this.timeTaken = in.readLong();
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public String toString() {
        return StringUtils.formatUserDate(new Date(this.timeTaken));
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeLong(this.beginTime);
        out.writeLong(this.timeTaken);
    }

    protected String debugLength(Object array) {
        if (array == null) {
            return "null";
        }
        if (array instanceof int[]) {
            return "" + ((int[])array).length;
        }
        if (array instanceof long[]) {
            return "" + ((long[])array).length;
        }
        if (array instanceof float[]) {
            return "" + ((float[])array).length;
        }
        if (array instanceof Object[]) {
            return "" + ((Object[])array).length;
        }
        return "Unknown";
    }

    private void debugValues() {
        LOGGER.finest("beginTime: " + this.beginTime);
        LOGGER.finest("timeTaken: " + this.timeTaken);
    }
}

