/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.cpu;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.results.FilterSortSupport;
import org.graalvm.visualvm.lib.jfluid.results.ResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.AllThreadsMergedCPUCCTContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUCCTClassContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUCCTContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUCCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsDiff;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.MethodIdMap;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNodeBacked;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNodeFree;

public class CPUResultsSnapshot
extends ResultsSnapshot {
    private static final String CPU_MSG = ResourceBundle.getBundle("org.graalvm.visualvm.lib.jfluid.results.cpu.Bundle").getString("CPUResultsSnapshot_CpuMsg");
    public static final int METHOD_LEVEL_VIEW = 0;
    public static final int CLASS_LEVEL_VIEW = 1;
    public static final int PACKAGE_LEVEL_VIEW = 2;
    protected Map threadIdMap;
    protected CPUCCTContainer[] allThreadsMergedCCTContainers;
    protected String[][] instrMethodClassesViews;
    protected String[] instrMethodNames;
    protected String[] instrMethodSignatures;
    protected PrestimeCPUCCTNode[] rootNode;
    protected CPUCCTContainer[][] threadCCTContainers;
    protected boolean collectingTwoTimeStamps;
    protected int nInstrMethods;
    private final Map<CCTNode, FilterSortSupport.Configuration> sortInfos = new WeakHashMap<CCTNode, FilterSortSupport.Configuration>();

    public CPUResultsSnapshot() {
        this.threadIdMap = new HashMap();
    }

    public CPUResultsSnapshot(long beginTime, long timeTaken, CPUCCTProvider cctProvider, boolean collectingTwoTimestamps, String[] instrClassNames, String[] instrMethodNames, String[] instrMethodSigs, int nInstrMethods) throws NoDataAvailableException {
        super(beginTime, timeTaken);
        this.collectingTwoTimeStamps = collectingTwoTimestamps;
        this.instrMethodClassesViews = new String[3][];
        this.instrMethodClassesViews[0] = instrClassNames;
        this.instrMethodNames = instrMethodNames;
        this.instrMethodSignatures = instrMethodSigs;
        this.nInstrMethods = nInstrMethods;
        CPUCCTContainer[] methodLevelCCTs = cctProvider.createPresentationCCTs(this);
        if (methodLevelCCTs == null || methodLevelCCTs.length == 0) {
            throw new NoDataAvailableException();
        }
        this.threadIdMap = new HashMap(methodLevelCCTs.length);
        for (int i = 0; i < methodLevelCCTs.length; ++i) {
            this.threadIdMap.put(methodLevelCCTs[i].threadId, i);
        }
        this.threadCCTContainers = new CPUCCTContainer[3][];
        this.threadCCTContainers[0] = methodLevelCCTs;
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public CPUCCTContainer getContainerForThread(int threadId, int view) {
        this.generateDataForView(view);
        return this.threadCCTContainers[view][this.getContainerIdForThreadId(threadId)];
    }

    public FlatProfileContainer getFlatProfile(int threadId, int view) {
        this.generateDataForView(view);
        if (threadId != -1) {
            return this.threadCCTContainers[view][this.getContainerIdForThreadId(threadId)].getFlatProfile();
        }
        return this.allThreadsMergedCCTContainers[view].getFlatProfile();
    }

    public FlatProfileContainer getFlatProfile(Collection<Integer> threads, int view) {
        if (threads == null) {
            return this.getFlatProfile(-1, view);
        }
        if (threads.size() == 1) {
            return this.getFlatProfile(threads.iterator().next(), view);
        }
        return this.createContainerForThreads(threads, view).getFlatProfile();
    }

    public String[] getInstrMethodClasses(int view) {
        return this.instrMethodClassesViews[view];
    }

    public String[] getInstrMethodNames() {
        return this.instrMethodNames;
    }

    public String[] getInstrMethodSignatures() {
        return this.instrMethodSignatures;
    }

    public String[] getMethodClassNameAndSig(int methodId, int view) {
        if (view == 0) {
            return new String[]{this.instrMethodClassesViews[0][methodId], this.instrMethodNames[methodId], this.instrMethodSignatures[methodId]};
        }
        return new String[]{this.instrMethodClassesViews[view][methodId], null, null};
    }

    public ClientUtils.SourceCodeSelection getSourceCodeSelection(int methodId, int view) {
        String[] sel = this.getMethodClassNameAndSig(methodId, view);
        return sel[1] != null ? new ClientUtils.SourceCodeSelection(sel[0], sel[1], sel[2]) : new ClientUtils.SourceCodeSelection(sel[0], "*", null);
    }

    public Map<Integer, ClientUtils.SourceCodeSelection> getMethodIDMap(int view) {
        HashMap<Integer, ClientUtils.SourceCodeSelection> map = new HashMap<Integer, ClientUtils.SourceCodeSelection>();
        for (int i = 0; i < this.instrMethodClassesViews[view].length; ++i) {
            map.put(i, this.getSourceCodeSelection(i, view));
        }
        return map;
    }

    public int getNInstrMethods() {
        return this.nInstrMethods;
    }

    public int getNThreads() {
        return this.threadCCTContainers[0].length;
    }

    public PrestimeCPUCCTNode getReverseCCT(int threadId, int methodId, int view) {
        this.generateDataForView(view);
        if (threadId >= 0) {
            return this.threadCCTContainers[view][this.getContainerIdForThreadId(threadId)].getReverseCCT(methodId);
        }
        if (threadId == -1) {
            return this.allThreadsMergedCCTContainers[view].getReverseCCT(methodId);
        }
        throw new IllegalArgumentException("!!! Cannot generate reverse CCT for threadId = " + threadId);
    }

    public PrestimeCPUCCTNode getRootNode(int view) {
        this.generateDataForView(view);
        return this.rootNode[view];
    }

    public PrestimeCPUCCTNode getRootNode(int view, Collection<Integer> threads, boolean merge) {
        if (threads == null) {
            if (!merge) {
                return this.fixNCalls(this.getRootNode(view));
            }
            int[] _threads = this.getThreadIds();
            threads = new ArrayList<Integer>(_threads.length);
            for (int t : _threads) {
                threads.add(t);
            }
        }
        PrestimeCPUCCTNode[] nodes = new PrestimeCPUCCTNode[threads.size()];
        Iterator<Integer> threadIds = threads.iterator();
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = this.getContainerForThread(threadIds.next(), view).getRootNode();
        }
        this.generateDataForView(view);
        return merge ? new PrestimeCPUCCTNodeBacked(this.threadCCTContainers[view][0], this.mergedChildren(nodes)) : this.fixNCalls(new PrestimeCPUCCTNodeBacked(this.threadCCTContainers[view][0], nodes));
    }

    private PrestimeCPUCCTNode fixNCalls(PrestimeCPUCCTNode root) {
        CCTNode[] children;
        CCTNode[] cCTNodeArray = children = root == null ? null : root.getChildren();
        if (children != null) {
            for (CCTNode node : children) {
                PrestimeCPUCCTNode _root = (PrestimeCPUCCTNode)node;
                _root.nCalls = 0;
                CCTNode[] _children = _root.getChildren();
                if (_children == null) continue;
                for (CCTNode child : _children) {
                    _root.addNCalls(((PrestimeCPUCCTNode)child).getNCalls());
                }
            }
        }
        return root;
    }

    private PrestimeCPUCCTNode[] mergedChildren(PrestimeCPUCCTNode[] nodes) {
        ArrayList<PrestimeCPUCCTNode> merged = new ArrayList<PrestimeCPUCCTNode>();
        for (PrestimeCPUCCTNode node : nodes) {
            CCTNode[] children = node.getChildren();
            if (children == null) continue;
            for (CCTNode n : children) {
                int idx = merged.indexOf(n);
                if (idx == -1) {
                    merged.add(((PrestimeCPUCCTNode)n).createCopy());
                    continue;
                }
                ((PrestimeCPUCCTNode)merged.get(idx)).merge(n);
            }
        }
        return merged.toArray(new PrestimeCPUCCTNode[0]);
    }

    public PrestimeCPUCCTNode getReverseRootNode(int view, Collection<Integer> threads, boolean merge) {
        int[] threadIds = this.getThreadIds();
        class ThreadNodeBacked
        extends PrestimeCPUCCTNodeBacked {
            final /* synthetic */ CPUCCTContainer val$containerF;
            final /* synthetic */ FlatProfileContainer val$flatF;
            final /* synthetic */ int val$threadIdF;
            final /* synthetic */ int val$view;

            ThreadNodeBacked() {
                this.val$containerF = cPUCCTContainer;
                this.val$flatF = flatProfileContainer;
                this.val$threadIdF = n;
                this.val$view = n2;
                super(cPUCCTContainer, null);
                this.nCalls = (int)this.val$flatF.getNTotalInvocations();
                this.totalTime0 = this.val$containerF.getWholeGraphNetTime0();
                this.totalTime1 = this.val$containerF.isCollectingTwoTimeStamps() ? this.val$containerF.getWholeGraphNetTime1() : 0L;
                this.nChildren = this.val$flatF.getNRows();
            }

            @Override
            PrestimeCPUCCTNode createCopy() {
                ThreadNodeBacked copy = new ThreadNodeBacked();
                this.setupCopy(copy);
                return copy;
            }

            public PrestimeCPUCCTNode[] getChildren() {
                if (this.nChildren == 0) {
                    return null;
                }
                if (this.children == null) {
                    this.children = new PrestimeCPUCCTNode[this.val$flatF.getNRows()];
                    for (int m = 0; m < this.children.length; ++m) {
                        int mF = m;
                        int methodIdF = this.val$flatF.getMethodIdAtRow(m);
                        class ReverseNodeBacked
                        extends PrestimeCPUCCTNodeBacked {
                            final /* synthetic */ int val$methodIdF;
                            final /* synthetic */ int val$mF;

                            ReverseNodeBacked() {
                                this.val$methodIdF = n;
                                this.val$mF = n2;
                                this.nChildren = 1;
                                this.container = container;
                                this.methodId = this.val$methodIdF;
                                this.nCalls = val$flatF.getNInvocationsAtRow(this.val$mF);
                                this.totalTime0 = val$flatF.getTotalTimeInMcs0AtRow(this.val$mF);
                                this.totalTime1 = val$flatF.isCollectingTwoTimeStamps() ? val$flatF.getTotalTimeInMcs1AtRow(this.val$mF) : 0L;
                                this.parent = this;
                            }

                            @Override
                            PrestimeCPUCCTNode createCopy() {
                                ReverseNodeBacked copy = new ReverseNodeBacked();
                                this.setupCopy(copy);
                                return copy;
                            }

                            public PrestimeCPUCCTNode[] getChildren() {
                                if (this.nChildren == 0) {
                                    return null;
                                }
                                if (this.children == null) {
                                    PrestimeCPUCCTNode r = CPUResultsSnapshot.this.getReverseCCT(val$threadIdF, this.val$methodIdF, val$view);
                                    this.children = r.children;
                                    int n = this.nChildren = this.children == null ? 0 : this.children.length;
                                    if (this.nChildren > 0) {
                                        for (PrestimeCPUCCTNode ch : this.children) {
                                            ch.parent = this;
                                        }
                                    }
                                }
                                return this.children;
                            }
                        }
                        this.children[m] = new ReverseNodeBacked();
                    }
                }
                return this.children;
            }
        }
        ArrayList<ThreadNodeBacked> nodes = new ArrayList<ThreadNodeBacked>();
        for (int i = 0; i < threadIds.length; ++i) {
            int threadIdF = threadIds[i];
            if (threads != null && !threads.contains(threadIdF)) continue;
            CPUCCTContainer containerF = this.getContainerForThread(threadIdF, view);
            FlatProfileContainer flatF = containerF.getFlatProfile();
            nodes.add(new ThreadNodeBacked());
        }
        this.generateDataForView(view);
        PrestimeCPUCCTNode[] _nodes = nodes.toArray(new PrestimeCPUCCTNode[0]);
        PrestimeCPUCCTNodeBacked root = new PrestimeCPUCCTNodeBacked(this.threadCCTContainers[view][0], merge ? this.mergedChildren(_nodes) : _nodes);
        return this.fixNCalls(root);
    }

    public FilterSortSupport.Configuration getFilterSortInfo(CCTNode node) {
        return this.sortInfo(node);
    }

    private FilterSortSupport.Configuration sortInfo(CCTNode node) {
        while (node.getParent() != null) {
            node = node.getParent();
        }
        FilterSortSupport.Configuration config = this.sortInfos.get(node);
        if (config == null) {
            config = new FilterSortSupport.Configuration();
            this.sortInfos.put(node, config);
        }
        return config;
    }

    public void filterForward(String filter, int filterType, PrestimeCPUCCTNodeBacked root) {
    }

    public void filterReverse(String filter, int filterType, PrestimeCPUCCTNodeFree root, int view) {
    }

    public int[] getThreadIds() {
        int[] ret = new int[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            ret[i] = this.threadCCTContainers[0][i].threadId;
        }
        return ret;
    }

    public String getThreadNameForId(int threadId) {
        return this.getThreadNames()[this.getContainerIdForThreadId(threadId)];
    }

    public String[] getThreadNames() {
        String[] ret = new String[this.threadCCTContainers[0].length];
        for (int i = 0; i < this.threadCCTContainers[0].length; ++i) {
            ret[i] = this.threadCCTContainers[0][i].threadName;
        }
        return ret;
    }

    public CPUResultsSnapshot createDiff(CPUResultsSnapshot snapshot) {
        if (!(snapshot instanceof CPUResultsSnapshot)) {
            return null;
        }
        return new CPUResultsDiff(this, snapshot);
    }

    void readFromSnapshot(CPUResultsSnapshot s) {
        this.beginTime = s.beginTime;
        this.timeTaken = s.timeTaken;
        this.collectingTwoTimeStamps = s.collectingTwoTimeStamps;
        this.nInstrMethods = s.nInstrMethods;
        this.instrMethodClassesViews = s.instrMethodClassesViews;
        this.instrMethodNames = s.instrMethodNames;
        this.instrMethodSignatures = s.instrMethodSignatures;
        this.threadCCTContainers = new CPUCCTContainer[3][];
        CPUCCTContainer[] scontainers = s.threadCCTContainers[0];
        int nThreads = scontainers.length;
        CPUCCTContainer[] containers = new CPUCCTContainer[nThreads];
        this.threadCCTContainers[0] = containers;
        this.threadIdMap = s.threadIdMap;
        for (int i = 0; i < nThreads; ++i) {
            containers[i] = new CPUCCTContainer(this);
            containers[i].threadId = scontainers[i].threadId;
            containers[i].threadName = scontainers[i].threadName;
            containers[i].collectingTwoTimeStamps = scontainers[i].collectingTwoTimeStamps;
            containers[i].compactData = scontainers[i].compactData;
            containers[i].childOfsSize = scontainers[i].childOfsSize;
            containers[i].nodeSize = scontainers[i].nodeSize;
            containers[i].wholeGraphGrossTimeAbs = scontainers[i].wholeGraphGrossTimeAbs;
            containers[i].wholeGraphGrossTimeThreadCPU = scontainers[i].wholeGraphGrossTimeThreadCPU;
            containers[i].timeInInjectedCodeInAbsCounts = scontainers[i].timeInInjectedCodeInAbsCounts;
            containers[i].timeInInjectedCodeInThreadCPUCounts = scontainers[i].timeInInjectedCodeInThreadCPUCounts;
            containers[i].wholeGraphPureTimeAbs = scontainers[i].wholeGraphPureTimeAbs;
            containers[i].wholeGraphPureTimeThreadCPU = scontainers[i].wholeGraphPureTimeThreadCPU;
            containers[i].wholeGraphNetTime0 = scontainers[i].wholeGraphNetTime0;
            containers[i].wholeGraphNetTime1 = scontainers[i].wholeGraphNetTime1;
            containers[i].totalInvNo = scontainers[i].totalInvNo;
            containers[i].displayWholeThreadCPUTime = scontainers[i].displayWholeThreadCPUTime;
            containers[i].rootNode = new PrestimeCPUCCTNodeBacked(containers[i], null, 0);
            if (containers[i].getMethodIdForNodeOfs(0) != 0) continue;
            containers[i].rootNode.setThreadNode();
        }
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        this.collectingTwoTimeStamps = in.readBoolean();
        this.nInstrMethods = in.readInt();
        this.instrMethodClassesViews = new String[3][];
        String[] classNames = new String[this.nInstrMethods];
        this.instrMethodClassesViews[0] = classNames;
        this.instrMethodNames = new String[this.nInstrMethods];
        this.instrMethodSignatures = new String[this.nInstrMethods];
        for (int i = 0; i < this.nInstrMethods; ++i) {
            classNames[i] = in.readUTF();
            this.instrMethodNames[i] = in.readUTF();
            this.instrMethodSignatures[i] = in.readUTF();
        }
        int nThreads = in.readInt();
        this.threadCCTContainers = new CPUCCTContainer[3][];
        CPUCCTContainer[] containers = new CPUCCTContainer[nThreads];
        this.threadCCTContainers[0] = containers;
        for (int i = 0; i < nThreads; ++i) {
            containers[i] = new CPUCCTContainer(this);
            containers[i].readFromStream(in);
            this.threadIdMap.put(containers[i].threadId, i);
        }
        this.allThreadsMergedCCTContainers = new CPUCCTContainer[3];
        this.rootNode = new PrestimeCPUCCTNode[3];
        this.rootNode[0] = this.createRootNodeForAllThreads(0);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public void saveSortParams(int sortBy, boolean sortOrder, CCTNode node) {
        FilterSortSupport.Configuration config = this.sortInfo(node);
        config.setSortInfo(sortBy, sortOrder);
    }

    @Override
    public String toString() {
        return MessageFormat.format(CPU_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        out.writeBoolean(this.collectingTwoTimeStamps);
        out.writeInt(this.nInstrMethods);
        String[] classNames = this.instrMethodClassesViews[0];
        for (int i = 0; i < this.nInstrMethods; ++i) {
            out.writeUTF(classNames[i]);
            out.writeUTF(this.instrMethodNames[i]);
            out.writeUTF(this.instrMethodSignatures[i]);
        }
        CPUCCTContainer[] containers = this.threadCCTContainers[0];
        int nThreads = containers.length;
        out.writeInt(nThreads);
        for (int i = 0; i < nThreads; ++i) {
            containers[i].writeToStream(out);
        }
    }

    private int getContainerIdForThreadId(int threadId) {
        Integer tid = threadId;
        Integer cId = null;
        if (this.threadIdMap.containsKey(tid)) {
            cId = (Integer)this.threadIdMap.get(tid);
        }
        return cId != null ? cId : 0;
    }

    protected PrestimeCPUCCTNode createRootNodeForAllThreads(int view) {
        this.generateDataForView(view);
        CPUCCTContainer[] ccts = this.threadCCTContainers[view];
        int len = ccts.length;
        PrestimeCPUCCTNode[] threadNodes = new PrestimeCPUCCTNode[len];
        for (int i = 0; i < len; ++i) {
            PrestimeCPUCCTNode tRootNode = ccts[i].getRootNode();
            threadNodes[i] = !tRootNode.isThreadNode() ? new PrestimeCPUCCTNodeBacked(ccts[i], new PrestimeCPUCCTNode[]{tRootNode}) : tRootNode;
        }
        this.allThreadsMergedCCTContainers[view] = new AllThreadsMergedCPUCCTContainer(this, threadNodes, view);
        return this.allThreadsMergedCCTContainers[view].getRootNode();
    }

    protected CPUCCTContainer createContainerForThreads(Collection<Integer> threads, int view) {
        this.generateDataForView(view);
        CPUCCTContainer[] ccts = this.threadCCTContainers[view];
        PrestimeCPUCCTNode[] threadNodes = new PrestimeCPUCCTNode[threads.size()];
        int threadIdx = 0;
        for (int i = 0; i < ccts.length; ++i) {
            if (!threads.contains(ccts[i].getThreadId())) continue;
            PrestimeCPUCCTNode tRootNode = ccts[i].getRootNode();
            if (tRootNode.isThreadNode()) {
                threadNodes[threadIdx++] = tRootNode;
                continue;
            }
            threadNodes[threadIdx++] = new PrestimeCPUCCTNodeBacked(ccts[i], new PrestimeCPUCCTNode[]{tRootNode});
        }
        return new AllThreadsMergedCPUCCTContainer(this, threadNodes, view);
    }

    private void debugValues() {
        LOGGER.log(Level.FINEST, "collectingTwoTimeStamps: {0}", this.collectingTwoTimeStamps);
        LOGGER.log(Level.FINEST, "threadCCTContainers.length: {0}", this.debugLength(this.threadCCTContainers));
        LOGGER.log(Level.FINEST, "allThreadsMergedCCTContainers.length: {0}", this.debugLength(this.allThreadsMergedCCTContainers));
        LOGGER.log(Level.FINEST, "rootNode.length: {0}", this.debugLength(this.rootNode));
        LOGGER.log(Level.FINEST, "instrMethodClassesViews.length: {0}", this.debugLength(this.instrMethodClassesViews));
        LOGGER.log(Level.FINEST, "instrMethodNames.length: {0}", this.debugLength(this.instrMethodNames));
        LOGGER.log(Level.FINEST, "instrMethodSignatures.length: {0}", this.debugLength(this.instrMethodSignatures));
        LOGGER.log(Level.FINEST, "nInstrMethods: {0}", this.nInstrMethods);
    }

    private void generateDataForView(int view) {
        if (this.threadCCTContainers[view] == null) {
            MethodIdMap methodIdMap = new MethodIdMap(this.instrMethodClassesViews[0], this.nInstrMethods, view);
            int len = this.threadCCTContainers[0].length;
            this.threadCCTContainers[view] = new CPUCCTContainer[len];
            for (int i = 0; i < len; ++i) {
                this.threadCCTContainers[view][i] = new CPUCCTClassContainer(this.threadCCTContainers[0][i], methodIdMap, view);
            }
            this.rootNode[view] = this.createRootNodeForAllThreads(view);
            this.instrMethodClassesViews[view] = methodIdMap.getInstrClassesOrPackages();
        }
    }

    public static class NoDataAvailableException
    extends Exception {
    }
}

