/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.TreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;

public class ClassHierarchyPlugin
extends HeapViewPlugin {
    private static final JavaClass EMPTY_CLASS = new EmptyJavaClass();
    private final Heap heap;
    private JavaClass selected;
    private final TreeTableView objectsView;

    public ClassHierarchyPlugin(HeapContext context, HeapViewerActions actions) {
        super(Bundle.ClassHierarchyPlugin_Name(), Bundle.ClassHierarchyPlugin_Description(), Icons.getIcon((String)"HeapWalkerIcons.Classes"));
        this.heap = context.getFragment().getHeap();
        this.objectsView = new TreeTableView("java_objects_hierarchy", context, actions, TreeTableViewColumn.classesPlain(this.heap)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                JavaClass javaClass;
                TreeTableView treeTableView = ClassHierarchyPlugin.this.objectsView;
                synchronized (treeTableView) {
                    javaClass = ClassHierarchyPlugin.this.selected;
                }
                if (javaClass != null) {
                    String className;
                    JavaClass plainClass;
                    if (javaClass == EMPTY_CLASS) {
                        return new HeapViewerNode[]{new TextNode(Bundle.ClassHierarchyPlugin_NoInformation())};
                    }
                    if (javaClass.isArray() && (plainClass = heap.getJavaClassByName(className = javaClass.getName().replace("[]", ""))) != null) {
                        javaClass = plainClass;
                    }
                    SuperClassNode node = null;
                    SuperClassNode firstNode = null;
                    SuperClassNode previousNode = null;
                    Thread worker = Thread.currentThread();
                    while (javaClass != null) {
                        node = new SuperClassNode(javaClass);
                        if (firstNode == null) {
                            firstNode = node;
                        } else {
                            previousNode.setChildren(new HeapViewerNode[]{node});
                        }
                        javaClass = javaClass.getSuperClass();
                        previousNode = node;
                        if (!worker.isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                    node.setChildren(HeapViewerNode.NO_NODES);
                    return new HeapViewerNode[]{firstNode};
                }
                return new HeapViewerNode[]{new TextNode(Bundle.ClassHierarchyPlugin_NoSelection())};
            }

            @Override
            protected void childrenChanged() {
                RootNode root = this.getRoot();
                while (root != null) {
                    this.expandNode(root);
                    root = root.getNChildren() > 0 ? root.getChild(0) : null;
                }
            }
        };
    }

    @Override
    protected JComponent createComponent() {
        return this.objectsView.getComponent();
    }

    @Override
    protected void closed() {
        this.objectsView.closed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        JavaClass sel;
        JavaClass javaClass = sel = node == null ? null : HeapViewerNode.getValue(node, DataType.CLASS, this.heap);
        if (sel != null && sel.getSuperClass() == null && !"java.lang.Object".equals(sel.getName())) {
            sel = EMPTY_CLASS;
        }
        TreeTableView treeTableView = this.objectsView;
        synchronized (treeTableView) {
            if (Objects.equals(this.selected, sel)) {
                return;
            }
            this.selected = sel;
        }
        this.objectsView.reloadView();
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        @Override
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (JavaHeapFragment.isJavaHeap(context)) {
                return new ClassHierarchyPlugin(context, actions);
            }
            return null;
        }
    }

    private static class EmptyJavaClass
    implements JavaClass {
        private EmptyJavaClass() {
        }

        public Object getValueOfStaticField(String name) {
            return null;
        }

        public long getAllInstancesSize() {
            return -1L;
        }

        public boolean isArray() {
            return false;
        }

        public Instance getClassLoader() {
            return null;
        }

        public List getFields() {
            return null;
        }

        public int getInstanceSize() {
            return -1;
        }

        public List getInstances() {
            return null;
        }

        public Iterator getInstancesIterator() {
            return null;
        }

        public int getInstancesCount() {
            return -1;
        }

        public long getRetainedSizeByClass() {
            return -1L;
        }

        public long getJavaClassId() {
            return -1L;
        }

        public String getName() {
            return null;
        }

        public List getStaticFieldValues() {
            return null;
        }

        public Collection getSubClasses() {
            return null;
        }

        public JavaClass getSuperClass() {
            return null;
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return -1;
        }
    }

    private static class SuperClassNode
    extends ClassNode {
        SuperClassNode(JavaClass javaClass) {
            super(javaClass);
        }

        @Override
        protected void setChildren(HeapViewerNode[] ch) {
            super.setChildren(ch);
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }
    }
}

