/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.util.Map;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.ClassNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.ClassesContainer;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstanceNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.InstanceReferenceNode;
import org.graalvm.visualvm.heapviewer.java.InstanceReferenceNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.InstancesContainer;
import org.graalvm.visualvm.heapviewer.java.LocalObjectNode;
import org.graalvm.visualvm.heapviewer.java.LocalObjectNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.PackageNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.PrimitiveNode;
import org.graalvm.visualvm.heapviewer.java.PrimitiveNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.StackFrameNode;
import org.graalvm.visualvm.heapviewer.java.StackFrameNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.ThreadNode;
import org.graalvm.visualvm.heapviewer.java.ThreadNodeRenderer;
import org.graalvm.visualvm.heapviewer.java.impl.GCTypeNode;
import org.graalvm.visualvm.heapviewer.java.impl.PathToGCRootPlugin;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;

public class JavaNodesRendererProvider
extends HeapViewerRenderer.Provider {
    @Override
    public boolean supportsView(HeapContext context, String viewID) {
        return true;
    }

    @Override
    public void registerRenderers(Map<Class<? extends HeapViewerNode>, HeapViewerRenderer> renderers, HeapContext context) {
        Heap heap = context.getFragment().getHeap();
        PackageNodeRenderer packageRenderer = new PackageNodeRenderer(heap);
        renderers.put(ClassesContainer.Objects.class, packageRenderer);
        renderers.put(ClassesContainer.Nodes.class, packageRenderer);
        renderers.put(ClassesContainer.ContainerNodes.class, packageRenderer);
        ClassNodeRenderer classRenderer = new ClassNodeRenderer(heap);
        renderers.put(ClassNode.class, classRenderer);
        renderers.put(InstancesContainer.Objects.class, classRenderer);
        renderers.put(InstancesContainer.Nodes.class, classRenderer);
        renderers.put(InstanceNode.class, new InstanceNodeRenderer(heap));
        renderers.put(InstanceReferenceNode.class, new InstanceReferenceNodeRenderer(heap));
        renderers.put(PrimitiveNode.class, new PrimitiveNodeRenderer());
        renderers.put(ThreadNode.class, new ThreadNodeRenderer(heap));
        renderers.put(StackFrameNode.class, new StackFrameNodeRenderer());
        renderers.put(LocalObjectNode.class, new LocalObjectNodeRenderer(heap));
        renderers.put(GCTypeNode.class, new GCTypeNode.Renderer());
        renderers.put(PathToGCRootPlugin.GCRootNode.class, new PathToGCRootPlugin.GCRootNode.Renderer(heap));
    }
}

