/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.java.impl.FilterUtils;
import org.graalvm.visualvm.heapviewer.java.impl.JavaClassesProvider;
import org.graalvm.visualvm.heapviewer.java.impl.JavaDiffDumpSelector;
import org.graalvm.visualvm.heapviewer.java.impl.JavaDiffObjectsView;
import org.graalvm.visualvm.heapviewer.java.impl.JavaInstancesProvider;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.ui.PluggableTreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.ActionPopupButton;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.openide.util.RequestProcessor;

public class JavaObjectsView
extends HeapViewerFeature {
    private static final TreeTableView.ColumnConfiguration CCONF_CLASS = new TreeTableView.ColumnConfiguration(DataType.COUNT, null, DataType.COUNT, SortOrder.DESCENDING, Boolean.FALSE);
    private static final TreeTableView.ColumnConfiguration CCONF_INSTANCE = new TreeTableView.ColumnConfiguration(null, DataType.COUNT, DataType.OWN_SIZE, SortOrder.DESCENDING, null);
    private static final TreeTableView.ColumnConfiguration CCONF_PRES1 = new TreeTableView.ColumnConfiguration(DataType.COUNT, null, DataType.COUNT, SortOrder.DESCENDING, Boolean.TRUE);
    private static final TreeTableView.ColumnConfiguration CCONF_PRES2 = new TreeTableView.ColumnConfiguration(DataType.OWN_SIZE, null, DataType.OWN_SIZE, SortOrder.DESCENDING, Boolean.TRUE);
    private static final TreeTableView.ColumnConfiguration CCONF_PRES3 = new TreeTableView.ColumnConfiguration(DataType.OWN_SIZE, DataType.COUNT, DataType.OWN_SIZE, SortOrder.DESCENDING, Boolean.TRUE);
    private static final TreeTableView.ColumnConfiguration CCONF_PRES4 = new TreeTableView.ColumnConfiguration(DataType.RETAINED_SIZE, DataType.COUNT, DataType.RETAINED_SIZE, SortOrder.DESCENDING, Boolean.TRUE);
    private static final String FEATURE_ID = "java_objects";
    private final HeapContext context;
    private final HeapViewerActions actions;
    private final PluggableTreeTableView objectsView;
    private ProfilerToolbar toolbar;
    private Preset preset = Preset.ALL_OBJECTS;
    private Aggregation aggregation = Aggregation.CLASSES;
    private ActionPopupButton apbPreset;
    private JToggleButton tbType;
    private JToggleButton tbPackages;
    private JToggleButton tbClasses;
    private JToggleButton tbInstances;
    private volatile boolean skipReload = false;
    private Runnable dominatorsRefresher;

    public JavaObjectsView(HeapContext context, HeapViewerActions actions) {
        super(FEATURE_ID, Bundle.JavaObjectsView_Name(), Bundle.JavaObjectsView_Description(), Icons.getIcon((String)"LanguageIcons.Class"), 200);
        this.context = context;
        this.actions = actions;
        final Heap heap = context.getFragment().getHeap();
        this.objectsView = new PluggableTreeTableView(FEATURE_ID, context, actions, TreeTableViewColumn.classes(heap, true)){

            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap2, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                switch (JavaObjectsView.this.getPreset()) {
                    case ALL_OBJECTS: {
                        switch (JavaObjectsView.this.getAggregation()) {
                            case PACKAGES: {
                                return JavaClassesProvider.getHeapPackages(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress);
                            }
                            case CLASSES: {
                                return JavaClassesProvider.getHeapClasses(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress);
                            }
                        }
                        return JavaInstancesProvider.getHeapInstances(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress);
                    }
                    case DOMINATORS: {
                        switch (JavaObjectsView.this.getAggregation()) {
                            case PACKAGES: {
                                return JavaClassesProvider.getHeapDominators(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 2);
                            }
                            case CLASSES: {
                                return JavaClassesProvider.getHeapDominators(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 1);
                            }
                        }
                        return JavaClassesProvider.getHeapDominators(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 0);
                    }
                    case GC_ROOTS: {
                        switch (JavaObjectsView.this.getAggregation()) {
                            case TYPES: {
                                return JavaClassesProvider.getHeapGCRoots(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 3);
                            }
                            case PACKAGES: {
                                return JavaClassesProvider.getHeapGCRoots(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 2);
                            }
                            case CLASSES: {
                                return JavaClassesProvider.getHeapGCRoots(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 1);
                            }
                        }
                        return JavaClassesProvider.getHeapGCRoots(root, heap2, viewID, viewFilter, dataTypes, sortOrders, progress, 0);
                    }
                }
                return HeapViewerNode.NO_NODES;
            }

            @Override
            protected JComponent createComponent() {
                JComponent comp = super.createComponent();
                this.setFilterComponent(FilterUtils.createFilterPanel(this));
                return comp;
            }

            @Override
            protected void populatePopupLast(HeapViewerNode node, JPopupMenu popup) {
                super.populatePopupLast(node, popup);
                JavaClass javaClass = HeapViewerNode.getValue(node, DataType.CLASS, heap);
                final String className = javaClass == null || javaClass.isArray() ? null : javaClass.getName();
                popup.add(new JMenuItem(Bundle.JavaObjectsView_FilterSubclasses()){
                    {
                        super(x0);
                        this.setEnabled(className != null);
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        JComponent filterComponent = this.getFilterComponent();
                        filterComponent.setVisible(true);
                        FilterUtils.filterSubclasses(className, filterComponent);
                    }
                });
            }
        };
    }

    @Override
    public JComponent getComponent() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.objectsView.getComponent();
    }

    @Override
    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    @Override
    protected void closed() {
        this.objectsView.closed();
    }

    void configureClassesByInstancesCount() {
        try {
            this.objectsView.configureColumns(CCONF_PRES1);
            if (this.apbPreset == null) {
                this.preset = Preset.ALL_OBJECTS;
            } else if (this.preset != Preset.ALL_OBJECTS) {
                this.skipReload = true;
                this.setPreset(Preset.ALL_OBJECTS);
                this.apbPreset.selectAction(this.preset.ordinal());
            }
            if (this.tbClasses == null) {
                this.skipReload = true;
                this.setAggregation(Aggregation.CLASSES, null);
            } else if (!this.tbClasses.isSelected()) {
                this.skipReload = true;
                this.tbClasses.setSelected(true);
            }
            if (this.skipReload) {
                this.objectsView.reloadView();
            }
        }
        finally {
            this.skipReload = false;
        }
    }

    void configureClassesByInstancesSize() {
        try {
            this.objectsView.configureColumns(CCONF_PRES2);
            if (this.apbPreset == null) {
                this.preset = Preset.ALL_OBJECTS;
            } else if (this.preset != Preset.ALL_OBJECTS) {
                this.skipReload = true;
                this.setPreset(Preset.ALL_OBJECTS);
                this.apbPreset.selectAction(this.preset.ordinal());
            }
            if (this.tbClasses == null) {
                this.skipReload = true;
                this.setAggregation(Aggregation.CLASSES, null);
            } else if (!this.tbClasses.isSelected()) {
                this.skipReload = true;
                this.tbClasses.setSelected(true);
            }
            if (this.skipReload) {
                this.objectsView.reloadView();
            }
        }
        finally {
            this.skipReload = false;
        }
    }

    void configureInstancesBySize() {
        try {
            this.objectsView.configureColumns(CCONF_PRES3);
            if (this.apbPreset == null) {
                this.preset = Preset.ALL_OBJECTS;
            } else if (this.preset != Preset.ALL_OBJECTS) {
                this.skipReload = true;
                this.setPreset(Preset.ALL_OBJECTS);
                this.apbPreset.selectAction(this.preset.ordinal());
            }
            if (this.tbInstances == null) {
                this.skipReload = true;
                this.setAggregation(Aggregation.INSTANCES, null);
            } else if (!this.tbInstances.isSelected()) {
                this.objectsView.configureColumns(CCONF_PRES3);
                this.skipReload = true;
                this.tbInstances.setSelected(true);
            }
            if (this.skipReload) {
                this.objectsView.reloadView();
            }
        }
        finally {
            this.skipReload = false;
        }
    }

    void configureDominatorsByRetainedSize() {
        try {
            this.objectsView.configureColumns(CCONF_PRES4);
            if (this.apbPreset == null) {
                this.preset = Preset.DOMINATORS;
            } else if (this.preset != Preset.DOMINATORS) {
                this.skipReload = true;
                this.setPreset(Preset.DOMINATORS);
                this.apbPreset.selectAction(this.preset.ordinal());
            }
            if (this.tbInstances == null) {
                this.skipReload = true;
                this.setAggregation(Aggregation.INSTANCES, null);
            } else if (!this.tbInstances.isSelected()) {
                this.skipReload = true;
                this.tbInstances.setSelected(true);
            }
            if (this.skipReload) {
                this.objectsView.reloadView();
            }
        }
        finally {
            this.skipReload = false;
        }
    }

    private synchronized void setPreset(Preset preset) {
        Heap heap;
        if (preset == Preset.DOMINATORS && !DataType.RETAINED_SIZE.valuesAvailable(heap = this.context.getFragment().getHeap())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JavaObjectsView.this.dominatorsRefresher = new Runnable(){

                        @Override
                        public void run() {
                            if (JavaObjectsView.this.getPreset() == Preset.DOMINATORS) {
                                JavaObjectsView.this.objectsView.reloadView();
                            }
                            JavaObjectsView.this.dominatorsRefresher = null;
                        }
                    };
                    DataType.RETAINED_SIZE.notifyWhenAvailable(heap, JavaObjectsView.this.dominatorsRefresher);
                    DataType.RETAINED_SIZE.computeValues(heap, null);
                }
            });
        }
        this.preset = preset;
        this.objectsView.setViewName(preset.toString());
        this.tbType.setVisible(preset == Preset.GC_ROOTS);
        if (this.tbType.isSelected() && !this.tbType.isVisible()) {
            this.tbClasses.setSelected(true);
        } else if (!this.skipReload) {
            this.objectsView.reloadView();
        }
    }

    private synchronized Preset getPreset() {
        return this.preset;
    }

    private synchronized void setAggregation(Aggregation aggregation, TreeTableView.ColumnConfiguration cconfig) {
        this.aggregation = aggregation;
        if (cconfig != null && !cconfig.equals(this.objectsView.getCurrentColumnConfiguration())) {
            this.objectsView.configureColumns(cconfig);
        }
        if (!this.skipReload) {
            this.objectsView.reloadView();
        }
    }

    private synchronized Aggregation getAggregation() {
        return this.aggregation;
    }

    private void init() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(2);
        JButton compareButton = new JButton(Icons.getIcon((String)"ProfilerIcons.SnapshotsCompare")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        final JavaDiffDumpSelector.Result r = JavaDiffDumpSelector.selectSnapshot(JavaObjectsView.this.context, false);
                        if (r != null) {
                            new RequestProcessor().post(new Runnable(){

                                @Override
                                public void run() {
                                    JavaDiffObjectsView v = new JavaDiffObjectsView(JavaObjectsView.this.context, r.getFile(), r.compareRetained(), JavaObjectsView.this.actions);
                                    JavaObjectsView.this.actions.addView(v, true);
                                }
                            });
                        }
                    }
                });
            }
        };
        compareButton.setToolTipText(Bundle.JavaObjectsView_Compare());
        this.toolbar.add((Component)compareButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.JavaObjectsView_Preset()));
        this.toolbar.addSpace(2);
        Preset[] presetItems = Preset.values();
        class PresetAction
        extends AbstractAction {
            final Preset preset;

            PresetAction(Preset preset) {
                this.preset = preset;
                this.putValue("Name", preset.toString());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaObjectsView.this.setPreset(this.preset);
            }
        }
        Action[] presetActions = new PresetAction[presetItems.length];
        for (int i = 0; i < presetItems.length; ++i) {
            presetActions[i] = new PresetAction(presetItems[i]);
        }
        this.apbPreset = new ActionPopupButton(0, presetActions);
        this.apbPreset.selectAction(this.preset.ordinal());
        this.toolbar.add((Component)this.apbPreset);
        this.toolbar.addSpace(8);
        this.toolbar.add((Component)new GrayLabel(Bundle.JavaObjectsView_Aggregation()));
        this.toolbar.addSpace(2);
        final ButtonGroup aggregationBG = new ButtonGroup();
        this.tbType = new AggregationButton(Aggregation.TYPES, Aggregation.TYPES.equals((Object)this.aggregation)){
            {
                class AggregationButton
                extends JToggleButton {
                    private final Aggregation aggregation;

                    AggregationButton(Aggregation aggregation, boolean selected) {
                        super(aggregation.getIcon(), selected);
                        this.aggregation = aggregation;
                        this.setToolTipText(aggregation.toString());
                        aggregationBG.add(this);
                    }

                    @Override
                    protected void fireItemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1 && this.aggregation != null) {
                            TreeTableView.ColumnConfiguration cconf = Aggregation.INSTANCES.equals((Object)this.aggregation) ? CCONF_INSTANCE : CCONF_CLASS;
                            JavaObjectsView.this.setAggregation(this.aggregation, cconf);
                        }
                    }
                }
                super(JavaObjectsView.this, aggregation, selected, buttonGroup);
            }

            @Override
            public void setVisible(boolean b) {
                super.setVisible(b);
                if (JavaObjectsView.this.tbPackages != null) {
                    JavaObjectsView.this.tbPackages.putClientProperty("JButton.segmentPosition", b ? "middle" : "first");
                }
            }
        };
        this.tbType.putClientProperty("JButton.buttonType", "segmented");
        this.tbType.putClientProperty("JButton.segmentPosition", "first");
        this.toolbar.add((Component)this.tbType);
        this.tbPackages = new AggregationButton(Aggregation.PACKAGES, Aggregation.PACKAGES.equals((Object)this.aggregation));
        this.tbPackages.putClientProperty("JButton.buttonType", "segmented");
        this.tbPackages.putClientProperty("JButton.segmentPosition", "first");
        this.toolbar.add((Component)this.tbPackages);
        this.tbClasses = new AggregationButton(Aggregation.CLASSES, Aggregation.CLASSES.equals((Object)this.aggregation));
        this.tbClasses.putClientProperty("JButton.buttonType", "segmented");
        this.tbClasses.putClientProperty("JButton.segmentPosition", "middle");
        this.toolbar.add((Component)this.tbClasses);
        this.tbInstances = new AggregationButton(Aggregation.INSTANCES, Aggregation.INSTANCES.equals((Object)this.aggregation));
        this.tbInstances.putClientProperty("JButton.buttonType", "segmented");
        this.tbInstances.putClientProperty("JButton.segmentPosition", "last");
        this.toolbar.add((Component)this.tbInstances);
        this.setPreset(this.preset);
        if (this.objectsView.hasPlugins()) {
            this.toolbar.addSpace(8);
            this.toolbar.add((Component)new GrayLabel(Bundle.JavaObjectsView_Details()));
            this.toolbar.addSpace(2);
            this.toolbar.add(this.objectsView.getToolbar());
        }
    }

    public static class Provider
    extends HeapViewerFeature.Provider {
        @Override
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (JavaHeapFragment.isJavaHeap(context)) {
                return new JavaObjectsView(context, actions);
            }
            return null;
        }
    }

    private static enum Aggregation {
        TYPES(Bundle.JavaObjectsView_Types(), Icons.getIcon((String)"ProfilerIcons.RunGC")),
        PACKAGES(Bundle.JavaObjectsView_Packages(), Icons.getIcon((String)"LanguageIcons.Package")),
        CLASSES(Bundle.JavaObjectsView_Classes(), Icons.getIcon((String)"LanguageIcons.Class")),
        INSTANCES(Bundle.JavaObjectsView_Instances(), Icons.getIcon((String)"LanguageIcons.Instance"));

        private final String aggregationName;
        private final Icon aggregationIcon;

        private Aggregation(String aggregationName, Icon aggregationIcon) {
            this.aggregationName = aggregationName;
            this.aggregationIcon = aggregationIcon;
        }

        public String toString() {
            return this.aggregationName;
        }

        public Icon getIcon() {
            return this.aggregationIcon;
        }
    }

    private static enum Preset {
        ALL_OBJECTS(Bundle.JavaObjectsView_AllObjects()),
        DOMINATORS(Bundle.JavaObjectsView_Dominators()),
        GC_ROOTS(Bundle.JavaObjectsView_GcRoots());

        private final String presetName;

        private Preset(String presetName) {
            this.presetName = presetName;
        }

        public String toString() {
            return this.presetName;
        }
    }
}

