/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class TypeHandler {
    static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
    private final TruffleInstrument.Env env;
    private final AtomicReference<EventBinding<TypeProfileEventFactory>> currentBinding;

    public TypeHandler(TruffleInstrument.Env env) {
        this.env = env;
        this.currentBinding = new AtomicReference();
    }

    public boolean isStarted() {
        return this.currentBinding.get() != null;
    }

    public boolean start(boolean inspectInternal) {
        if (this.currentBinding.get() == null) {
            SourceSectionFilter filter = SourceSectionFilter.newBuilder().tagIs(new Class[]{StandardTags.RootTag.class}).includeInternal(inspectInternal).build();
            Instrumenter instrumenter = this.env.getInstrumenter();
            EventBinding binding = instrumenter.attachExecutionEventFactory(filter, (ExecutionEventNodeFactory)new TypeProfileEventFactory());
            if (this.currentBinding.compareAndSet(null, (EventBinding<TypeProfileEventFactory>)binding)) {
                return true;
            }
            binding.dispose();
        }
        return false;
    }

    public void stop() {
        EventBinding<TypeProfileEventFactory> binding = this.currentBinding.get();
        if (binding != null && this.currentBinding.compareAndSet(binding, null)) {
            binding.dispose();
        }
    }

    public void clearData() {
        EventBinding<TypeProfileEventFactory> binding = this.currentBinding.get();
        if (binding != null) {
            ((TypeProfileEventFactory)binding.getElement()).profileMap.clear();
        }
    }

    public Collection<SectionTypeProfile> getSectionTypeProfiles() {
        EventBinding<TypeProfileEventFactory> binding = this.currentBinding.get();
        ArrayList<SectionTypeProfile> profiles = new ArrayList<SectionTypeProfile>(((TypeProfileEventFactory)binding.getElement()).profileMap.values());
        profiles.sort((p1, p2) -> Integer.compare(((SectionTypeProfile)p1).sourceSection.getCharEndIndex(), ((SectionTypeProfile)p2).sourceSection.getCharEndIndex()));
        return profiles;
    }

    private final class TypeProfileEventFactory
    implements ExecutionEventNodeFactory {
        private final Map<SourceSection, SectionTypeProfile> profileMap = new ConcurrentHashMap<SourceSection, SectionTypeProfile>();

        private TypeProfileEventFactory() {
        }

        public ExecutionEventNode create(final EventContext context) {
            return new ExecutionEventNode(){

                protected void onEnter(VirtualFrame frame) {
                    super.onEnter(frame);
                    Node rootNode = context.getInstrumentedNode();
                    SourceSection section = context.getInstrumentedSourceSection();
                    this.processArguments(frame.materialize(), rootNode, section);
                }

                protected void onReturnValue(VirtualFrame frame, Object result) {
                    super.onReturnValue(frame, result);
                    Node rootNode = context.getInstrumentedNode();
                    SourceSection section = context.getInstrumentedSourceSection();
                    TypeProfileEventFactory.this.processReturnValue(result, rootNode, section);
                }

                @CompilerDirectives.TruffleBoundary
                private void processArguments(MaterializedFrame frame, Node node, SourceSection section) {
                    Iterator scopes = TypeHandler.this.env.findLocalScopes(node, (Frame)frame).iterator();
                    if (!scopes.hasNext()) {
                        return;
                    }
                    Scope functionScope = (Scope)scopes.next();
                    Object argsObject = functionScope.getArguments();
                    if (argsObject instanceof TruffleObject) {
                        LanguageInfo language = node.getRootNode().getLanguageInfo();
                        try {
                            Object keys = INTEROP.getMembers(argsObject);
                            long size = INTEROP.getArraySize(keys);
                            for (long i = 0L; i < size; ++i) {
                                String key = INTEROP.asString(INTEROP.readArrayElement(keys, i));
                                Object argument = INTEROP.readMember(argsObject, key);
                                String retType = TypeHandler.this.env.toString(language, TypeHandler.this.env.findMetaObject(language, argument));
                                SourceSection argSection = TypeProfileEventFactory.this.getArgSection(section, key);
                                if (argSection == null) continue;
                                TypeProfileEventFactory.this.profileMap.computeIfAbsent(argSection, s -> new SectionTypeProfile((SourceSection)s)).types.add(retType);
                            }
                        }
                        catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                }
            };
        }

        @CompilerDirectives.TruffleBoundary
        private void processReturnValue(Object result, Node node, SourceSection section) {
            if (result != null) {
                LanguageInfo language = node.getRootNode().getLanguageInfo();
                String retType = TypeHandler.this.env.toString(language, TypeHandler.this.env.findMetaObject(language, result));
                this.profileMap.computeIfAbsent(section, s -> new SectionTypeProfile((SourceSection)s)).types.add(retType);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private SourceSection getArgSection(SourceSection function, Object argName) {
            int idx = function.getCharacters().toString().indexOf(argName.toString());
            return idx < 0 ? null : function.getSource().createSection(function.getCharIndex() + idx, argName.toString().length());
        }
    }

    public static interface Provider {
        public TypeHandler getTypeHandler();
    }

    public static final class SectionTypeProfile {
        private final SourceSection sourceSection;
        private final Collection<String> types = new HashSet<String>();

        private SectionTypeProfile(SourceSection sourceSection) {
            this.sourceSection = sourceSection;
        }

        public SourceSection getSourceSection() {
            return this.sourceSection;
        }

        public Collection<String> getTypes() {
            return this.types;
        }
    }
}

