/*
 * Decompiled with CFR 0.152.
 */
package org.nanohttpd.protocols.websockets;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.nanohttpd.protocols.websockets.CloseCode;
import org.nanohttpd.protocols.websockets.CloseFrame;
import org.nanohttpd.protocols.websockets.OpCode;
import org.nanohttpd.protocols.websockets.WebSocketException;

public class WebSocketFrame {
    public static final Charset TEXT_CHARSET = Charset.forName("UTF-8");
    private OpCode opCode;
    private boolean fin;
    private byte[] maskingKey;
    private byte[] payload;
    private transient int _payloadLength;
    private transient String _payloadString;

    public static String binary2Text(byte[] payload) throws CharacterCodingException {
        return new String(payload, TEXT_CHARSET);
    }

    public static String binary2Text(byte[] payload, int offset, int length) throws CharacterCodingException {
        return new String(payload, offset, length, TEXT_CHARSET);
    }

    private static int checkedRead(int read) throws IOException {
        if (read < 0) {
            throw new EOFException();
        }
        return read;
    }

    public static WebSocketFrame read(InputStream in) throws IOException {
        byte head = (byte)WebSocketFrame.checkedRead(in.read());
        boolean fin = (head & 0x80) != 0;
        OpCode opCode = OpCode.find((byte)(head & 0xF));
        if ((head & 0x70) != 0) {
            throw new WebSocketException(CloseCode.ProtocolError, "The reserved bits (" + Integer.toBinaryString(head & 0x70) + ") must be 0.");
        }
        if (opCode == null) {
            throw new WebSocketException(CloseCode.ProtocolError, "Received frame with reserved/unknown opcode " + (head & 0xF) + ".");
        }
        if (opCode.isControlFrame() && !fin) {
            throw new WebSocketException(CloseCode.ProtocolError, "Fragmented control frame.");
        }
        WebSocketFrame frame = new WebSocketFrame(opCode, fin);
        frame.readPayloadInfo(in);
        frame.readPayload(in);
        if (frame.getOpCode() == OpCode.Close) {
            return new CloseFrame(frame);
        }
        return frame;
    }

    public static byte[] text2Binary(String payload) throws CharacterCodingException {
        return payload.getBytes(TEXT_CHARSET);
    }

    private WebSocketFrame(OpCode opCode, boolean fin) {
        this.setOpCode(opCode);
        this.setFin(fin);
    }

    public WebSocketFrame(OpCode opCode, boolean fin, byte[] payload) {
        this(opCode, fin, payload, null);
    }

    public WebSocketFrame(OpCode opCode, boolean fin, byte[] payload, byte[] maskingKey) {
        this(opCode, fin);
        this.setMaskingKey(maskingKey);
        this.setBinaryPayload(payload);
    }

    public WebSocketFrame(OpCode opCode, boolean fin, String payload) throws CharacterCodingException {
        this(opCode, fin, payload, null);
    }

    public WebSocketFrame(OpCode opCode, boolean fin, String payload, byte[] maskingKey) throws CharacterCodingException {
        this(opCode, fin);
        this.setMaskingKey(maskingKey);
        this.setTextPayload(payload);
    }

    public WebSocketFrame(OpCode opCode, List<WebSocketFrame> fragments) throws WebSocketException {
        this.setOpCode(opCode);
        this.setFin(true);
        long _payloadLength = 0L;
        for (WebSocketFrame inter : fragments) {
            _payloadLength += (long)inter.getBinaryPayload().length;
        }
        if (_payloadLength < 0L || _payloadLength > Integer.MAX_VALUE) {
            throw new WebSocketException(CloseCode.MessageTooBig, "Max frame length has been exceeded.");
        }
        this._payloadLength = (int)_payloadLength;
        byte[] payload = new byte[this._payloadLength];
        int offset = 0;
        for (WebSocketFrame inter : fragments) {
            System.arraycopy(inter.getBinaryPayload(), 0, payload, offset, inter.getBinaryPayload().length);
            offset += inter.getBinaryPayload().length;
        }
        this.setBinaryPayload(payload);
    }

    public WebSocketFrame(WebSocketFrame clone) {
        this.setOpCode(clone.getOpCode());
        this.setFin(clone.isFin());
        this.setBinaryPayload(clone.getBinaryPayload());
        this.setMaskingKey(clone.getMaskingKey());
    }

    public byte[] getBinaryPayload() {
        return this.payload;
    }

    public byte[] getMaskingKey() {
        return this.maskingKey;
    }

    public OpCode getOpCode() {
        return this.opCode;
    }

    public String getTextPayload() {
        if (this._payloadString == null) {
            try {
                this._payloadString = WebSocketFrame.binary2Text(this.getBinaryPayload());
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException("Undetected CharacterCodingException", e);
            }
        }
        return this._payloadString;
    }

    public boolean isFin() {
        return this.fin;
    }

    public boolean isMasked() {
        return this.maskingKey != null && this.maskingKey.length == 4;
    }

    private String payloadToString() {
        if (this.payload == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.payload.length).append("b] ");
        if (this.getOpCode() == OpCode.Text) {
            String text = this.getTextPayload();
            if (text.length() > 100) {
                sb.append(text.substring(0, 100)).append("...");
            } else {
                sb.append(text);
            }
        } else {
            sb.append("0x");
            for (int i = 0; i < Math.min(this.payload.length, 50); ++i) {
                sb.append(Integer.toHexString(this.payload[i] & 0xFF));
            }
            if (this.payload.length > 50) {
                sb.append("...");
            }
        }
        return sb.toString();
    }

    private void readPayload(InputStream in) throws IOException {
        this.payload = new byte[this._payloadLength];
        for (int read = 0; read < this._payloadLength; read += WebSocketFrame.checkedRead(in.read(this.payload, read, this._payloadLength - read))) {
        }
        if (this.isMasked()) {
            for (int i = 0; i < this.payload.length; ++i) {
                int n = i;
                this.payload[n] = (byte)(this.payload[n] ^ this.maskingKey[i % 4]);
            }
        }
        if (this.getOpCode() == OpCode.Text) {
            this._payloadString = WebSocketFrame.binary2Text(this.getBinaryPayload());
        }
    }

    private void readPayloadInfo(InputStream in) throws IOException {
        byte b = (byte)WebSocketFrame.checkedRead(in.read());
        boolean masked = (b & 0x80) != 0;
        this._payloadLength = (byte)(0x7F & b);
        if (this._payloadLength == 126) {
            this._payloadLength = (WebSocketFrame.checkedRead(in.read()) << 8 | WebSocketFrame.checkedRead(in.read())) & 0xFFFF;
            if (this._payloadLength < 126) {
                throw new WebSocketException(CloseCode.ProtocolError, "Invalid data frame 2byte length. (not using minimal length encoding)");
            }
        } else if (this._payloadLength == 127) {
            long _payloadLength = (long)WebSocketFrame.checkedRead(in.read()) << 56 | (long)WebSocketFrame.checkedRead(in.read()) << 48 | (long)WebSocketFrame.checkedRead(in.read()) << 40 | (long)WebSocketFrame.checkedRead(in.read()) << 32 | (long)(WebSocketFrame.checkedRead(in.read()) << 24) | (long)(WebSocketFrame.checkedRead(in.read()) << 16) | (long)(WebSocketFrame.checkedRead(in.read()) << 8) | (long)WebSocketFrame.checkedRead(in.read());
            if (_payloadLength < 65536L) {
                throw new WebSocketException(CloseCode.ProtocolError, "Invalid data frame 4byte length. (not using minimal length encoding)");
            }
            if (_payloadLength < 0L || _payloadLength > Integer.MAX_VALUE) {
                throw new WebSocketException(CloseCode.MessageTooBig, "Max frame length has been exceeded.");
            }
            this._payloadLength = (int)_payloadLength;
        }
        if (this.opCode.isControlFrame()) {
            if (this._payloadLength > 125) {
                throw new WebSocketException(CloseCode.ProtocolError, "Control frame with payload length > 125 bytes.");
            }
            if (this.opCode == OpCode.Close && this._payloadLength == 1) {
                throw new WebSocketException(CloseCode.ProtocolError, "Received close frame with payload len 1.");
            }
        }
        if (masked) {
            this.maskingKey = new byte[4];
            for (int read = 0; read < this.maskingKey.length; read += WebSocketFrame.checkedRead(in.read(this.maskingKey, read, this.maskingKey.length - read))) {
            }
        }
    }

    public void setBinaryPayload(byte[] payload) {
        this.payload = payload;
        this._payloadLength = payload.length;
        this._payloadString = null;
    }

    public void setFin(boolean fin) {
        this.fin = fin;
    }

    public void setMaskingKey(byte[] maskingKey) {
        if (maskingKey != null && maskingKey.length != 4) {
            throw new IllegalArgumentException("MaskingKey " + Arrays.toString(maskingKey) + " hasn't length 4");
        }
        this.maskingKey = maskingKey;
    }

    public void setOpCode(OpCode opcode) {
        this.opCode = opcode;
    }

    public void setTextPayload(String payload) throws CharacterCodingException {
        this.payload = WebSocketFrame.text2Binary(payload);
        this._payloadLength = payload.length();
        this._payloadString = payload;
    }

    public void setUnmasked() {
        this.setMaskingKey(null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WS[");
        sb.append((Object)this.getOpCode());
        sb.append(", ").append(this.isFin() ? "fin" : "inter");
        sb.append(", ").append(this.isMasked() ? "masked" : "unmasked");
        sb.append(", ").append(this.payloadToString());
        sb.append(']');
        return sb.toString();
    }

    public void write(OutputStream out) throws IOException {
        int header = 0;
        if (this.fin) {
            header = (byte)(header | 0x80);
        }
        header = (byte)(header | this.opCode.getValue() & 0xF);
        out.write(header);
        this._payloadLength = this.getBinaryPayload().length;
        if (this._payloadLength <= 125) {
            out.write(this.isMasked() ? (byte)(0x80 | (byte)this._payloadLength) : (byte)this._payloadLength);
        } else if (this._payloadLength <= 65535) {
            out.write(this.isMasked() ? 254 : 126);
            out.write(this._payloadLength >>> 8);
            out.write(this._payloadLength);
        } else {
            out.write(this.isMasked() ? 255 : 127);
            out.write(this._payloadLength >>> 56 & 0);
            out.write(this._payloadLength >>> 48 & 0);
            out.write(this._payloadLength >>> 40 & 0);
            out.write(this._payloadLength >>> 32 & 0);
            out.write(this._payloadLength >>> 24);
            out.write(this._payloadLength >>> 16);
            out.write(this._payloadLength >>> 8);
            out.write(this._payloadLength);
        }
        if (this.isMasked()) {
            out.write(this.maskingKey);
            for (int i = 0; i < this._payloadLength; ++i) {
                out.write(this.getBinaryPayload()[i] ^ this.maskingKey[i % 4]);
            }
        } else {
            out.write(this.getBinaryPayload());
        }
        out.flush();
    }
}

