/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;
import org.graalvm.visualvm.core.ui.DataSourceView;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.common.SessionSettings;
import org.graalvm.visualvm.lib.jfluid.global.Platform;
import org.graalvm.visualvm.lib.profiler.NetBeansProfiler;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.profiler.ApplicationProfilerView;
import org.graalvm.visualvm.profiler.ApplicationProfilerViewProvider;
import org.graalvm.visualvm.profiler.CalibrationSupport;
import org.graalvm.visualvm.profiler.JavaInfo;
import org.graalvm.visualvm.profiler.ProfilerSettingsSupport;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ProfilerSupport {
    private static final String HOTSPOT_VM_NAME_PREFIX = "Java HotSpot";
    private static final String OPENJDK_VM_NAME_PREFIX = "OpenJDK ";
    private static final String JAVA_RT_16_PREFIX = "1.6.0";
    private static final String JAVA_RT_17_PREFIX = "1.7.0";
    private static ProfilerSupport instance;
    private boolean isInitialized = NetBeansProfiler.isInitialized();
    private Application profiledApplication;
    private final ApplicationProfilerViewProvider profilerViewProvider;

    public static synchronized ProfilerSupport getInstance() {
        if (instance == null) {
            instance = new ProfilerSupport();
        }
        return instance;
    }

    boolean isInitialized() {
        return this.isInitialized;
    }

    public String getProfiledApplicationName() {
        String name = NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Externaly_started_app");
        Application a = this.getProfiledApplication();
        if (a == null) {
            int state = NetBeansProfiler.getDefaultNB().getProfilingState();
            return state == 1 ? null : name;
        }
        DataSourceDescriptor d = DataSourceDescriptorFactory.getDescriptor((DataSource)a);
        return d != null ? d.getName() : name;
    }

    public int getDefaultPort() {
        return ProfilerIDESettings.getInstance().getPortNo();
    }

    public boolean hasSupportedJavaPlatforms() {
        for (int i = 0; i < 5; ++i) {
            String code = "jdk1" + (5 + i);
            if (!this.supportsProfiling(code, 32) && !this.supportsProfiling(code, 64)) continue;
            return true;
        }
        String code = "jdk100";
        if (this.supportsProfiling(code, 32) || this.supportsProfiling(code, 64)) {
            return true;
        }
        code = "jdk110";
        if (this.supportsProfiling(code, 32) || this.supportsProfiling(code, 64)) {
            return true;
        }
        code = "jdk120";
        if (this.supportsProfiling(code, 32) || this.supportsProfiling(code, 64)) {
            return true;
        }
        code = "jdk130";
        if (this.supportsProfiling(code, 32) || this.supportsProfiling(code, 64)) {
            return true;
        }
        code = "jdk140";
        return this.supportsProfiling(code, 32) || this.supportsProfiling(code, 64);
    }

    public String[][] getSupportedJavaPlatforms() {
        ArrayList<String> codesl = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            String code = "jdk1" + (5 + i);
            if (!this.supportsProfiling(code, 32) && !this.supportsProfiling(code, 64)) continue;
            codesl.add(code);
        }
        String code = "jdk100";
        if (this.supportsProfiling(code, 32) || this.supportsProfiling(code, 64)) {
            codesl.add(code);
        }
        if (this.supportsProfiling(code = "jdk110", 32) || this.supportsProfiling(code, 64)) {
            codesl.add(code);
        }
        if (this.supportsProfiling(code = "jdk120", 32) || this.supportsProfiling(code, 64)) {
            codesl.add(code);
        }
        if (this.supportsProfiling(code = "jdk130", 32) || this.supportsProfiling(code, 64)) {
            codesl.add(code);
        }
        if (this.supportsProfiling(code = "jdk140", 32) || this.supportsProfiling(code, 64)) {
            codesl.add(code);
        }
        String[] names = new String[codesl.size()];
        String[] codes = new String[codesl.size()];
        String current = null;
        for (int i = 0; i < codesl.size(); ++i) {
            codes[i] = (String)codesl.get(i);
            names[i] = ProfilerSupport.getJavaName(codes[i]);
            if (!Platform.getJDKVersionString().equals(codes[i])) continue;
            current = names[i];
        }
        return new String[][]{names, codes, {current}};
    }

    public String[][] getSupportedArchitectures(String java) {
        ArrayList<String> codesl = new ArrayList<String>();
        if (this.supportsProfiling(java, 32)) {
            codesl.add(Integer.toString(32));
        }
        if (this.supportsProfiling(java, 64)) {
            codesl.add(Integer.toString(64));
        }
        String[] names = new String[codesl.size()];
        String[] codes = new String[codesl.size()];
        String current = null;
        for (int i = 0; i < codesl.size(); ++i) {
            codes[i] = (String)codesl.get(i);
            names[i] = ProfilerSupport.getArchName(Integer.parseInt(codes[i]));
            if (!Integer.toString(Platform.getSystemArchitecture()).equals(codes[i])) continue;
            current = names[i];
        }
        return new String[][]{names, codes, {current}};
    }

    static String getJavaName(String code) {
        if ("jdk15".equals(code)) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_platform_name", (Object)5);
        }
        if ("jdk16".equals(code)) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_platform_name", (Object)6);
        }
        if ("jdk17".equals(code)) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_platform_name", (Object)7);
        }
        if ("jdk18".equals(code)) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_platform_name", (Object)8);
        }
        if ("jdk19".equals(code)) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_platform_name", (Object)9);
        }
        if ("jdk100".equals(code)) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_platform_name", (Object)10);
        }
        if ("jdk110".equals(code)) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_platform_name", (Object)11);
        }
        if ("jdk120".equals(code)) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_platform_name", (Object)12);
        }
        if ("jdk130".equals(code)) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_platform_name", (Object)13);
        }
        if ("jdk140".equals(code)) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_platform_name", (Object)14);
        }
        throw new IllegalArgumentException("Unknown java code " + code);
    }

    static String getArchName(int arch) {
        if (32 == arch) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_arch_name", (Object)32);
        }
        if (64 == arch) {
            return NbBundle.getMessage(ProfilerSupport.class, (String)"STR_Java_arch_name", (Object)64);
        }
        throw new IllegalArgumentException("Unsupported architecture " + arch);
    }

    public boolean supportsProfiling(String java, int architecture) {
        String ld = Profiler.getDefault().getLibsDir();
        String nativeLib = Platform.getAgentNativeLibFullName((String)ld, (boolean)false, (String)java, (int)architecture);
        return new File(nativeLib).isFile();
    }

    public String getStartupParameter(String java, int architecture, int port) {
        String nativeLib;
        String ld = Profiler.getDefault().getLibsDir();
        if (ld.contains(" ")) {
            ld = "\"" + ld + "\"";
        }
        if ((nativeLib = Platform.getAgentNativeLibFullName((String)ld, (boolean)false, (String)java, (int)architecture)).contains(" ")) {
            nativeLib = "\"" + nativeLib + "\"";
        }
        return "-agentpath:" + nativeLib + "=" + ld + "," + port;
    }

    public void profileProcessStartup(final String java, final int architecture, final int port, ProfilerSettingsSupport settings, final ProfilerPreset preset) {
        if (!CalibrationSupport.checkCalibration(java, architecture, null, null)) {
            return;
        }
        final ProfilingSettings pSettings = settings.getSettings();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VisualVM.getInstance().runTask(new Runnable(){

                    public void run() {
                        if (!ProfilerSupport.checkStartedApp(port)) {
                            return;
                        }
                        final RequestProcessor processor = new RequestProcessor("Startup Profiler @ " + port);
                        Host.LOCALHOST.getRepository().addDataChangeListener((DataChangeListener)new DataChangeListener<Application>(){

                            public void dataChanged(final DataChangeEvent<Application> event) {
                                final 1 listener = this;
                                processor.post(new Runnable(){

                                    public void run() {
                                        if (!event.getAdded().equals(event.getCurrent())) {
                                            for (Application a : event.getAdded()) {
                                                if (!ProfilerSupport.isProfiledApplication(a, port)) continue;
                                                Host.LOCALHOST.getRepository().removeDataChangeListener(listener);
                                                ProfilerSupport.this.setProfiledApplication(a);
                                                ProfilerSupport.this.selectProfilerView(a, preset, pSettings);
                                                break;
                                            }
                                        }
                                    }
                                });
                            }
                        }, Application.class);
                        ProfilingSettings ps = pSettings;
                        SessionSettings ss = ProfilerSupport.createSessionSettings(java, architecture, port);
                        NetBeansProfiler.getDefaultNB().connectToStartedApp(ps, ss);
                        ProfilerSupport.resetTerminateDialogs();
                    }
                });
            }
        });
    }

    private static boolean checkStartedApp(int port) {
        String homeDir = System.getProperty("user.home");
        File agentF = new File(homeDir + File.separator + ".nbprofiler" + File.separator + port);
        if (!agentF.isFile()) {
            return true;
        }
        String caption = NbBundle.getMessage(ProfilerSupport.class, (String)"CAP_Warning");
        String message = NbBundle.getMessage(ProfilerSupport.class, (String)"MSG_StartedTooSoon");
        NotifyDescriptor nd = new NotifyDescriptor((Object)message, caption, 2, 2, null, NotifyDescriptor.OK_OPTION);
        if (DialogDisplayer.getDefault().notify(nd) != NotifyDescriptor.OK_OPTION) {
            return false;
        }
        return ProfilerSupport.checkStartedApp(port);
    }

    private static void resetTerminateDialogs() {
        String dnsaKey = "NetBeansProfiler.handleShutdown.noResults";
        ProfilerIDESettings.getInstance().setDoNotShowAgain(dnsaKey, null);
        dnsaKey = "NetBeansProfiler.handleShutdown";
        String dnsa = ProfilerIDESettings.getInstance().getDoNotShowAgain(dnsaKey);
        if ("NO_OPTION".equals(dnsa)) {
            ProfilerIDESettings.getInstance().setDoNotShowAgain(dnsaKey, null);
        }
    }

    private static SessionSettings createSessionSettings(String java, int architecture, int port) {
        SessionSettings ss = new SessionSettings();
        ss.setJavaVersionString(java);
        ss.setSystemArchitecture(architecture);
        ss.setPortNo(port);
        ss.setJavaExecutable(JavaInfo.getCurrentJDKExecutable());
        return ss;
    }

    private static boolean isProfiledApplication(Application a, int port) {
        Jvm jvm = JvmFactory.getJVMFor((Application)a);
        if (!jvm.isBasicInfoSupported()) {
            return false;
        }
        String args = jvm.getJvmArgs();
        return args.contains("-agentpath:") && args.contains("," + port);
    }

    boolean supportsProfiling(Application application) {
        if (application == this.getProfiledApplication()) {
            return true;
        }
        if (application.getHost() != Host.LOCALHOST) {
            return false;
        }
        if (Application.CURRENT_APPLICATION.equals((Object)application)) {
            return false;
        }
        if (application.getState() != 1) {
            return false;
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        if (!jvm.isBasicInfoSupported() || !jvm.isAttachable()) {
            return false;
        }
        if (jvm.is14() || jvm.is15()) {
            return false;
        }
        int arch = ProfilerSupport.getJVMArchitecture(jvm);
        if (arch == -1) {
            return false;
        }
        String javaVer = Platform.getJDKVersionString((String)jvm.getJavaVersion());
        return this.supportsProfiling(javaVer, arch);
    }

    static boolean classSharingBreaksProfiling(Application application) {
        if (application.getState() != 1) {
            return false;
        }
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        String vmInfo = jvm.getVmInfo();
        boolean classSharing = vmInfo.contains("sharing");
        if (!jvm.isGetSystemPropertiesSupported()) {
            return classSharing;
        }
        Properties properties = jvm.getSystemProperties();
        if (properties == null) {
            return classSharing;
        }
        String javaRTVersion = properties.getProperty("java.runtime.version");
        if (javaRTVersion == null) {
            return classSharing;
        }
        int updateNumber = ProfilerSupport.getUpdateNumber(javaRTVersion);
        int buildNumber = ProfilerSupport.getBuildNumber(javaRTVersion);
        String vmName = jvm.getVmName();
        if (vmName.startsWith(HOTSPOT_VM_NAME_PREFIX)) {
            if (javaRTVersion.startsWith(JAVA_RT_16_PREFIX)) {
                if (updateNumber < 10) {
                    return true;
                }
                if (updateNumber == 10 && buildNumber <= 23) {
                    return true;
                }
            } else if (javaRTVersion.startsWith(JAVA_RT_17_PREFIX) && updateNumber == 0 && buildNumber < 26) {
                return true;
            }
            return false;
        }
        if (vmName.startsWith(OPENJDK_VM_NAME_PREFIX)) {
            return javaRTVersion.startsWith(JAVA_RT_16_PREFIX) ? updateNumber == 0 && buildNumber < 11 : javaRTVersion.startsWith(JAVA_RT_17_PREFIX) && updateNumber == 0 && buildNumber < 26;
        }
        return classSharing;
    }

    private static int getUpdateNumber(String javaRTVersion) {
        int underscoreIndex = javaRTVersion.indexOf("_");
        if (underscoreIndex == -1) {
            return 0;
        }
        try {
            String updateNumberString = javaRTVersion.substring(underscoreIndex + "_".length(), javaRTVersion.indexOf("-"));
            return Integer.parseInt(updateNumberString);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static int getBuildNumber(String javaRTVersion) {
        try {
            String buildNumberString = javaRTVersion.substring(javaRTVersion.indexOf("-b") + "-b".length());
            return Integer.parseInt(buildNumberString);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static int getJVMArchitecture(Jvm jvm) {
        Properties sysprops = jvm.getSystemProperties();
        String jvmArch = sysprops == null ? null : sysprops.getProperty("sun.arch.data.model");
        return jvmArch == null ? -1 : Integer.valueOf(jvmArch);
    }

    synchronized void setProfiledApplication(Application profiledApplication) {
        this.profiledApplication = profiledApplication;
    }

    synchronized Application getProfiledApplication() {
        return this.profiledApplication;
    }

    void selectActiveProfilerView() {
        this.selectProfilerView(this.getProfiledApplication());
    }

    void selectProfilerView(Application application) {
        this.selectProfilerView(application, null, null);
    }

    private void selectProfilerView(Application application, final ProfilerPreset preset, final ProfilingSettings settings) {
        if (application == null) {
            return;
        }
        final DataSourceView activeView = this.profilerViewProvider.view(application);
        if (activeView == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (preset != null && settings != null) {
                    ((ApplicationProfilerView)activeView).selectPreset(preset, settings);
                }
                DataSourceWindowManager.sharedInstance().selectView(activeView);
            }
        });
    }

    private ProfilerSupport() {
        if (this.isInitialized) {
            this.profilerViewProvider = new ApplicationProfilerViewProvider();
            this.profilerViewProvider.initialize();
            ProfilerIDESettings.getInstance().setAutoOpenSnapshot(false);
            ProfilerIDESettings.getInstance().setAutoSaveSnapshot(true);
        } else {
            this.profilerViewProvider = null;
        }
    }
}

