/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.ClassDump;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.HprofField;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;
import org.graalvm.visualvm.lib.jfluid.heap.HprofInstanceObjectValue;
import org.graalvm.visualvm.lib.jfluid.heap.HprofInstanceValue;
import org.graalvm.visualvm.lib.jfluid.heap.HprofObject;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;

class InstanceDump
extends HprofObject
implements Instance {
    final ClassDump dumpClass;

    InstanceDump(ClassDump cls, long offset) {
        super(offset);
        this.dumpClass = cls;
    }

    @Override
    public List getFieldValues() {
        long offset = this.fileOffset + (long)this.getInstanceFieldValuesOffset();
        List fields = this.dumpClass.getAllInstanceFields();
        ArrayList<HprofInstanceValue> values = new ArrayList<HprofInstanceValue>(fields.size());
        for (HprofField field : fields) {
            if (field.getValueType() == 2) {
                values.add(new HprofInstanceObjectValue(this, field, offset));
            } else {
                values.add(new HprofInstanceValue(this, field, offset));
            }
            offset += (long)field.getValueSize();
        }
        return values;
    }

    @Override
    public boolean isGCRoot() {
        return this.getHprof().isGCRoot(this);
    }

    @Override
    public long getInstanceId() {
        return this.dumpClass.getHprofBuffer().getID(this.fileOffset + 1L);
    }

    @Override
    public int getInstanceNumber() {
        return this.getHprof().idToOffsetMap.get(this.getInstanceId()).getIndex();
    }

    @Override
    public JavaClass getJavaClass() {
        return this.dumpClass;
    }

    @Override
    public Instance getNearestGCRootPointer() {
        return this.getHprof().getNearestGCRootPointer(this);
    }

    @Override
    public long getReachableSize() {
        return 0L;
    }

    @Override
    public List getReferences() {
        return this.getHprof().findReferencesFor(this.getInstanceId());
    }

    @Override
    public long getRetainedSize() {
        return this.getHprof().getRetainedSize(this);
    }

    @Override
    public long getSize() {
        return this.dumpClass.getInstanceSize();
    }

    @Override
    public List getStaticFieldValues() {
        return this.dumpClass.getStaticFieldValues();
    }

    @Override
    public Object getValueOfField(String name) {
        List fieldValues = this.getFieldValues();
        for (int i = fieldValues.size() - 1; i >= 0; --i) {
            FieldValue fieldValue = (FieldValue)fieldValues.get(i);
            if (!fieldValue.getField().getName().equals(name)) continue;
            if (fieldValue instanceof HprofInstanceObjectValue) {
                return ((HprofInstanceObjectValue)fieldValue).getInstance();
            }
            return ((HprofInstanceValue)fieldValue).getTypeValue();
        }
        return null;
    }

    private int getInstanceFieldValuesOffset() {
        int idSize = this.dumpClass.getHprofBuffer().getIDSize();
        return 1 + idSize + 4 + idSize + 4;
    }

    private HprofHeap getHprof() {
        return this.dumpClass.getHprof();
    }
}

