/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.jvm.JVMImpl;
import org.graalvm.visualvm.jvm.MonitoredDataImpl;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.graalvm.visualvm.tools.jmx.JvmMXBeans;
import org.graalvm.visualvm.tools.jmx.JvmMXBeansFactory;
import org.openide.util.NbBundle;

public class JmxSupport
implements DataRemovedListener {
    private static final Logger LOGGER = Logger.getLogger(JmxSupport.class.getName());
    private static final String PROCESS_CPU_TIME_ATTR = "ProcessCpuTime";
    private static final String PROCESSING_CAPACITY_ATTR = "ProcessingCapacity";
    private static final String PERM_GEN = "Perm Gen";
    private static final String PS_PERM_GEN = "PS Perm Gen";
    private static final String CMS_PERM_GEN = "CMS Perm Gen";
    private static final String G1_PERM_GEN = "G1 Perm Gen";
    private static final String METASPACE = "Metaspace";
    private static final String IBM_PERM_GEN = "class storage";
    private static final ObjectName osName = JmxSupport.getOSName();
    private static long INITIAL_DELAY = 100L;
    private Application application;
    private JvmMXBeans mxbeans;
    private JVMImpl jvm;
    private Object processCPUTimeAttributeLock = new Object();
    private Boolean processCPUTimeAttribute;
    private long processCPUTimeMultiplier;
    private Timer timer;
    private MemoryPoolMXBean permGenPool;
    private Collection<GarbageCollectorMXBean> gcList;
    private String[] genName;

    JmxSupport(Application app, JVMImpl vm) {
        this.jvm = vm;
        this.application = app;
        app.notifyWhenRemoved((DataRemovedListener)this);
    }

    RuntimeMXBean getRuntime() {
        JvmMXBeans jmx = this.getJvmMXBeans();
        if (jmx != null) {
            return jmx.getRuntimeMXBean();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasProcessCPUTimeAttribute() {
        Object object = this.processCPUTimeAttributeLock;
        synchronized (object) {
            MBeanServerConnection conn;
            if (this.processCPUTimeAttribute != null) {
                return this.processCPUTimeAttribute;
            }
            this.processCPUTimeAttribute = Boolean.FALSE;
            JmxModel jmx = JmxModelFactory.getJmxModelFor((Application)this.application);
            if (jmx != null && jmx.getConnectionState().equals((Object)JmxModel.ConnectionState.CONNECTED) && (conn = jmx.getMBeanServerConnection()) != null) {
                try {
                    MBeanInfo info = conn.getMBeanInfo(osName);
                    MBeanAttributeInfo[] attrs = info.getAttributes();
                    this.processCPUTimeMultiplier = 1L;
                    for (MBeanAttributeInfo attr : attrs) {
                        String name = attr.getName();
                        if (PROCESS_CPU_TIME_ATTR.equals(name)) {
                            this.processCPUTimeAttribute = Boolean.TRUE;
                        }
                        if (!PROCESSING_CAPACITY_ATTR.equals(name)) continue;
                        Number mul = (Number)conn.getAttribute(osName, PROCESSING_CAPACITY_ATTR);
                        this.processCPUTimeMultiplier = mul.longValue();
                    }
                }
                catch (Exception ex) {
                    LOGGER.throwing(JmxSupport.class.getName(), "hasProcessCPUTimeAttribute", ex);
                }
            }
            return this.processCPUTimeAttribute;
        }
    }

    long getProcessCPUTime() {
        MBeanServerConnection conn;
        if (!this.hasProcessCPUTimeAttribute()) {
            throw new UnsupportedOperationException();
        }
        JmxModel jmx = JmxModelFactory.getJmxModelFor((Application)this.application);
        if (jmx != null && jmx.getConnectionState().equals((Object)JmxModel.ConnectionState.CONNECTED) && (conn = jmx.getMBeanServerConnection()) != null) {
            try {
                Long cputime = (Long)conn.getAttribute(osName, PROCESS_CPU_TIME_ATTR);
                return cputime * this.processCPUTimeMultiplier;
            }
            catch (Exception ex) {
                LOGGER.throwing(JmxSupport.class.getName(), "hasProcessCPUTimeAttribute", ex);
            }
        }
        return -1L;
    }

    int getAvailableProcessors() {
        OperatingSystemMXBean osMXBean;
        JvmMXBeans jmx = this.getJvmMXBeans();
        if (jmx != null && (osMXBean = jmx.getOperatingSystemMXBean()) != null) {
            return osMXBean.getAvailableProcessors();
        }
        return -1;
    }

    synchronized JvmMXBeans getJvmMXBeans() {
        JmxModel jmxModel;
        if (this.mxbeans == null && (jmxModel = JmxModelFactory.getJmxModelFor((Application)this.application)) != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            this.mxbeans = JvmMXBeansFactory.getJvmMXBeans((JmxModel)jmxModel);
        }
        return this.mxbeans;
    }

    synchronized Collection<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        JvmMXBeans jmx;
        if (this.gcList == null && (jmx = this.getJvmMXBeans()) != null) {
            this.gcList = jmx.getGarbageCollectorMXBeans();
        }
        return this.gcList;
    }

    String getJvmArgs() {
        try {
            RuntimeMXBean runtime = this.getRuntime();
            if (runtime != null) {
                StringBuilder buf = new StringBuilder();
                List<String> args = runtime.getInputArguments();
                for (String arg : args) {
                    buf.append(arg).append(' ');
                }
                return buf.toString().trim();
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.throwing(JmxSupport.class.getName(), "getJvmArgs", e);
            return null;
        }
    }

    MemoryPoolMXBean getPermGenPool() {
        try {
            JvmMXBeans jmx;
            if (this.permGenPool == null && (jmx = this.getJvmMXBeans()) != null) {
                Collection pools = jmx.getMemoryPoolMXBeans();
                for (MemoryPoolMXBean pool : pools) {
                    MemoryType type = pool.getType();
                    String name = pool.getName();
                    if (!MemoryType.NON_HEAP.equals((Object)type) || !PERM_GEN.equals(name) && !PS_PERM_GEN.equals(name) && !CMS_PERM_GEN.equals(name) && !G1_PERM_GEN.equals(name) && !METASPACE.equals(name) && !IBM_PERM_GEN.equals(name)) continue;
                    this.permGenPool = pool;
                    break;
                }
            }
            return this.permGenPool;
        }
        catch (Exception e) {
            LOGGER.throwing(JmxSupport.class.getName(), "getPermGenPool", e);
            return null;
        }
    }

    String[] getGenName() {
        if (this.genName == null) {
            MemoryPoolMXBean permPool = this.getPermGenPool();
            this.initGenName();
            if (permPool != null) {
                String name = permPool.getName();
                String label = METASPACE.equals(name) ? NbBundle.getMessage(JmxSupport.class, (String)"LBL_Meta") : NbBundle.getMessage(JmxSupport.class, (String)"LBL_PermGen");
                this.genName[1] = label;
            }
        }
        return this.genName;
    }

    void initGenName() {
        this.genName = new String[2];
        this.genName[0] = NbBundle.getMessage(JmxSupport.class, (String)"LBL_Heap");
        this.genName[1] = NbBundle.getMessage(JmxSupport.class, (String)"LBL_NA");
    }

    void initTimer() {
        int interval = GlobalPreferences.sharedInstance().getMonitoredDataPoll() * 1000;
        final JvmMXBeans jmx = this.getJvmMXBeans();
        if (jmx != null) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    if (JmxSupport.this.application.getState() == 1) {
                        try {
                            MonitoredDataImpl data = new MonitoredDataImpl(JmxSupport.this, jmx);
                            JmxSupport.this.jvm.notifyListeners(data);
                        }
                        catch (UndeclaredThrowableException e) {
                            LOGGER.throwing(JmxSupport.class.getName(), "MonitoredDataImpl<init>", e);
                        }
                    }
                }
            };
            this.timer = new Timer("JMX MonitoredData timer for " + this.application.getId());
            this.timer.schedule(task, INITIAL_DELAY, (long)interval);
        }
    }

    void disableTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    private static ObjectName getOSName() {
        try {
            return new ObjectName("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void dataRemoved(Object dataSource) {
        this.disableTimer();
    }
}

