/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor;

import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.transform.AbstractCodeWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public final class CodeWriter
extends AbstractCodeWriter {
    private final Element originalElement;
    private final ProcessingEnvironment env;

    public CodeWriter(ProcessingEnvironment env, Element originalElement) {
        this.env = env;
        this.originalElement = originalElement;
    }

    @Override
    protected Writer createWriter(CodeTypeElement clazz) throws IOException {
        JavaFileObject jfo = this.env.getFiler().createSourceFile(clazz.getQualifiedName(), this.originalElement);
        return new BufferedWriter(jfo.openWriter());
    }

    @Override
    protected void writeHeader() {
        if (this.env == null) {
            return;
        }
        this.writeLn("// CheckStyle: start generated");
    }
}

