/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.dsl.processor.java.transform;

import com.oracle.truffle.dsl.processor.java.ElementUtils;
import com.oracle.truffle.dsl.processor.java.model.CodeElementScanner;
import com.oracle.truffle.dsl.processor.java.model.CodeExecutableElement;
import com.oracle.truffle.dsl.processor.java.model.CodeImport;
import com.oracle.truffle.dsl.processor.java.model.CodeTree;
import com.oracle.truffle.dsl.processor.java.model.CodeTreeKind;
import com.oracle.truffle.dsl.processor.java.model.CodeTypeElement;
import com.oracle.truffle.dsl.processor.java.model.CodeVariableElement;
import com.oracle.truffle.dsl.processor.java.transform.OrganizedImports;
import com.sun.org.apache.xpath.internal.functions.Function;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.ElementFilter;

public abstract class AbstractCodeWriter
extends CodeElementScanner<Void, Void> {
    private static final int MAX_LINE_LENGTH = Integer.MAX_VALUE;
    private static final int LINE_WRAP_INDENTS = 3;
    private static final int MAX_JAVADOC_LINE_LENGTH = 100;
    private static final String IDENT_STRING = "    ";
    private static final String LN = System.lineSeparator();
    protected Writer writer;
    private int indent;
    private boolean newLine;
    private int lineLength;
    private boolean lineWrapping = false;
    private boolean indentLineWrapping = true;
    private boolean lineWrappingAtWords = false;
    private String linePrefix;
    private int maxLineLength = Integer.MAX_VALUE;
    private OrganizedImports imports;

    protected abstract Writer createWriter(CodeTypeElement var1) throws IOException;

    @Override
    public Void visitType(CodeTypeElement e, Void p) {
        if (e.isTopLevelClass()) {
            Writer w = null;
            try {
                this.imports = OrganizedImports.organize(e);
                this.writer = w = new TrimTrailingSpaceWriter(this.createWriter(e));
                this.writeRootClass(e);
            }
            catch (IOException ex) {
                if (ex instanceof FilerException && ex.getMessage().startsWith("Source file already created")) {
                    Void void_ = null;
                    return void_;
                }
                throw new RuntimeException(ex);
            }
            finally {
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (Throwable throwable) {}
                }
                this.writer = null;
            }
        }
        this.writeClassImpl(e);
        return null;
    }

    private void writeRootClass(CodeTypeElement e) {
        this.writeHeader();
        if (e.getPackageName() != null && e.getPackageName().length() > 0) {
            this.write("package ").write(e.getPackageName()).write(";").writeLn();
            this.writeEmptyLn();
        }
        Set<CodeImport> generateImports = this.imports.generateImports();
        ArrayList<CodeImport> typeImports = new ArrayList<CodeImport>();
        ArrayList<CodeImport> staticImports = new ArrayList<CodeImport>();
        for (CodeImport codeImport : generateImports) {
            if (codeImport.isStaticImport()) {
                staticImports.add(codeImport);
                continue;
            }
            typeImports.add(codeImport);
        }
        Collections.sort(typeImports);
        Collections.sort(staticImports);
        for (CodeImport imp : staticImports) {
            imp.accept(this, null);
            this.writeLn();
        }
        if (!staticImports.isEmpty()) {
            this.writeEmptyLn();
        }
        for (CodeImport imp : typeImports) {
            imp.accept(this, null);
            this.writeLn();
        }
        if (!typeImports.isEmpty()) {
            this.writeEmptyLn();
        }
        this.writeClassImpl(e);
    }

    private String useImport(Element enclosedType, TypeMirror type, boolean rawType) {
        if (this.imports != null) {
            return this.imports.createTypeReference(enclosedType, type, rawType);
        }
        return ElementUtils.getSimpleName(type);
    }

    private void writeClassImpl(CodeTypeElement e) {
        if (e.getDocTree() != null) {
            this.visitTree(e.getDocTree(), null, (Element)e);
        }
        for (AnnotationMirror annotation : e.getAnnotationMirrors()) {
            this.visitAnnotation(e, annotation);
            this.writeLn();
        }
        this.writeModifiers(e.getModifiers(), true);
        if (e.getKind() == ElementKind.ENUM) {
            this.write("enum ");
        } else if (e.getKind() == ElementKind.INTERFACE) {
            this.write("interface ");
        } else {
            this.write("class ");
        }
        this.write(e.getSimpleName());
        this.writeTypeParameters(e, e.getTypeParameters());
        if (e.getKind() == ElementKind.CLASS) {
            if (e.getSuperclass() != null && !ElementUtils.getQualifiedName(e.getSuperclass()).equals("java.lang.Object")) {
                this.write(" extends ").write(this.useImport(e, e.getSuperclass(), false));
            }
            if (e.getImplements().size() > 0) {
                this.write(" implements ");
                for (int i = 0; i < e.getImplements().size(); ++i) {
                    this.write(this.useImport(e, e.getImplements().get(i), false));
                    if (i >= e.getImplements().size() - 1) continue;
                    this.write(", ");
                }
            }
        } else if (e.getKind() == ElementKind.INTERFACE && e.getImplements().size() > 0) {
            this.write(" extends ");
            for (int i = 0; i < e.getImplements().size(); ++i) {
                this.write(this.useImport(e, e.getImplements().get(i), false));
                if (i >= e.getImplements().size() - 1) continue;
                this.write(", ");
            }
        }
        this.write(" {").writeLn();
        this.writeEmptyLn();
        this.indent(1);
        List<VariableElement> staticFields = AbstractCodeWriter.getStaticFields(e);
        List<VariableElement> instanceFields = AbstractCodeWriter.getInstanceFields(e);
        for (int i = 0; i < staticFields.size(); ++i) {
            VariableElement field = staticFields.get(i);
            field.accept(this, null);
            if (e.getKind() == ElementKind.ENUM && i < staticFields.size() - 1) {
                this.write(",");
                this.writeLn();
                continue;
            }
            this.write(";");
            this.writeLn();
        }
        if (staticFields.size() > 0) {
            this.writeEmptyLn();
        }
        for (VariableElement field : instanceFields) {
            field.accept(this, null);
            this.write(";");
            this.writeLn();
        }
        if (instanceFields.size() > 0) {
            this.writeEmptyLn();
        }
        for (ExecutableElement method : ElementFilter.constructorsIn(e.getEnclosedElements())) {
            method.accept(this, null);
        }
        for (ExecutableElement method : AbstractCodeWriter.getInstanceMethods(e)) {
            method.accept(this, null);
        }
        for (ExecutableElement method : AbstractCodeWriter.getStaticMethods(e)) {
            method.accept(this, null);
        }
        for (TypeElement clazz : e.getInnerClasses()) {
            clazz.accept(this, null);
        }
        this.dedent(1);
        this.write("}");
        this.writeEmptyLn();
    }

    private void writeTypeParameters(Element enclosedType, List<? extends TypeParameterElement> parameters) {
        if (!parameters.isEmpty()) {
            this.write("<");
            String sep = "";
            for (TypeParameterElement typeParameterElement : parameters) {
                this.write(sep);
                this.write(typeParameterElement.getSimpleName().toString());
                if (!typeParameterElement.getBounds().isEmpty()) {
                    this.write(" extends ");
                    String genericBoundsSep = "";
                    for (TypeMirror typeMirror : typeParameterElement.getBounds()) {
                        this.write(genericBoundsSep);
                        this.write(this.useImport(enclosedType, typeMirror, false));
                        genericBoundsSep = ", ";
                    }
                }
                sep = ", ";
            }
            this.write(">");
        }
    }

    private static List<VariableElement> getStaticFields(CodeTypeElement clazz) {
        ArrayList<VariableElement> staticFields = new ArrayList<VariableElement>();
        for (VariableElement field : clazz.getFields()) {
            if (!field.getModifiers().contains((Object)Modifier.STATIC)) continue;
            staticFields.add(field);
        }
        return staticFields;
    }

    private static List<VariableElement> getInstanceFields(CodeTypeElement clazz) {
        ArrayList<VariableElement> instanceFields = new ArrayList<VariableElement>();
        for (VariableElement field : clazz.getFields()) {
            if (field.getModifiers().contains((Object)Modifier.STATIC)) continue;
            instanceFields.add(field);
        }
        return instanceFields;
    }

    private static List<ExecutableElement> getStaticMethods(CodeTypeElement clazz) {
        ArrayList<ExecutableElement> staticMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : clazz.getMethods()) {
            if (!method.getModifiers().contains((Object)Modifier.STATIC)) continue;
            staticMethods.add(method);
        }
        return staticMethods;
    }

    private static List<ExecutableElement> getInstanceMethods(CodeTypeElement clazz) {
        ArrayList<ExecutableElement> instanceMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : clazz.getMethods()) {
            if (method.getModifiers().contains((Object)Modifier.STATIC)) continue;
            instanceMethods.add(method);
        }
        return instanceMethods;
    }

    @Override
    public Void visitVariable(VariableElement f, Void p) {
        Element parent = f.getEnclosingElement();
        for (AnnotationMirror annotationMirror : f.getAnnotationMirrors()) {
            this.visitAnnotation(f, annotationMirror);
            this.write(" ");
        }
        CodeTree init = null;
        if (f instanceof CodeVariableElement) {
            init = ((CodeVariableElement)f).getInit();
        }
        if (parent != null && parent.getKind() == ElementKind.ENUM && f.getModifiers().contains((Object)Modifier.STATIC)) {
            this.write(f.getSimpleName());
            if (init != null) {
                this.write("(");
                this.visitTree(init, p, (Element)f);
                this.write(")");
            }
        } else {
            boolean bl;
            ExecutableElement method;
            this.writeModifiers(f.getModifiers(), true);
            boolean bl2 = false;
            if (parent != null && (parent.getKind() == ElementKind.METHOD || parent.getKind() == ElementKind.CONSTRUCTOR) && (method = (ExecutableElement)parent).isVarArgs() && method.getParameters().indexOf(f) == method.getParameters().size() - 1) {
                bl = true;
            }
            TypeMirror varType = f.asType();
            if (bl) {
                if (varType.getKind() == TypeKind.ARRAY) {
                    varType = ((ArrayType)varType).getComponentType();
                }
                this.write(this.useImport(f, varType, false));
                this.write("...");
            } else {
                this.write(this.useImport(f, varType, false));
            }
            this.write(" ");
            this.write(f.getSimpleName());
            if (init != null) {
                this.write(" = ");
                this.visitTree(init, p, (Element)f);
            }
        }
        return null;
    }

    private void visitAnnotation(Element enclosedElement, AnnotationMirror e) {
        this.write("@").write(this.useImport(enclosedElement, e.getAnnotationType(), true));
        if (!e.getElementValues().isEmpty()) {
            this.write("(");
            ExecutableElement defaultElement = AbstractCodeWriter.findExecutableElement(e.getAnnotationType(), "value");
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = e.getElementValues();
            if (defaultElement != null && values.size() == 1 && values.get(defaultElement) != null) {
                this.visitAnnotationValue(enclosedElement, values.get(defaultElement));
            } else {
                Set<? extends ExecutableElement> methodsSet = values.keySet();
                ArrayList<ExecutableElement> methodsList = new ArrayList<ExecutableElement>();
                for (ExecutableElement executableElement : methodsSet) {
                    if (values.get(executableElement) == null) continue;
                    methodsList.add(executableElement);
                }
                Collections.sort(methodsList, new Comparator<ExecutableElement>(){

                    @Override
                    public int compare(ExecutableElement o1, ExecutableElement o2) {
                        return o1.getSimpleName().toString().compareTo(o2.getSimpleName().toString());
                    }
                });
                for (int i = 0; i < methodsList.size(); ++i) {
                    ExecutableElement executableElement = (ExecutableElement)methodsList.get(i);
                    AnnotationValue value = values.get(executableElement);
                    this.write(executableElement.getSimpleName().toString());
                    this.write(" = ");
                    this.visitAnnotationValue(enclosedElement, value);
                    if (i >= methodsList.size() - 1) continue;
                    this.write(", ");
                }
            }
            this.write(")");
        }
    }

    private void visitAnnotationValue(Element enclosedElement, AnnotationValue e) {
        e.accept(new AnnotationValueWriterVisitor(enclosedElement), null);
    }

    private static ExecutableElement findExecutableElement(DeclaredType type, String name) {
        List<ExecutableElement> elements = ElementFilter.methodsIn(type.asElement().getEnclosedElements());
        for (ExecutableElement executableElement : elements) {
            if (!executableElement.getSimpleName().toString().equals(name)) continue;
            return executableElement;
        }
        return null;
    }

    @Override
    public void visitImport(CodeImport e, Void p) {
        this.write("import ");
        if (e.isStaticImport()) {
            this.write("static ");
        }
        this.write(e.getPackageName());
        this.write(".");
        this.write(e.getSymbolName());
        this.write(";");
    }

    @Override
    public Void visitExecutable(CodeExecutableElement e, Void p) {
        if (e.getDocTree() != null) {
            this.visitTree(e.getDocTree(), null, (Element)e);
        }
        for (AnnotationMirror annotation : e.getAnnotationMirrors()) {
            this.visitAnnotation(e, annotation);
            this.writeLn();
        }
        this.writeModifiers(e.getModifiers(), e.getEnclosingClass() == null || !e.getEnclosingClass().getModifiers().contains((Object)Modifier.FINAL));
        String name = e.getSimpleName().toString();
        if (!name.equals("<cinit>") && !name.equals("<init>")) {
            Element param;
            int i;
            List<TypeParameterElement> typeParameters = e.getTypeParameters();
            if (!typeParameters.isEmpty()) {
                this.write("<");
                for (i = 0; i < typeParameters.size(); ++i) {
                    param = typeParameters.get(i);
                    this.write(param.getSimpleName().toString());
                    List<? extends TypeMirror> bounds = param.getBounds();
                    if (!bounds.isEmpty()) {
                        this.write(" extends ");
                        for (int j = 0; j < bounds.size(); ++j) {
                            TypeMirror bound = bounds.get(i);
                            this.write(this.useImport(e, bound, true));
                            if (j >= bounds.size() - 1) continue;
                            this.write(" ");
                            this.write(", ");
                        }
                    }
                    if (i >= typeParameters.size() - 1) continue;
                    this.write(" ");
                    this.write(", ");
                }
                this.write("> ");
            }
            if (e.getReturnType() != null) {
                this.write(this.useImport(e, e.getReturnType(), false));
                this.write(" ");
            }
            this.write(e.getSimpleName());
            this.write("(");
            for (i = 0; i < e.getParameters().size(); ++i) {
                param = e.getParameters().get(i);
                param.accept(this, p);
                if (i >= e.getParameters().size() - 1) continue;
                this.write(", ");
            }
            this.write(")");
            List<TypeMirror> throwables = e.getThrownTypes();
            if (throwables.size() > 0) {
                this.write(" throws ");
                for (int i2 = 0; i2 < throwables.size(); ++i2) {
                    this.write(this.useImport(e, throwables.get(i2), true));
                    if (i2 >= throwables.size() - 1) continue;
                    this.write(", ");
                }
            }
        }
        if (e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.writeLn(";");
        } else if (e.getBodyTree() != null) {
            this.writeLn(" {");
            this.indent(1);
            this.visitTree(e.getBodyTree(), p, (Element)e);
            this.dedent(1);
            this.writeLn("}");
        } else if (e.getBody() != null) {
            this.write(" {");
            this.write(e.getBody());
            this.writeLn("}");
        } else {
            this.writeLn(" {");
            this.writeLn("}");
        }
        this.writeEmptyLn();
        return null;
    }

    @Override
    public void visitTree(CodeTree e, Void p, Element enclosingElement) {
        CodeTreeKind kind = e.getCodeKind();
        switch (kind) {
            case COMMA_GROUP: {
                List<CodeTree> children = e.getEnclosedElements();
                if (children == null) break;
                for (int i = 0; i < children.size(); ++i) {
                    this.visitTree(children.get(i), p, enclosingElement);
                    if (i >= e.getEnclosedElements().size() - 1) continue;
                    this.write(", ");
                }
                break;
            }
            case GROUP: {
                super.visitTree(e, p, enclosingElement);
                break;
            }
            case INDENT: {
                this.indent(1);
                super.visitTree(e, p, enclosingElement);
                this.dedent(1);
                break;
            }
            case NEW_LINE: {
                this.writeLn();
                break;
            }
            case STRING: {
                if (e.getString() != null) {
                    String s = e.getString();
                    if (this.lineWrappingAtWords) {
                        int index = -1;
                        int start = 0;
                        while ((index = s.indexOf(32, start)) != -1) {
                            this.write(s.substring(start, index + 1));
                            start = index + 1;
                        }
                        if (start >= s.length()) break;
                        this.write(s.substring(start, s.length()));
                        break;
                    }
                    this.write(e.getString());
                    break;
                }
                this.write("null");
                break;
            }
            case STATIC_FIELD_REFERENCE: {
                if (e.getString() != null) {
                    this.write(this.imports.createStaticFieldReference(enclosingElement, e.getType(), e.getString()));
                    break;
                }
                this.write("null");
                break;
            }
            case STATIC_METHOD_REFERENCE: {
                if (e.getString() != null) {
                    this.write(this.imports.createStaticMethodReference(enclosingElement, e.getType(), e.getString()));
                    break;
                }
                this.write("null");
                break;
            }
            case TYPE: {
                this.write(this.useImport(enclosingElement, e.getType(), false));
                break;
            }
            case TYPE_LITERAL: {
                this.write(this.useImport(enclosingElement, e.getType(), true));
                this.write(".class");
                break;
            }
            case JAVA_DOC: 
            case DOC: {
                this.write("/*");
                if (kind == CodeTreeKind.JAVA_DOC) {
                    this.write("*");
                }
                this.write(" ");
                this.writeLn();
                this.indentLineWrapping = false;
                int prevMaxLineLength = this.maxLineLength;
                this.maxLineLength = 100;
                this.linePrefix = " * ";
                this.lineWrappingAtWords = true;
                super.visitTree(e, p, enclosingElement);
                this.linePrefix = null;
                this.lineWrappingAtWords = false;
                this.maxLineLength = prevMaxLineLength;
                this.writeLn();
                this.indentLineWrapping = true;
                this.write(" */");
                this.writeLn();
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
    }

    protected void writeHeader() {
    }

    private void writeModifiers(Set<Modifier> modifiers, boolean includeFinal) {
        if (modifiers != null && !modifiers.isEmpty()) {
            Modifier[] modArray = modifiers.toArray(new Modifier[modifiers.size()]);
            Arrays.sort((Object[])modArray);
            for (Modifier mod : modArray) {
                if (mod == Modifier.FINAL && !includeFinal) continue;
                this.write(mod.toString());
                this.write(" ");
            }
        }
    }

    private void indent(int count) {
        this.indent += count;
    }

    private void dedent(int count) {
        this.indent -= count;
    }

    private void writeLn() {
        this.writeLn("");
    }

    protected void writeLn(String text) {
        this.write(text);
        this.write(LN);
        this.lineLength = 0;
        this.newLine = true;
        if (this.lineWrapping && this.indentLineWrapping) {
            this.dedent(3);
        }
        this.lineWrapping = false;
    }

    private void writeEmptyLn() {
        this.writeLn();
    }

    private AbstractCodeWriter write(Name name) {
        return this.write(name.toString());
    }

    private AbstractCodeWriter write(String m) {
        if (m.isEmpty()) {
            return this;
        }
        try {
            String s = m;
            this.lineLength += s.length();
            if (this.newLine && s != LN) {
                this.writeIndent();
                this.newLine = false;
            }
            if (this.lineLength > this.maxLineLength) {
                s = this.wrapLine(s);
            }
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private String wrapLine(String m) throws IOException {
        assert (!m.isEmpty());
        char firstCharacter = m.charAt(0);
        char lastCharacter = m.charAt(m.length() - 1);
        if (firstCharacter == '\"' && lastCharacter == '\"') {
            String string = m.substring(1, m.length() - 1);
            if (string.isEmpty()) {
                return m;
            }
            this.lineLength -= m.length();
            int size = 0;
            for (int i = 0; i < string.length(); i += size) {
                int nextSize;
                if (i != 0) {
                    this.write("+ ");
                }
                if ((nextSize = this.maxLineLength - this.lineLength - 2) <= 0) {
                    this.writeLn();
                    nextSize = this.maxLineLength - this.lineLength - 2;
                }
                int end = Math.min(i + nextSize, string.length());
                this.write("\"");
                this.write(string.substring(i, end));
                this.write("\"");
                size = nextSize;
            }
            return "";
        }
        if (!Character.isAlphabetic(firstCharacter) && firstCharacter != '+') {
            return m;
        }
        if (!this.lineWrapping && this.indentLineWrapping) {
            this.indent(3);
        }
        this.lineWrapping = true;
        this.lineLength = 0;
        this.write(LN);
        this.writeIndent();
        return m;
    }

    private void writeIndent() throws IOException {
        this.lineLength += this.indentSize();
        for (int i = 0; i < this.indent; ++i) {
            this.writer.write(IDENT_STRING);
        }
        if (this.linePrefix != null) {
            this.lineLength += this.linePrefix.length();
            this.writer.write(this.linePrefix);
        }
    }

    private int indentSize() {
        return IDENT_STRING.length() * this.indent;
    }

    private static class TrimTrailingSpaceWriter
    extends Writer {
        private final Writer delegate;
        private final StringBuilder buffer = new StringBuilder();

        TrimTrailingSpaceWriter(Writer delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.buffer.append(cbuf, off, len);
            int newLinePoint = this.buffer.indexOf(LN);
            if (newLinePoint != -1) {
                String lhs = TrimTrailingSpaceWriter.trimTrailing(this.buffer.substring(0, newLinePoint));
                this.delegate.write(lhs);
                this.delegate.write(LN);
                this.buffer.delete(0, newLinePoint + 1);
            }
        }

        private static String trimTrailing(String s) {
            int cut = 0;
            for (int i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
                ++cut;
            }
            if (cut > 0) {
                return s.substring(0, s.length() - cut);
            }
            return s;
        }
    }

    private class AnnotationValueWriterVisitor
    extends AbstractAnnotationValueVisitor8<Void, Void> {
        private final Element enclosedElement;

        AnnotationValueWriterVisitor(Element enclosedElement) {
            this.enclosedElement = enclosedElement;
        }

        @Override
        public Void visitBoolean(boolean b, Void p) {
            AbstractCodeWriter.this.write(Boolean.toString(b));
            return null;
        }

        @Override
        public Void visitByte(byte b, Void p) {
            AbstractCodeWriter.this.write(Byte.toString(b));
            return null;
        }

        @Override
        public Void visitChar(char c, Void p) {
            AbstractCodeWriter.this.write(Character.toString(c));
            return null;
        }

        @Override
        public Void visitDouble(double d, Void p) {
            AbstractCodeWriter.this.write(Double.toString(d));
            return null;
        }

        @Override
        public Void visitFloat(float f, Void p) {
            AbstractCodeWriter.this.write(Float.toString(f));
            return null;
        }

        @Override
        public Void visitInt(int i, Void p) {
            AbstractCodeWriter.this.write(Integer.toString(i));
            return null;
        }

        @Override
        public Void visitLong(long i, Void p) {
            AbstractCodeWriter.this.write(Long.toString(i));
            return null;
        }

        @Override
        public Void visitShort(short s, Void p) {
            AbstractCodeWriter.this.write(Short.toString(s));
            return null;
        }

        @Override
        public Void visitString(String s, Void p) {
            AbstractCodeWriter.this.write("\"");
            AbstractCodeWriter.this.write(s);
            AbstractCodeWriter.this.write("\"");
            return null;
        }

        @Override
        public Void visitType(TypeMirror t, Void p) {
            AbstractCodeWriter.this.write(AbstractCodeWriter.this.useImport(this.enclosedElement, t, true));
            AbstractCodeWriter.this.write(".class");
            return null;
        }

        @Override
        public Void visitEnumConstant(VariableElement c, Void p) {
            AbstractCodeWriter.this.write(AbstractCodeWriter.this.useImport(this.enclosedElement, c.asType(), true));
            AbstractCodeWriter.this.write(".");
            AbstractCodeWriter.this.write(c.getSimpleName().toString());
            return null;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a, Void p) {
            AbstractCodeWriter.this.visitAnnotation(this.enclosedElement, a);
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> vals, Void p) {
            AbstractCodeWriter.this.write("{");
            for (int i = 0; i < vals.size(); ++i) {
                AnnotationValue value = vals.get(i);
                AbstractCodeWriter.this.visitAnnotationValue(this.enclosedElement, value);
                if (i >= vals.size() - 1) continue;
                AbstractCodeWriter.this.write(", ");
            }
            AbstractCodeWriter.this.write("}");
            return null;
        }
    }

    static class Foobar<S extends Function, BiFunction> {
        Foobar() {
        }
    }
}

