/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer;

import com.oracle.svm.shadowed.org.bytedeco.javacpp.Pointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.ShortPointer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.Bfloat16Indexer;
import com.oracle.svm.shadowed.org.bytedeco.javacpp.indexer.Raw;

public class Bfloat16RawIndexer
extends Bfloat16Indexer {
    protected static final Raw RAW = Raw.getInstance();
    protected ShortPointer pointer;
    final long base;
    final long size;

    public Bfloat16RawIndexer(ShortPointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public Bfloat16RawIndexer(ShortPointer pointer, long ... sizes) {
        this(pointer, sizes, Bfloat16RawIndexer.strides(sizes));
    }

    public Bfloat16RawIndexer(ShortPointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position() * 2L;
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public float get(long i) {
        return Bfloat16RawIndexer.toFloat(RAW.getShort(this.base + Bfloat16RawIndexer.checkIndex(i, this.size) * 2L));
    }

    @Override
    public Bfloat16Indexer get(long i, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = this.get(i * this.strides[0] + (long)n);
        }
        return this;
    }

    @Override
    public float get(long i, long j) {
        return this.get(i * this.strides[0] + j);
    }

    @Override
    public Bfloat16Indexer get(long i, long j, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n);
        }
        return this;
    }

    @Override
    public float get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public float get(long ... indices) {
        return this.get(this.index(indices));
    }

    @Override
    public Bfloat16Indexer get(long[] indices, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            h[offset + n] = this.get(this.index(indices) + (long)n);
        }
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, float h) {
        RAW.putShort(this.base + Bfloat16RawIndexer.checkIndex(i, this.size) * 2L, (short)Bfloat16RawIndexer.fromFloat(h));
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, h[offset + n]);
        }
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, long j, float h) {
        this.put(i * this.strides[0] + j, h);
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, long j, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, h[offset + n]);
        }
        return this;
    }

    @Override
    public Bfloat16Indexer put(long i, long j, long k, float h) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, h);
        return this;
    }

    @Override
    public Bfloat16Indexer put(long[] indices, float h) {
        this.put(this.index(indices), h);
        return this;
    }

    @Override
    public Bfloat16Indexer put(long[] indices, float[] h, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, h[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

