/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.dynamicobject;

import java.util.Map;
import java.util.WeakHashMap;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;

public class DynamicObjectDetailsProvider
extends DetailsProvider.Basic {
    private static final String DYNAMIC_OBJECT_MASK = "com.oracle.truffle.api.object.DynamicObject+";
    private static final String SHAPE_MASK = "com.oracle.truffle.api.object.Shape+";
    private static final String JS_UNDEFIED_CLASS_FQN = "com.oracle.truffle.js.runtime.objects.Undefined";
    private static final String JS_NULL_CLASS_FQN = "com.oracle.truffle.js.runtime.objects.Null";
    private Map<Heap, Long> jsUndefidedId = new WeakHashMap<Heap, Long>();
    private Map<Heap, Long> jsNullId = new WeakHashMap<Heap, Long>();

    public DynamicObjectDetailsProvider() {
        super(new String[]{DYNAMIC_OBJECT_MASK, SHAPE_MASK});
    }

    public String getDetailsString(String className, Instance instance, Heap heap) {
        if (DYNAMIC_OBJECT_MASK.equals(className)) {
            StringBuilder buf = new StringBuilder();
            Long undefinedId = this.getJSUdefined(heap);
            Long nullId = this.getJSNull(heap);
            if (instance.getInstanceId() == undefinedId.longValue()) {
                buf.append("undefined");
            } else if (instance.getInstanceId() == nullId.longValue()) {
                buf.append("null");
            } else {
                Instance shape = (Instance)instance.getValueOfField("shape");
                Instance objectType = (Instance)shape.getValueOfField("objectType");
                buf.append('(').append(DynamicObjectDetailsProvider.getSimpleClassName(objectType)).append(')');
                buf.append(' ').append(DynamicObjectDetailsProvider.getShortInstanceId(shape));
            }
            return buf.toString();
        }
        if (SHAPE_MASK.equals(className)) {
            Instance objectType = (Instance)instance.getValueOfField("objectType");
            String name = DetailsSupport.getDetailsString((Instance)objectType, (Heap)heap);
            if (name == null) {
                name = DynamicObjectDetailsProvider.getSimpleClassName(objectType);
            }
            return name;
        }
        return null;
    }

    private static String getShortInstanceId(Instance instance) {
        if (instance == null) {
            return "null";
        }
        return DynamicObjectDetailsProvider.getSimpleClassName(instance) + "#" + instance.getInstanceNumber();
    }

    private static String getSimpleClassName(Instance instance) {
        String name = instance.getJavaClass().getName();
        int last = name.lastIndexOf(46);
        if (last != -1) {
            name = name.substring(last + 1);
        }
        return name;
    }

    private Long getJSUdefined(Heap heap) {
        return this.getInstanceId(this.jsUndefidedId, heap, JS_UNDEFIED_CLASS_FQN);
    }

    private Long getJSNull(Heap heap) {
        return this.getInstanceId(this.jsNullId, heap, JS_NULL_CLASS_FQN);
    }

    private Long getInstanceId(Map<Heap, Long> objectId, Heap heap, String classFqn) {
        if (heap == null) {
            return 0L;
        }
        Long undef = objectId.get(heap);
        if (undef == null) {
            Instance undefinedInstance;
            JavaClass undefinedClass = heap.getJavaClassByName(classFqn);
            if (undefinedClass != null && (undefinedInstance = (Instance)undefinedClass.getValueOfStaticField("instance")) != null) {
                undef = new Long(undefinedInstance.getInstanceId());
            }
            if (undef == null) {
                undef = 0L;
            }
            objectId.put(heap, undef);
        }
        return undef;
    }
}

