/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.r;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.heapviewer.truffle.TruffleFrame;
import org.graalvm.visualvm.heapviewer.truffle.TruffleObject;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.lib.jfluid.heap.ArrayItemValue;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.jfluid.heap.Type;
import org.graalvm.visualvm.lib.jfluid.heap.Value;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

class RObject
extends TruffleObject.InstanceBased {
    static final String R_OBJECT_FQN = "com.oracle.truffle.r.runtime.data.RBaseObject";
    static final String R_SCALAR_FQN = "com.oracle.truffle.r.runtime.data.RScalarVector";
    static final String R_WRAPPER_FQN = "com.oracle.truffle.r.runtime.data.RForeignWrapper";
    private static final String RLOGICAL_VECTOR_FQN = "com.oracle.truffle.r.runtime.data.RLogicalVector";
    private static final String RCOMPLEX_VECTOR_FQN = "com.oracle.truffle.r.runtime.data.RComplexVector";
    private static final String RPAIR_LIST_FQN = "com.oracle.truffle.r.runtime.data.RPairList";
    private static final String RNULL_FQN = "com.oracle.truffle.r.runtime.data.RNull";
    private static final String[] typeMaping = new String[]{"RRawVector", "raw", "RRaw", "raw", "RLogicalVector", "logical", "RLogical", "logical", "RIntVector", "integer", "RInteger", "integer", "RForeignIntWrapper", "integer", "RIntSequence", "integer", "RDoubleVector", "double", "RDouble", "double", "RForeignDoubleWrapper", "double", "RComplexVector", "complex", "RComplex", "complex", "RStringVector", "character", "RString", "character", "RForeignStringWrapper", "character", "RList", "list", "RScalarList", "list", "RExpression", "expression", "RFunction", "closure", "RSymbol", "symbol", "REnvironment", "environment", "RPairList", "pairlist", "RArgsValuesAndNames", "pairlist", "RLanguage", "language", "RPromise", "promise", "RExternalPtr", "externalptr", "StdConnections", "connection", "RS4Object", "S4", "CharSXPWrapper", "charsxp_wrapper"};
    private static Map<String, String> typeMap = new HashMap<String, String>();
    private final Instance instance;
    private Instance data;
    private final Boolean complete;
    private final Integer refCount;
    private final Instance attributesInstance;
    private final String className;
    private final Instance frameInstance;
    private final String dataType;
    private DynamicObject attributes;
    private final List<FieldValue> fieldValues;
    private boolean namesComputed;
    private List<String> names;
    private boolean dimComputed;
    private List<Integer> dim;
    private TruffleFrame frame;
    private String type;

    public RObject(Instance instance) {
        this(null, instance);
    }

    public RObject(String type, Instance instance) {
        this.instance = instance;
        this.type = type;
        this.data = RObject.findDataField(instance);
        Object[] values = HeapUtils.getValuesOfFields((Instance)instance, (String[])new String[]{"complete", "refCount", "attributes", "frameAccess"});
        Object completeO = values[0];
        this.complete = completeO == null ? null : Boolean.valueOf(Boolean.parseBoolean(completeO.toString()));
        Object refCountO = values[1];
        this.refCount = refCountO == null ? null : Integer.valueOf(Integer.parseInt(refCountO.toString()));
        this.attributesInstance = (Instance)values[2];
        this.className = instance.getJavaClass().getName();
        this.dataType = this.data == null ? null : this.data.getJavaClass().getName().replace("[]", "");
        this.fieldValues = new LazyFieldValues();
        Instance frameAccess = (Instance)values[3];
        this.frameInstance = frameAccess != null ? (Instance)frameAccess.getValueOfField("frame") : null;
        if (this.data == null && RPAIR_LIST_FQN.equals(this.className)) {
            this.data = new RPairList(instance);
        }
        if (this.data == null && RObject.isSubClassOf(instance, R_WRAPPER_FQN)) {
            this.data = RObject.getDataFromWrapper(instance);
        }
    }

    public static boolean isRObject(Instance rObj) {
        return RObject.isSubClassOf(rObj, R_OBJECT_FQN) || RObject.isSubClassOf(rObj, R_SCALAR_FQN) || RObject.isSubClassOf(rObj, R_WRAPPER_FQN);
    }

    private static boolean isSubClassOf(Instance i, String superClassName) {
        if (i != null) {
            for (JavaClass superCls = i.getJavaClass().getSuperClass(); superCls != null; superCls = superCls.getSuperClass()) {
                if (!superCls.getName().equals(superClassName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Instance getInstance() {
        return this.instance;
    }

    @Override
    public String getType(Heap heap) {
        if (this.type == null) {
            this.type = RObject.getType(this.className);
        }
        return this.type;
    }

    @Override
    public long getTypeId(Heap heap) {
        return this.instance.getJavaClass().getJavaClassId();
    }

    static String getRType(Instance instance) {
        return RObject.getType(instance.getJavaClass().getName());
    }

    private static String getType(String className) {
        String convertedType;
        String type = className.substring(className.lastIndexOf(46) + 1);
        int dindex = type.indexOf(36);
        if (dindex > 0) {
            type = type.substring(0, dindex);
        }
        if ((convertedType = typeMap.get(type)) != null) {
            return convertedType;
        }
        return type;
    }

    @Override
    public long getSize() {
        long size = this.instance.getSize();
        if (this.data != null) {
            size += this.data.getSize();
        }
        return size;
    }

    @Override
    public long getRetainedSize() {
        return this.instance.getRetainedSize();
    }

    public List getValues() {
        if (this.data != null) {
            if (this.data instanceof PrimitiveArrayInstance) {
                return ((PrimitiveArrayInstance)this.data).getValues();
            }
            if (this.data instanceof ObjectArrayInstance) {
                return ((ObjectArrayInstance)this.data).getValues();
            }
        }
        return Collections.emptyList();
    }

    public int getLength() {
        if (this.data != null) {
            if (this.data instanceof PrimitiveArrayInstance) {
                int len = ((PrimitiveArrayInstance)this.data).getLength();
                if (RCOMPLEX_VECTOR_FQN.equals(this.className)) {
                    return len / 2;
                }
                return len;
            }
            if (this.data instanceof ObjectArrayInstance) {
                return ((ObjectArrayInstance)this.data).getLength();
            }
        }
        return 0;
    }

    public boolean isPrimitiveArray() {
        return this.data instanceof PrimitiveArrayInstance;
    }

    public final boolean isTemporary() {
        return this.refCount == 0;
    }

    public final boolean isShared() {
        return this.refCount > 1;
    }

    public final boolean isComplete() {
        return this.complete;
    }

    public List<String> names() {
        FieldValue nameValue;
        if (this.namesComputed) {
            return this.names;
        }
        DynamicObject attrs = this.getAttributes();
        this.namesComputed = true;
        if (attrs != null && (nameValue = attrs.getFieldValue("names")) instanceof ObjectFieldValue) {
            Instance nameInst = ((ObjectFieldValue)nameValue).getInstance();
            List namesArr = new RObject(nameInst).getValues();
            this.names = new ArrayList<String>(namesArr.size());
            for (Object name : namesArr) {
                Instance string = (Instance)name;
                this.names.add(DetailsUtils.getInstanceString((Instance)string, null));
            }
            return this.names;
        }
        return null;
    }

    public List<Integer> getDim() {
        FieldValue dimsValue;
        if (this.dimComputed) {
            return this.dim;
        }
        DynamicObject attrs = this.getAttributes();
        this.dimComputed = true;
        if (attrs != null && (dimsValue = attrs.getFieldValue("dim")) instanceof ObjectFieldValue) {
            Instance dimsInst = ((ObjectFieldValue)dimsValue).getInstance();
            List dimsArr = new RObject(dimsInst).getValues();
            this.dim = new ArrayList<Integer>(dimsArr.size());
            for (Object string : dimsArr) {
                this.dim.add(Integer.valueOf((String)string));
            }
            return this.dim;
        }
        return null;
    }

    List<FieldValue> getFieldValues() {
        return this.fieldValues;
    }

    DynamicObject getAttributes() {
        if (this.attributes == null && this.attributesInstance != null) {
            this.attributes = new DynamicObject(this.attributesInstance);
        }
        return this.attributes;
    }

    TruffleFrame getFrame() {
        if (this.frame == null && this.frameInstance != null) {
            this.frame = new TruffleFrame(this.frameInstance);
        }
        return this.frame;
    }

    List<FieldValue> getReferences() {
        List refs = this.instance.getReferences();
        ArrayList<FieldValue> robjRefs = new ArrayList<FieldValue>();
        for (Value ref : refs) {
            Instance defInstance = ref.getDefiningInstance();
            if (ref instanceof ArrayItemValue && defInstance instanceof ObjectArrayInstance) {
                List arrRefs = defInstance.getReferences();
                for (Value arrRef : arrRefs) {
                    ObjectFieldValue arrRefFV;
                    Instance rInstance = arrRef.getDefiningInstance();
                    if (RObject.isRObject(rInstance)) {
                        RObject robject = new RObject(rInstance);
                        int index = ((ArrayItemValue)ref).getIndex();
                        robjRefs.add(robject.getFieldValues().get(index));
                    } else if (TruffleFrame.isTruffleFrame(rInstance) && arrRef instanceof ObjectFieldValue && (arrRefFV = (ObjectFieldValue)arrRef).getField().getName().equals("locals")) {
                        List<Instance> frefs = this.getObjectFieldValueRefs(rInstance, "frame");
                        for (Instance fref : frefs) {
                            List<Instance> farefs = this.getObjectFieldValueRefs(fref, "frameAccess");
                            for (Instance rObj : farefs) {
                                RObject refRObj;
                                TruffleFrame refFrame;
                                if (!RObject.isRObject(rObj) || (refFrame = (refRObj = new RObject(rObj)).getFrame()) == null) continue;
                                for (FieldValue fv : refFrame.getLocalFieldValues()) {
                                    if (!(fv instanceof ObjectFieldValue)) continue;
                                    ObjectFieldValue ofv = (ObjectFieldValue)fv;
                                    if (!this.getInstance().equals(ofv.getInstance())) continue;
                                    robjRefs.add((FieldValue)new FrameFieldValue(rObj, ofv));
                                }
                            }
                        }
                    }
                    this.addAttribute(rInstance, robjRefs);
                }
            }
            if (defInstance != null && defInstance.getJavaClass().getName().equals(RPAIR_LIST_FQN)) {
                FieldValue rootReference = this.findRootRPairList(defInstance);
                robjRefs.add(rootReference);
            }
            this.addAttribute(defInstance, robjRefs);
        }
        return robjRefs;
    }

    private List<Instance> getObjectFieldValueRefs(Instance refInstance, String fieldName) {
        ArrayList<Instance> foundRefs = new ArrayList<Instance>();
        List refs = refInstance.getReferences();
        for (Value ref : refs) {
            ObjectFieldValue refo;
            if (!(ref instanceof ObjectFieldValue) || !fieldName.equals((refo = (ObjectFieldValue)ref).getField().getName())) continue;
            foundRefs.add(refo.getDefiningInstance());
        }
        return foundRefs;
    }

    private void addAttribute(Instance dynObjInstance, List<FieldValue> robjRefs) {
        if (DynamicObject.isDynamicObject(dynObjInstance)) {
            List refs = dynObjInstance.getReferences();
            for (Value ref : refs) {
                RObject robject;
                DynamicObject attrs;
                Instance defInstance = ref.getDefiningInstance();
                if (!RObject.isRObject(defInstance) || (attrs = (robject = new RObject(defInstance)).getAttributes()) == null || !attrs.getInstance().equals(dynObjInstance)) continue;
                for (FieldValue fv : attrs.getFieldValues()) {
                    ObjectFieldValue ofv;
                    if (!(fv instanceof ObjectFieldValue) || !(ofv = (ObjectFieldValue)fv).getInstance().equals(this.instance)) continue;
                    robjRefs.add(fv);
                }
            }
        }
    }

    private FieldValue findRootRPairList(Instance pairList) {
        int index = 0;
        Instance parent = this.getParentRlist(pairList);
        while (parent != null) {
            ++index;
            pairList = parent;
            parent = this.getParentRlist(parent);
        }
        return new RObject(pairList).getFieldValues().get(index);
    }

    private Instance getParentRlist(Instance pairList) {
        ObjectFieldValue fval;
        Instance parent;
        Value val;
        List refs = pairList.getReferences();
        if (refs.size() == 1 && (val = (Value)refs.get(0)) instanceof ObjectFieldValue && (parent = (fval = (ObjectFieldValue)val).getDefiningInstance()).getJavaClass().getName().equals(RPAIR_LIST_FQN) && fval.getField().getName().equals("cdr")) {
            return parent;
        }
        return null;
    }

    static Instance getDataFromWrapper(Instance instance) {
        Instance proxy;
        Instance delegate = (Instance)instance.getValueOfField("delegate");
        if (delegate != null && (proxy = (Instance)delegate.getValueOfField("proxy")) != null) {
            return (Instance)proxy.getValueOfField("val$values");
        }
        return null;
    }

    static Instance findDataField(Instance instance) {
        for (Object val : instance.getFieldValues()) {
            Instance data;
            FieldValue fv = (FieldValue)val;
            if (!(fv instanceof ObjectFieldValue) || !"data".equals(fv.getField().getName()) || (data = ((ObjectFieldValue)fv).getInstance()) == null || instance.equals(data)) continue;
            if (data.getJavaClass().isArray()) {
                return data;
            }
            return RObject.findDataField(data);
        }
        return null;
    }

    static {
        for (int i = 0; i < typeMaping.length; i += 2) {
            typeMap.put(typeMaping[i], typeMaping[i + 1]);
        }
    }

    private class RNamedField
    extends RField {
        private final String name;

        private RNamedField(String n, int i) {
            super(i);
            this.name = n;
        }

        @Override
        public Type getType() {
            return new Type(){

                public String getName() {
                    return RNamedField.this.name;
                }
            };
        }
    }

    private class RField
    implements Field {
        private int index;

        private RField(int i) {
            this.index = i;
        }

        public JavaClass getDeclaringClass() {
            return RObject.this.instance.getJavaClass();
        }

        public String getName() {
            List<Integer> dims = RObject.this.getDim();
            if (dims != null) {
                int rindex = this.index;
                StringBuilder name = new StringBuilder();
                for (Integer dim : dims) {
                    int offset = rindex % dim;
                    rindex /= dim.intValue();
                    name.append(offset + 1).append(',');
                }
                return '[' + name.substring(0, name.length() - 1) + ']';
            }
            List<String> names = RObject.this.names();
            String name = "[" + (this.index + 1) + "]";
            if (names != null) {
                return name + " (" + names.get(this.index) + ")";
            }
            return name;
        }

        public boolean isStatic() {
            return false;
        }

        public Type getType() {
            return new Type(){

                public String getName() {
                    return RObject.this.dataType;
                }
            };
        }
    }

    private class FrameFieldValue
    implements ObjectFieldValue {
        final ObjectFieldValue frameValue;
        final Instance rObject;

        private FrameFieldValue(Instance ro, ObjectFieldValue fv) {
            this.rObject = ro;
            this.frameValue = fv;
        }

        public Instance getInstance() {
            return this.frameValue.getInstance();
        }

        public Field getField() {
            return this.frameValue.getField();
        }

        public String getValue() {
            return this.frameValue.getValue();
        }

        public Instance getDefiningInstance() {
            return this.rObject;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof FrameFieldValue) {
                return this.frameValue.equals(obj);
            }
            return false;
        }

        public int hashCode() {
            return this.frameValue.hashCode();
        }
    }

    private class RObjectFieldValue
    implements ObjectFieldValue {
        private int index;

        private RObjectFieldValue(int i) {
            this.index = i;
        }

        public Instance getInstance() {
            return (Instance)RObject.this.getValues().get(this.index);
        }

        public Field getField() {
            return new RField(this.index);
        }

        public String getValue() {
            return String.valueOf(this.getInstance().getInstanceId());
        }

        public Instance getDefiningInstance() {
            return RObject.this.instance;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RObjectFieldValue) {
                RObjectFieldValue rfv = (RObjectFieldValue)obj;
                return RObject.this.instance.equals(rfv.getDefiningInstance()) && this.index == rfv.index;
            }
            return false;
        }

        public int hashCode() {
            return 31 * RObject.this.instance.hashCode() + this.index;
        }
    }

    private class RComplexFieldValue
    extends RFieldValue {
        public RComplexFieldValue(int i) {
            super(i);
        }

        @Override
        public Field getField() {
            return new RNamedField("complex", this.index);
        }

        @Override
        public String getValue() {
            List vals = RObject.this.getValues();
            return vals.get(2 * this.index) + "+" + vals.get(2 * this.index + 1) + "i";
        }
    }

    private class RLogicalFieldValue
    extends RFieldValue {
        public RLogicalFieldValue(int i) {
            super(i);
        }

        @Override
        public Field getField() {
            return new RNamedField("logical", this.index);
        }

        @Override
        public String getValue() {
            String valString = (String)RObject.this.getValues().get(this.index);
            int val = Integer.parseInt(valString);
            if (val == 0) {
                valString = "FALSE";
            } else if (val == 1) {
                valString = "TRUE";
            }
            return valString;
        }
    }

    private class RFieldValue
    implements FieldValue {
        int index;

        private RFieldValue(int i) {
            this.index = i;
        }

        public Field getField() {
            return new RField(this.index);
        }

        public String getValue() {
            return (String)RObject.this.getValues().get(this.index);
        }

        public Instance getDefiningInstance() {
            return RObject.this.instance;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RFieldValue) {
                RFieldValue rfv = (RFieldValue)obj;
                return RObject.this.instance.equals(rfv.getDefiningInstance()) && this.index == rfv.index;
            }
            return false;
        }

        public int hashCode() {
            return 31 * RObject.this.instance.hashCode() + this.index;
        }
    }

    private class LazyFieldValues
    extends AbstractList<FieldValue> {
        private LazyFieldValues() {
        }

        @Override
        public FieldValue get(int index) {
            if (RObject.this.isPrimitiveArray()) {
                if (RObject.RLOGICAL_VECTOR_FQN.equals(RObject.this.className)) {
                    return new RLogicalFieldValue(index);
                }
                if (RObject.RCOMPLEX_VECTOR_FQN.equals(RObject.this.className)) {
                    return new RComplexFieldValue(index);
                }
                return new RFieldValue(index);
            }
            return new RObjectFieldValue(index);
        }

        @Override
        public int size() {
            return RObject.this.getLength();
        }
    }

    private class RPairList
    implements ObjectArrayInstance {
        private Instance pairListInstance;
        private int length;
        private int size;
        private List values;

        private RPairList(Instance instance) {
            this.pairListInstance = instance;
            this.length = -1;
        }

        private void initData() {
            if (this.length == -1) {
                JavaClass pairListClass = this.pairListInstance.getJavaClass();
                boolean hasNames = false;
                this.length = 0;
                this.values = new ArrayList();
                ArrayList<String> nameList = new ArrayList<String>();
                for (Instance cdr = this.pairListInstance; cdr != null && cdr.getJavaClass().equals(pairListClass); cdr = (Instance)cdr.getValueOfField("cdr")) {
                    String name = this.getName((Instance)cdr.getValueOfField("tag"));
                    ++this.length;
                    this.values.add(cdr.getValueOfField("car"));
                    if (name != null) {
                        hasNames = true;
                    }
                    nameList.add(name);
                    this.size = (int)((long)this.size + cdr.getSize());
                }
                if (hasNames) {
                    RObject.this.namesComputed = true;
                    RObject.this.names = nameList;
                }
            }
        }

        public int getLength() {
            this.initData();
            return this.length;
        }

        public List getValues() {
            this.initData();
            return this.values;
        }

        public List getItems() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List getFieldValues() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isGCRoot() {
            return this.pairListInstance.isGCRoot();
        }

        public long getInstanceId() {
            return this.pairListInstance.getInstanceId() + 1L;
        }

        public int getInstanceNumber() {
            return this.pairListInstance.getInstanceNumber();
        }

        public JavaClass getJavaClass() {
            return this.pairListInstance.getJavaClass();
        }

        public Instance getNearestGCRootPointer() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getReachableSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public List getReferences() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getRetainedSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getSize() {
            this.initData();
            return this.size;
        }

        public List getStaticFieldValues() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Object getValueOfField(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean equals(Object obj) {
            if (obj instanceof RPairList) {
                RPairList rlist = (RPairList)obj;
                return this.pairListInstance.equals(rlist.pairListInstance);
            }
            return false;
        }

        public int hashCode() {
            return this.pairListInstance.hashCode();
        }

        private String getName(Instance tag) {
            if (tag != null) {
                if (tag.getJavaClass().getName().equals(RObject.RNULL_FQN)) {
                    return null;
                }
                return DetailsSupport.getDetailsString((Instance)tag, null);
            }
            return null;
        }
    }
}

