/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk11;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
public class JavaNetHttpFeature
extends JNIRegistrationUtil
implements Feature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return JavaVersionUtil.JAVA_SPEC >= 11;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        JavaNetHttpFeature.rerunClassInit((Feature.FeatureAccess)access, "jdk.internal.net.http.websocket.OpeningHandshake");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerReachabilityHandler(JavaNetHttpFeature::registerInitFiltersAccess, new Object[]{JavaNetHttpFeature.method((Feature.FeatureAccess)access, "jdk.internal.net.http.HttpClientImpl", "initFilters", new Class[0])});
    }

    private static void registerInitFiltersAccess(Feature.DuringAnalysisAccess a) {
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{JavaNetHttpFeature.clazz((Feature.FeatureAccess)a, "jdk.internal.net.http.AuthenticationFilter")});
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{JavaNetHttpFeature.clazz((Feature.FeatureAccess)a, "jdk.internal.net.http.RedirectFilter")});
        RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{JavaNetHttpFeature.clazz((Feature.FeatureAccess)a, "jdk.internal.net.http.CookieFilter")});
    }
}

