/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.VMError;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class CalleeSavedRegisters {
    protected final Register frameRegister;
    protected final List<Register> calleeSavedRegisters;
    protected final Map<Register, Integer> offsetsInSaveArea;
    protected final int saveAreaSize;
    protected final int saveAreaOffsetInFrame;

    @Fold
    public static boolean supportedByPlatform() {
        return SubstrateOptions.UseCalleeSavedRegisters.getValue() != false && ImageSingletons.contains(CalleeSavedRegisters.class);
    }

    @Fold
    public static CalleeSavedRegisters singleton() {
        return (CalleeSavedRegisters)ImageSingletons.lookup(CalleeSavedRegisters.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public CalleeSavedRegisters(Register frameRegister, List<Register> calleeSavedRegisters, Map<Register, Integer> offsetsInSaveArea, int saveAreaSize, int saveAreaOffsetInFrame) {
        this.frameRegister = frameRegister;
        this.calleeSavedRegisters = calleeSavedRegisters;
        this.offsetsInSaveArea = offsetsInSaveArea;
        this.saveAreaSize = saveAreaSize;
        this.saveAreaOffsetInFrame = saveAreaOffsetInFrame;
    }

    public void verifySaveAreaOffsetInFrame(int checkedSaveAreaOffsetInFrame) {
        VMError.guarantee(this.saveAreaOffsetInFrame == checkedSaveAreaOffsetInFrame, "Must have a single value for the callee save register area");
    }

    public int getSaveAreaSize() {
        return this.saveAreaSize;
    }

    public int getOffsetInFrame(Register register) {
        int result = this.saveAreaOffsetInFrame + this.offsetsInSaveArea.get(register);
        assert (result < 0) : "Note that the offset of a callee save register is negative, because it is located in the callee frame";
        return result;
    }
}

