/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.XOptions;
import com.oracle.svm.core.util.UserError;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Predicate;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.SpectrePHTMitigations;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionStability;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateOptions {
    @Option(help={"Class containing the default entry point method. Optional if --shared is used."}, type=OptionType.User)
    public static final HostedOptionKey<String> Class = new HostedOptionKey<String>("");
    @Option(help={"Name of the main entry point method. Optional if --shared is used."})
    public static final HostedOptionKey<String> Method = new HostedOptionKey<String>("main");
    @Option(help={"Name of the output file to be generated"}, type=OptionType.User)
    public static final HostedOptionKey<String> Name = new HostedOptionKey<String>("");
    @APIOption(name="shared")
    @Option(help={"Build shared library"})
    public static final HostedOptionKey<Boolean> SharedLibrary = new HostedOptionKey<Boolean>(false);
    @APIOption(name="static")
    @Option(help={"Build statically linked executable (requires static libc and zlib)"})
    public static final HostedOptionKey<Boolean> StaticExecutable = new HostedOptionKey<Boolean>(false);
    @Option(help={"Builds a statically linked executable with libc dynamically linked"}, type=OptionType.Expert, stability=OptionStability.EXPERIMENTAL)
    public static final HostedOptionKey<Boolean> StaticExecutableWithDynamicLibC = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            StaticExecutable.update(values, true);
            super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
        }
    };
    public static final int ForceFallback = 10;
    public static final int Automatic = 5;
    public static final int NoFallback = 0;
    public static final String OptionNameForceFallback = "force-fallback";
    public static final String OptionNameAutoFallback = "auto-fallback";
    public static final String OptionNameNoFallback = "no-fallback";
    @APIOption.List(value={@APIOption(name="force-fallback", fixedValue={"10"}, customHelp="force building of fallback image"), @APIOption(name="auto-fallback", fixedValue={"5"}, customHelp="build stand-alone image if possible"), @APIOption(name="no-fallback", fixedValue={"0"}, customHelp="build stand-alone image or report failure")})
    @Option(help={"Define when fallback-image generation should be used."})
    public static final HostedOptionKey<Integer> FallbackThreshold = new HostedOptionKey<Integer>(5);
    public static final String IMAGE_CLASSPATH_PREFIX = "-imagecp";
    public static final String WATCHPID_PREFIX = "-watchpid";
    private static ValueUpdateHandler optimizeValueUpdateHandler;
    private static ValueUpdateHandler debugInfoValueUpdateHandler;
    @Option(help={"Show available options based on comma-separated option-types (allowed categories: User, Expert, Debug)."})
    public static final OptionKey<String> PrintFlags;
    @Option(help={"Print extra help, if available, based on comma-separated option names. Pass * to show all options that contain extra help."})
    public static final OptionKey<String> PrintFlagsWithExtraHelp;
    @Option(help={"Control native-image code optimizations: 0 - no optimizations, 1 - basic optimizations, 2 - aggressive optimizations."}, type=OptionType.User)
    public static final HostedOptionKey<Integer> Optimize;
    @Option(help={"Track NodeSourcePositions during runtime-compilation"})
    public static final HostedOptionKey<Boolean> IncludeNodeSourcePositions;
    @Option(help={"Search path for C libraries passed to the linker (list of comma-separated directories)"})
    public static final HostedOptionKey<String[]> CLibraryPath;
    @Option(help={"Path passed to the linker as the -rpath (list of comma-separated directories)"})
    public static final HostedOptionKey<String[]> LinkerRPath;
    @Option(help={"Directory of the image file to be generated"}, type=OptionType.User)
    public static final HostedOptionKey<String> Path;
    @APIOption.List(value={@APIOption(name="-ea", customHelp="enable assertions in the generated image"), @APIOption(name="-da", kind=APIOption.APIOptionKind.Negated, customHelp="disable assertions in the generated image")})
    @Option(help={"Enable or disable Java assert statements at run time"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> RuntimeAssertions;
    @Option(help={"Use a card remembered set heap for GC"})
    public static final HostedOptionKey<Boolean> UseCardRememberedSetHeap;
    @Option(help={"Print summary GC information after each collection"})
    public static final RuntimeOptionKey<Boolean> PrintGC;
    @Option(help={"Print more information about the heap before and after each collection"})
    public static final RuntimeOptionKey<Boolean> VerboseGC;
    @Option(help={"Verify the heap before and after each collection."})
    public static final HostedOptionKey<Boolean> VerifyHeap;
    @Option(help={"The minimum heap size at run-time, in bytes."}, type=OptionType.User)
    public static final RuntimeOptionKey<Long> MinHeapSize;
    @Option(help={"The maximum heap size at run-time, in bytes."}, type=OptionType.User)
    public static final RuntimeOptionKey<Long> MaxHeapSize;
    @Option(help={"The maximum size of the young generation at run-time, in bytes"}, type=OptionType.User)
    public static final RuntimeOptionKey<Long> MaxNewSize;
    @Option(help={"The size of each thread stack at run-time, in bytes."}, type=OptionType.User)
    public static final RuntimeOptionKey<Long> StackSize;
    @Option(help={"Maximum total size of NIO direct-buffer allocations"})
    public static final RuntimeOptionKey<Long> MaxDirectMemorySize;
    @Option(help={"Verify naming conventions during image construction."})
    public static final HostedOptionKey<Boolean> VerifyNamingConventions;
    @Option(help={"Enable support for threads and and thread-local variables (disable for single-threaded implementation)"})
    public static final HostedOptionKey<Boolean> MultiThreaded;
    @Option(help={"Use only a writable native image heap (requires ld.gold linker)"})
    public static final HostedOptionKey<Boolean> ForceNoROSectionRelocations;
    @Option(help={"Support multiple isolates."})
    public static final HostedOptionKey<Boolean> SpawnIsolates;
    @Option(help={"Trace VMOperation execution."})
    public static final HostedOptionKey<Boolean> TraceVMOperations;
    @Option(help={"Instrument code to trace and report class initialization."})
    public static final HostedOptionKey<Boolean> TraceClassInitialization;
    @Option(help={"Prefix that is added to the names of entry point methods."})
    public static final HostedOptionKey<String> EntryPointNamePrefix;
    @Option(help={"Prefix that is added to the names of API functions."})
    public static final HostedOptionKey<String> APIFunctionPrefix;
    @APIOption.List(value={@APIOption(name="enable-http", fixedValue={"http"}, customHelp="enable http support in the generated image"), @APIOption(name="enable-https", fixedValue={"https"}, customHelp="enable https support in the generated image"), @APIOption(name="enable-url-protocols")})
    @Option(help={"List of comma separated URL protocols to enable."})
    public static final HostedOptionKey<String[]> EnableURLProtocols;
    @APIOption(name="enable-all-security-services")
    @Option(help={"Add all security service classes to the generated image."})
    public static final HostedOptionKey<Boolean> EnableAllSecurityServices;
    @Option(help={"Enable Java Native Interface (JNI) support."})
    public static final HostedOptionKey<Boolean> JNI;
    @Option(help={"Report information about known JNI elements when lookup fails"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> JNIVerboseLookupErrors;
    @Option(help={"Export Invocation API symbols."}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> JNIExportSymbols;
    @Option(help={"Number of cache lines to load after the array allocation using prefetch instructions generated in JIT compiled code."})
    public static final HostedOptionKey<Integer> AllocatePrefetchLines;
    @Option(help={"Number of cache lines to load after the object address using prefetch instructions generated in JIT compiled code."})
    public static final HostedOptionKey<Integer> AllocateInstancePrefetchLines;
    @Option(help={"Generated code style for prefetch instructions: for 0 or less no prefetch instructions are generated and for 1 or more prefetch instructions are introduced after each allocation."})
    public static final HostedOptionKey<Integer> AllocatePrefetchStyle;
    @Option(help={"Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform."})
    public static final HostedOptionKey<Integer> AllocatePrefetchInstr;
    @Option(help={"The number of nanoseconds before and between which tearing down an isolate gives a warning message.  0 implies no warning."})
    public static final RuntimeOptionKey<Long> TearDownWarningNanos;
    @Option(help={"The number of nanoseconds before tearing down an isolate gives a failure message.  0 implies no message."})
    public static final RuntimeOptionKey<Long> TearDownFailureNanos;
    @Option(help={"Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point."})
    public static final HostedOptionKey<Integer> AllocatePrefetchDistance;
    @Option(help={"Sets the step size (in bytes) for sequential prefetch instructions."})
    public static final HostedOptionKey<Integer> AllocatePrefetchStepSize;
    @Option(help={"Define the maximum number of stores for which the loop that zeroes out objects is unrolled."})
    public static final HostedOptionKey<Integer> MaxUnrolledObjectZeroingStores;
    @Option(help={"Provide method names for stack traces."})
    public static final HostedOptionKey<Boolean> StackTrace;
    @Option(help={"Parse and consume standard options and system properties from the command line arguments when the VM is created."})
    public static final HostedOptionKey<Boolean> ParseRuntimeOptions;
    @Option(help={"Only use Java assert statements for classes that are matching the comma-separated list of package prefixes."})
    public static final HostedOptionKey<String[]> RuntimeAssertionsFilter;
    @Option(help={"Perform method inlining in the AOT compiled native image"})
    public static final HostedOptionKey<Boolean> AOTInline;
    @Option(help={"Perform trivial method inlining in the AOT compiled native image"})
    public static final HostedOptionKey<Boolean> AOTTrivialInline;
    @Option(help={"file:doc-files/NeverInlineHelp.txt"}, type=OptionType.Debug)
    public static final HostedOptionKey<String[]> NeverInline;
    @Option(help={"Maximum number of nodes in a method so that it is considered trivial."})
    public static final HostedOptionKey<Integer> MaxNodesInTrivialMethod;
    @Option(help={"Maximum number of invokes in a method so that it is considered trivial (for testing only)."})
    public static final HostedOptionKey<Integer> MaxInvokesInTrivialMethod;
    @Option(help={"Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes."})
    public static final HostedOptionKey<Integer> MaxNodesInTrivialLeafMethod;
    @Option(help={"Saves stack base pointer on the stack on method entry."})
    public static final HostedOptionKey<Boolean> PreserveFramePointer;
    @Option(help={"Use callee saved registers to reduce spilling for low-frequency calls to stubs (if callee saved registers are supported by the architecture)"})
    public static final HostedOptionKey<Boolean> UseCalleeSavedRegisters;
    @Option(help={"Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: InHeap, Allocated, InTypeCheck)."}, type=OptionType.Debug)
    public static final HostedOptionKey<String[]> ReportAnalysisForbiddenType;
    @Option(help={"Backend used by the compiler"}, type=OptionType.User)
    public static final HostedOptionKey<String> CompilerBackend;
    @Option(help={"Emit substitutions for UTF16 and latin1 compression"}, type=OptionType.Debug)
    public static final HostedOptionKey<Boolean> EmitStringEncodingSubstitutions;
    @Option(help={"Determines if VM operations should be executed in a dedicated thread."}, type=OptionType.Expert)
    public static final HostedOptionKey<Boolean> UseDedicatedVMOperationThread;
    @Option(help={"Use linker option to prevent unreferenced symbols in image."})
    public static final HostedOptionKey<Boolean> RemoveUnusedSymbols;
    @Option(help={"Use linker option to remove all local symbols from image."})
    public static final HostedOptionKey<Boolean> DeleteLocalSymbols;
    @Option(help={"Fold SecurityManager getter."}, stability=OptionStability.EXPERIMENTAL, type=OptionType.Expert)
    public static final HostedOptionKey<Boolean> FoldSecurityManagerGetter;
    @APIOption(name="native-compiler-path")
    @Option(help={"Provide custom path to C compiler used for query code compilation and linking."}, type=OptionType.User)
    public static final HostedOptionKey<String> CCompilerPath;
    @APIOption(name="native-compiler-options")
    @Option(help={"Provide custom C compiler option used for query code compilation."}, type=OptionType.User)
    public static final HostedOptionKey<String[]> CCompilerOption;
    @APIOption(name="native-image-info")
    @Option(help={"Show native-toolchain information and image-build settings"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> DumpTargetInfo;
    @Option(help={"Check if native-toolchain is known to work with native-image"}, type=OptionType.Expert)
    public static final HostedOptionKey<Boolean> CheckToolchain;
    @APIOption(name="install-exit-handlers")
    @Option(help={"Provide java.lang.Terminator exit handlers for executable images"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> InstallExitHandlers;
    @Option(help={"When set to true, the image generator verifies that the image heap does not contain a home directory as a substring"}, type=OptionType.User)
    public static final HostedOptionKey<Boolean> DetectUserDirectoriesInImageHeap;
    @Option(help={"The interval in minutes between watchdog checks (0 disables the watchdog)"}, type=OptionType.Expert)
    public static final HostedOptionKey<Integer> DeadlockWatchdogInterval;
    @Option(help={"Exit the image builder VM after printing call stacks"}, type=OptionType.Expert)
    public static final HostedOptionKey<Boolean> DeadlockWatchdogExitOnTimeout;
    @Option(help={"Populate reference queues in a separate thread rather than after a garbage collection."}, type=OptionType.Expert)
    public static final HostedOptionKey<Boolean> UseReferenceHandlerThread;
    @APIOption(name="-g", fixedValue={"2"}, customHelp="generate debugging information")
    @Option(help={"Insert debug info into the generated native image or library"})
    public static final HostedOptionKey<Integer> GenerateDebugInfo;
    @Option(help={"Search path for source files for Application or GraalVM classes (list of comma-separated directories or jar files)"})
    public static final HostedOptionKey<String[]> DebugInfoSourceSearchPath;
    @Option(help={"Directory under which to create source file cache for Application or GraalVM classes"})
    public static final HostedOptionKey<String> DebugInfoSourceCacheRoot;
    public static final String NO_SERVER = "--no-server";

    public static void setOptimizeValueUpdateHandler(ValueUpdateHandler updateHandler) {
        optimizeValueUpdateHandler = updateHandler;
    }

    public static void setDebugInfoValueUpdateHandler(ValueUpdateHandler updateHandler) {
        debugInfoValueUpdateHandler = updateHandler;
    }

    public static boolean getRuntimeAssertionsForClass(String name) {
        return RuntimeAssertions.getValue() != false && SubstrateOptions.getRuntimeAssertionsFilter().test(name);
    }

    @Fold
    static Predicate<String> getRuntimeAssertionsFilter() {
        return SubstrateOptions.makeFilter(RuntimeAssertionsFilter.getValue());
    }

    public static final long getTearDownWarningNanos() {
        return TearDownWarningNanos.getValue();
    }

    public static final long getTearDownFailureNanos() {
        return TearDownFailureNanos.getValue();
    }

    @Fold
    public static boolean useLLVMBackend() {
        return "llvm".equals(CompilerBackend.getValue());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Predicate<String> makeFilter(String[] definedFilters) {
        if (definedFilters != null) {
            List<String> wildCardList = OptionUtils.flatten(",", definedFilters);
            return javaName -> {
                for (String wildCard : wildCardList) {
                    if (!javaName.startsWith(wildCard)) continue;
                    return true;
                }
                return false;
            };
        }
        return javaName -> true;
    }

    @Fold
    public static int codeAlignment() {
        return (Integer)GraalOptions.LoopHeaderAlignment.getValue(HostedOptionValues.singleton());
    }

    private static void defaultDebugInfoValueUpdateHandler(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
        if (newValue > 0 && !Boolean.TRUE.equals(values.get((Object)GraalOptions.TrackNodeSourcePosition))) {
            GraalOptions.TrackNodeSourcePosition.update(values, (Object)true);
        }
    }

    public static Path getDebugInfoSourceCacheRoot() {
        try {
            Path sourceRoot = Paths.get(DebugInfoSourceCacheRoot.getValue(), new String[0]);
            return sourceRoot;
        }
        catch (InvalidPathException ipe) {
            throw UserError.abort("Invalid path provided for option DebugInfoSourceCacheRoot " + DebugInfoSourceCacheRoot.getValue(), new Object[0]);
        }
    }

    static {
        debugInfoValueUpdateHandler = SubstrateOptions::defaultDebugInfoValueUpdateHandler;
        PrintFlags = new OptionKey(null);
        PrintFlagsWithExtraHelp = new OptionKey(null);
        Optimize = new HostedOptionKey<Integer>(Integer.valueOf(2)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
                IncludeNodeSourcePositions.update(values, newValue < 1);
                AOTInline.update(values, newValue > 0);
                AOTTrivialInline.update(values, newValue > 0);
                if (optimizeValueUpdateHandler != null) {
                    optimizeValueUpdateHandler.onValueUpdate(values, oldValue, newValue);
                }
            }
        };
        IncludeNodeSourcePositions = new HostedOptionKey<Boolean>(false);
        CLibraryPath = new HostedOptionKey<Object>(null);
        LinkerRPath = new HostedOptionKey<Object>(null);
        Path = new HostedOptionKey<Object>(null);
        RuntimeAssertions = new HostedOptionKey<Boolean>(false);
        UseCardRememberedSetHeap = new HostedOptionKey<Boolean>(true);
        PrintGC = new RuntimeOptionKey<Boolean>(false);
        VerboseGC = new RuntimeOptionKey<Boolean>(false);
        VerifyHeap = new HostedOptionKey<Boolean>(false);
        MinHeapSize = new RuntimeOptionKey<Long>(Long.valueOf(0L)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
                if (!SubstrateUtil.HOSTED) {
                    XOptions.getXms().setValue(newValue);
                }
            }
        };
        MaxHeapSize = new RuntimeOptionKey<Long>(Long.valueOf(0L)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
                if (!SubstrateUtil.HOSTED) {
                    XOptions.getXmx().setValue(newValue);
                }
            }
        };
        MaxNewSize = new RuntimeOptionKey<Long>(Long.valueOf(0L)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
                if (!SubstrateUtil.HOSTED) {
                    XOptions.getXmn().setValue(newValue);
                }
            }
        };
        StackSize = new RuntimeOptionKey<Long>(Long.valueOf(0L)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
                if (!SubstrateUtil.HOSTED) {
                    XOptions.getXss().setValue(newValue);
                }
            }
        };
        MaxDirectMemorySize = new RuntimeOptionKey<Long>(0L);
        VerifyNamingConventions = new HostedOptionKey<Boolean>(false);
        MultiThreaded = new HostedOptionKey<Boolean>(true);
        ForceNoROSectionRelocations = new HostedOptionKey<Boolean>(false);
        SpawnIsolates = new HostedOptionKey<Boolean>(null){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this)) {
                    return !SubstrateOptions.useLLVMBackend();
                }
                return (Boolean)values.get((Object)this);
            }

            public Boolean getValue(OptionValues values) {
                assert (this.checkDescriptorExists());
                return this.getValueOrDefault(values.getMap());
            }
        };
        TraceVMOperations = new HostedOptionKey<Boolean>(false);
        TraceClassInitialization = new HostedOptionKey<Boolean>(false);
        EntryPointNamePrefix = new HostedOptionKey<String>("");
        APIFunctionPrefix = new HostedOptionKey<String>("graal_");
        EnableURLProtocols = new HostedOptionKey<String[]>(null){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String[] oldValue, String[] newValue) {
                for (String protocol : OptionUtils.flatten(",", newValue)) {
                    if (!protocol.equals("https")) continue;
                    EnableAllSecurityServices.update(values, true);
                }
            }
        };
        EnableAllSecurityServices = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    JNI.update(values, true);
                }
            }
        };
        JNI = new HostedOptionKey<Boolean>(true);
        JNIVerboseLookupErrors = new HostedOptionKey<Boolean>(false);
        JNIExportSymbols = new HostedOptionKey<Boolean>(true);
        AllocatePrefetchLines = new HostedOptionKey<Integer>(3);
        AllocateInstancePrefetchLines = new HostedOptionKey<Integer>(1);
        AllocatePrefetchStyle = new HostedOptionKey<Integer>(1);
        AllocatePrefetchInstr = new HostedOptionKey<Integer>(0);
        TearDownWarningNanos = new RuntimeOptionKey<Long>(0L);
        TearDownFailureNanos = new RuntimeOptionKey<Long>(0L);
        AllocatePrefetchDistance = new HostedOptionKey<Integer>(256);
        AllocatePrefetchStepSize = new HostedOptionKey<Integer>(16);
        MaxUnrolledObjectZeroingStores = new HostedOptionKey<Integer>(8);
        StackTrace = new HostedOptionKey<Boolean>(true);
        ParseRuntimeOptions = new HostedOptionKey<Boolean>(true);
        RuntimeAssertionsFilter = new HostedOptionKey<Object>(null);
        AOTInline = new HostedOptionKey<Boolean>(true);
        AOTTrivialInline = new HostedOptionKey<Boolean>(true);
        NeverInline = new HostedOptionKey<Object>(null);
        MaxNodesInTrivialMethod = new HostedOptionKey<Integer>(20);
        MaxInvokesInTrivialMethod = new HostedOptionKey<Integer>(1);
        MaxNodesInTrivialLeafMethod = new HostedOptionKey<Integer>(40);
        PreserveFramePointer = new HostedOptionKey<Boolean>(false);
        UseCalleeSavedRegisters = new HostedOptionKey<Boolean>(true);
        ReportAnalysisForbiddenType = new HostedOptionKey<String[]>(new String[0]);
        CompilerBackend = new HostedOptionKey<String>("lir"){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                if ("llvm".equals(newValue)) {
                    if (JavaVersionUtil.JAVA_SPEC > 8) {
                        EmitStringEncodingSubstitutions.update(values, false);
                    }
                    RemoveUnusedSymbols.update(values, false);
                    SpectrePHTMitigations.Options.SpectrePHTBarriers.update(values, (Object)SpectrePHTMitigations.None);
                }
            }
        };
        EmitStringEncodingSubstitutions = new HostedOptionKey<Boolean>(true);
        UseDedicatedVMOperationThread = new HostedOptionKey<Boolean>(false);
        RemoveUnusedSymbols = new HostedOptionKey<Boolean>(false);
        DeleteLocalSymbols = new HostedOptionKey<Boolean>(true);
        FoldSecurityManagerGetter = new HostedOptionKey<Boolean>(true);
        CCompilerPath = new HostedOptionKey<Object>(null);
        CCompilerOption = new HostedOptionKey<String[]>(new String[0]);
        DumpTargetInfo = new HostedOptionKey<Boolean>(false);
        CheckToolchain = new HostedOptionKey<Boolean>(true);
        InstallExitHandlers = new HostedOptionKey<Boolean>(false);
        DetectUserDirectoriesInImageHeap = new HostedOptionKey<Boolean>(false);
        DeadlockWatchdogInterval = new HostedOptionKey<Integer>(10);
        DeadlockWatchdogExitOnTimeout = new HostedOptionKey<Boolean>(true);
        UseReferenceHandlerThread = new HostedOptionKey<Boolean>(false);
        GenerateDebugInfo = new HostedOptionKey<Integer>(Integer.valueOf(0)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
                debugInfoValueUpdateHandler.onValueUpdate(values, oldValue, newValue);
            }
        };
        DebugInfoSourceSearchPath = new HostedOptionKey<String[]>(null){};
        DebugInfoSourceCacheRoot = new HostedOptionKey<String>("sources");
    }

    public static interface ValueUpdateHandler {
        public void onValueUpdate(EconomicMap<OptionKey<?>, Object> var1, Integer var2, Integer var3);
    }
}

