/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.CardTable;
import com.oracle.svm.core.genscavenge.FirstObjectTable;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.replacements.nodes.AssertionNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class AlignedHeapChunk {
    private AlignedHeapChunk() {
    }

    static Pointer getCardTableStart(AlignedHeader that) {
        return HeapChunk.asPointer(that).add(AlignedHeapChunk.getCardTableStartOffset());
    }

    static Pointer getCardTableLimit(AlignedHeader that) {
        return HeapChunk.asPointer(that).add(AlignedHeapChunk.getCardTableLimitOffset());
    }

    static Pointer getFirstObjectTableStart(AlignedHeader that) {
        return HeapChunk.asPointer(that).add(AlignedHeapChunk.getFirstObjectTableStartOffset());
    }

    static Pointer getFirstObjectTableLimit(AlignedHeader that) {
        return HeapChunk.asPointer(that).add(AlignedHeapChunk.getFirstObjectTableLimitOffset());
    }

    static Pointer getObjectsStart(AlignedHeader that) {
        return HeapChunk.asPointer(that).add(AlignedHeapChunk.getObjectsStartOffset());
    }

    static Pointer allocateMemory(AlignedHeader that, UnsignedWord size) {
        Pointer result = (Pointer)WordFactory.nullPointer();
        UnsignedWord available = HeapChunk.availableObjectMemory(that);
        if (size.belowOrEqual(available)) {
            result = HeapChunk.getTopPointer(that);
            Pointer newTop = result.add(size);
            HeapChunk.setTopPointerCarefully(that, newTop);
        }
        return result;
    }

    static UnsignedWord getCommittedObjectMemory(AlignedHeader that) {
        return HeapChunk.getEndOffset(that).subtract(AlignedHeapChunk.getObjectsStartOffset());
    }

    static AlignedHeader getEnclosingChunk(Object obj) {
        Word ptr = Word.objectToUntrackedPointer((Object)obj);
        return AlignedHeapChunk.getEnclosingChunkFromObjectPointer((Pointer)ptr);
    }

    static AlignedHeader getEnclosingChunkFromObjectPointer(Pointer ptr) {
        return (AlignedHeader)PointerUtils.roundDown((PointerBase)ptr, HeapPolicy.getAlignedHeapChunkAlignment());
    }

    static void cleanRememberedSet(AlignedHeader that) {
        Pointer cardTableStart = AlignedHeapChunk.getCardTableStart(that);
        UnsignedWord indexLimit = AlignedHeapChunk.getCardTableIndexLimitForCurrentTop(that);
        CardTable.cleanTableToIndex(cardTableStart, indexLimit);
    }

    private static UnsignedWord getCardTableIndexLimitForCurrentTop(AlignedHeader that) {
        UnsignedWord memorySize = HeapChunk.getTopOffset(that).subtract(AlignedHeapChunk.getObjectsStartOffset());
        return CardTable.indexLimitForMemorySize(memorySize);
    }

    @AlwaysInline(value="GC performance")
    static void setUpRememberedSetForObject(AlignedHeader that, Object obj) {
        assert (VMOperation.isGCInProgress()) : "Should only be called from the collector.";
        assert (!HeapChunk.getSpace(that).isYoungSpace());
        Pointer fotStart = AlignedHeapChunk.getFirstObjectTableStart(that);
        Pointer memoryStart = AlignedHeapChunk.getObjectsStart(that);
        Word objStart = Word.objectToUntrackedPointer((Object)obj);
        Pointer objEnd = LayoutEncoding.getObjectEnd(obj);
        FirstObjectTable.setTableForObject(fotStart, memoryStart, (Pointer)objStart, objEnd);
        ObjectHeaderImpl.setRememberedSetBit(obj);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true, reason="Whitelisted because other ObjectVisitors are allowed to allocate.")
    static void constructRememberedSet(AlignedHeader that) {
        GCImpl.RememberedSetConstructor constructor = GCImpl.getGCImpl().getRememberedSetConstructor();
        constructor.initialize(that);
        HeapChunk.walkObjectsFromInline(that, AlignedHeapChunk.getObjectsStart(that), constructor);
        constructor.reset();
    }

    public static void dirtyCardForObject(Object object, boolean verifyOnly) {
        Word objectPointer = Word.objectToUntrackedPointer((Object)object);
        AlignedHeader chunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer((Pointer)objectPointer);
        Pointer cardTableStart = AlignedHeapChunk.getCardTableStart(chunk);
        UnsignedWord index = AlignedHeapChunk.getObjectIndex(chunk, (Pointer)objectPointer);
        if (verifyOnly) {
            AssertionNode.assertion((boolean)false, (boolean)CardTable.isDirtyEntryAtIndexUnchecked(cardTableStart, index), (String)"card must be dirty", (Object)"", (Object)"", (long)0L, (long)0L);
        } else {
            CardTable.dirtyEntryAtIndex(cardTableStart, index);
        }
    }

    private static UnsignedWord getObjectOffset(AlignedHeader that, Pointer objectPointer) {
        Pointer objectsStart = AlignedHeapChunk.getObjectsStart(that);
        return objectPointer.subtract((UnsignedWord)objectsStart);
    }

    private static UnsignedWord getObjectIndex(AlignedHeader that, Pointer objectPointer) {
        UnsignedWord offset = AlignedHeapChunk.getObjectOffset(that, objectPointer);
        return CardTable.memoryOffsetToIndex(offset);
    }

    static boolean walkObjects(AlignedHeader that, ObjectVisitor visitor) {
        return HeapChunk.walkObjectsFrom(that, AlignedHeapChunk.getObjectsStart(that), visitor);
    }

    @AlwaysInline(value="GC performance")
    static boolean walkObjectsInline(AlignedHeader that, ObjectVisitor visitor) {
        return HeapChunk.walkObjectsFromInline(that, AlignedHeapChunk.getObjectsStart(that), visitor);
    }

    @Fold
    static UnsignedWord getHeaderSize() {
        return WordFactory.unsigned((int)SizeOf.get(AlignedHeader.class));
    }

    @Fold
    static UnsignedWord getCardTableStartOffset() {
        UnsignedWord headerSize = AlignedHeapChunk.getHeaderSize();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(headerSize, alignment);
    }

    @Fold
    static UnsignedWord getCardTableSize() {
        UnsignedWord headerSize = AlignedHeapChunk.getHeaderSize();
        UnsignedWord available = HeapPolicy.getAlignedHeapChunkSize().subtract(headerSize);
        UnsignedWord requiredSize = CardTable.tableSizeForMemorySize(available);
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(requiredSize, alignment);
    }

    @Fold
    static UnsignedWord getCardTableLimitOffset() {
        UnsignedWord tableStart = AlignedHeapChunk.getCardTableStartOffset();
        UnsignedWord tableSize = AlignedHeapChunk.getCardTableSize();
        UnsignedWord tableLimit = tableStart.add(tableSize);
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(tableLimit, alignment);
    }

    @Fold
    static UnsignedWord getFirstObjectTableStartOffset() {
        UnsignedWord cardTableLimit = AlignedHeapChunk.getCardTableLimitOffset();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(cardTableLimit, alignment);
    }

    @Fold
    static UnsignedWord getFirstObjectTableSize() {
        return AlignedHeapChunk.getCardTableSize();
    }

    @Fold
    static UnsignedWord getFirstObjectTableLimitOffset() {
        UnsignedWord fotStart = AlignedHeapChunk.getFirstObjectTableStartOffset();
        UnsignedWord fotSize = AlignedHeapChunk.getFirstObjectTableSize();
        UnsignedWord fotLimit = fotStart.add(fotSize);
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(fotLimit, alignment);
    }

    @Fold
    static UnsignedWord getObjectsStartOffset() {
        UnsignedWord fotLimit = AlignedHeapChunk.getFirstObjectTableLimitOffset();
        UnsignedWord alignment = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getAlignment());
        return UnsignedUtils.roundUp(fotLimit, alignment);
    }

    static boolean verify(AlignedHeader that) {
        Log verifyLog;
        Log trace = Log.noopLog().string("[AlignedHeapChunk.verify:");
        trace.string("  that: ").hex((WordBase)that);
        boolean result = true;
        if (result && !HeapChunk.verifyObjects(that, AlignedHeapChunk.getObjectsStart(that))) {
            result = false;
            verifyLog = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[AlignedHeapChunk.verify:");
            verifyLog.string("  identifier: ").hex((WordBase)that).string("  superclass fails to verify]").newline();
        }
        if (result && !AlignedHeapChunk.verifyObjectHeaders(that)) {
            result = false;
            verifyLog = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[AlignedHeapChunk.verify:");
            verifyLog.string("  identifier: ").hex((WordBase)that).string("  object headers fail to verify.]").newline();
        }
        if (result && !AlignedHeapChunk.verifyRememberedSet(that)) {
            result = false;
            verifyLog = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[AlignedHeapChunk.verify:");
            verifyLog.string("  identifier: ").hex((WordBase)that).string("  remembered set fails to verify]").newline();
        }
        trace.string("  returns: ").bool(result);
        trace.string("]").newline();
        return result;
    }

    private static boolean verifyObjectHeaders(AlignedHeader that) {
        Log trace = Log.noopLog().string("[AlignedHeapChunk.verifyObjectHeaders: ").string("  that: ").hex((WordBase)that);
        Pointer current = AlignedHeapChunk.getObjectsStart(that);
        while (current.belowThan((UnsignedWord)HeapChunk.getTopPointer(that))) {
            trace.newline().string("  current: ").hex((WordBase)current);
            UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(current);
            if (!ObjectHeaderImpl.isAlignedHeader(current, header)) {
                trace.string("  does not have an aligned header: ").hex((WordBase)header).string("  returns: false").string("]").newline();
                return false;
            }
            current = LayoutEncoding.getObjectEnd(current.toObject());
        }
        trace.string("  returns: true]").newline();
        return true;
    }

    private static boolean verifyRememberedSet(AlignedHeader that) {
        Log trace = Log.noopLog().string("[AlignedHeapChunk.verifyRememberedSet:").string("  that: ").hex((WordBase)that);
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        if (HeapChunk.getSpace(that) == oldGen.getFromSpace()) {
            if (!CardTable.verify(AlignedHeapChunk.getCardTableStart(that), AlignedHeapChunk.getFirstObjectTableStart(that), AlignedHeapChunk.getObjectsStart(that), HeapChunk.getTopPointer(that))) {
                Log verifyLog = heap.getHeapVerifier().getWitnessLog().string("[AlignedHeapChunk.verifyRememberedSet:");
                verifyLog.string("  card table fails to verify").string("]").newline();
                return false;
            }
            if (!FirstObjectTable.verify(AlignedHeapChunk.getFirstObjectTableStart(that), AlignedHeapChunk.getObjectsStart(that), HeapChunk.getTopPointer(that))) {
                Log verifyLog = heap.getHeapVerifier().getWitnessLog().string("[AlignedHeapChunk.verifyRememberedSet:");
                verifyLog.string("  first object table fails to verify").string("]").newline();
                return false;
            }
        }
        trace.string("]").newline();
        return true;
    }

    static boolean walkDirtyObjects(AlignedHeader that, ObjectVisitor visitor, boolean clean) {
        Log trace = Log.noopLog().string("[AlignedHeapChunk.walkDirtyObjects:");
        trace.string("  that: ").hex((WordBase)that).string("  clean: ").bool(clean);
        Pointer cardTableStart = AlignedHeapChunk.getCardTableStart(that);
        Pointer fotStart = AlignedHeapChunk.getFirstObjectTableStart(that);
        Pointer objectsStart = AlignedHeapChunk.getObjectsStart(that);
        Pointer objectsLimit = HeapChunk.getTopPointer(that);
        Pointer memorySize = objectsLimit.subtract((UnsignedWord)objectsStart);
        UnsignedWord indexLimit = CardTable.indexLimitForMemorySize((UnsignedWord)memorySize);
        trace.string("  objectsStart: ").hex((WordBase)objectsStart).string("  objectsLimit: ").hex((WordBase)objectsLimit).string("  indexLimit: ").unsigned((WordBase)indexLimit);
        UnsignedWord index = (UnsignedWord)WordFactory.zero();
        while (index.belowThan(indexLimit)) {
            trace.newline().string("  ").string("  index: ").unsigned((WordBase)index);
            if (CardTable.isDirtyEntryAtIndex(cardTableStart, index)) {
                Pointer impreciseStart;
                if (clean) {
                    CardTable.cleanEntryAtIndex(cardTableStart, index);
                }
                Pointer cardLimit = CardTable.indexToMemoryPointer(objectsStart, index.add(1));
                Pointer crossingOntoPointer = FirstObjectTable.getPreciseFirstObjectPointer(fotStart, objectsStart, objectsLimit, index);
                Object crossingOntoObject = crossingOntoPointer.toObject();
                if (trace.isEnabled()) {
                    Pointer cardStart = CardTable.indexToMemoryPointer(objectsStart, index);
                    trace.string("    ").string("  cardStart: ").hex((WordBase)cardStart);
                    trace.string("  cardLimit: ").hex((WordBase)cardLimit);
                    trace.string("  crossingOntoObject: ").object(crossingOntoObject);
                    trace.string("  end: ").hex((WordBase)LayoutEncoding.getObjectEnd(crossingOntoObject));
                    if (LayoutEncoding.isArray(crossingOntoObject)) {
                        trace.string("  array length: ").signed(KnownIntrinsics.readArrayLength(crossingOntoObject));
                    }
                }
                trace.newline();
                Pointer ptr = impreciseStart = FirstObjectTable.getImpreciseFirstObjectPointer(fotStart, objectsStart, objectsLimit, index);
                Pointer walkLimit = PointerUtils.min(cardLimit, objectsLimit);
                trace.string("    ");
                trace.string("  impreciseStart: ").hex((WordBase)impreciseStart);
                trace.string("  walkLimit: ").hex((WordBase)walkLimit);
                while (ptr.belowThan((UnsignedWord)walkLimit)) {
                    trace.newline().string("      ");
                    trace.string("  ptr: ").hex((WordBase)ptr);
                    Object obj = ptr.toObject();
                    Pointer objEnd = LayoutEncoding.getObjectEnd(obj);
                    trace.string("  obj: ").object(obj);
                    trace.string("  objEnd: ").hex((WordBase)objEnd);
                    if (!visitor.visitObjectInline(obj)) {
                        Log failureLog = Log.log().string("[AlignedHeapChunk.walkDirtyObjects:");
                        failureLog.string("  visitor.visitObject fails").string("  obj: ").object(obj).string("]").newline();
                        return false;
                    }
                    ptr = objEnd;
                }
            }
            index = index.add(1);
        }
        trace.string("]").newline();
        return true;
    }

    static boolean verifyOnlyCleanCards(AlignedHeader that) {
        Log trace = Log.noopLog().string("[AlignedHeapChunk.verifyOnlyCleanCards:");
        trace.string("  that: ").hex((WordBase)that);
        boolean result = true;
        Pointer cardTableStart = AlignedHeapChunk.getCardTableStart(that);
        UnsignedWord indexLimit = AlignedHeapChunk.getCardTableIndexLimitForCurrentTop(that);
        UnsignedWord index = (UnsignedWord)WordFactory.zero();
        while (index.belowThan(indexLimit)) {
            if (CardTable.isDirtyEntryAtIndex(cardTableStart, index)) {
                result = false;
                Log witness = Log.log().string("[AlignedHeapChunk.verifyOnlyCleanCards:");
                witness.string("  that: ").hex((WordBase)that).string("  dirty card at index: ").unsigned((WordBase)index).string("]").newline();
            }
            index = index.add(1);
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    @Fold
    static MemoryWalker.HeapChunkAccess<AlignedHeader> getMemoryWalkerAccess() {
        return (MemoryWalker.HeapChunkAccess)ImageSingletons.lookup(MemoryWalkerAccessImpl.class);
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static UnsignedWord getFirstObjectTableStartOffset() {
            return AlignedHeapChunk.getFirstObjectTableStartOffset();
        }

        public static UnsignedWord getCardTableStartOffset() {
            return AlignedHeapChunk.getCardTableStartOffset();
        }

        public static UnsignedWord getObjectsStartOffset() {
            return AlignedHeapChunk.getObjectsStartOffset();
        }
    }

    static final class MemoryWalkerAccessImpl
    extends HeapChunk.MemoryWalkerAccessImpl<AlignedHeader> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        MemoryWalkerAccessImpl() {
        }

        @Override
        public boolean isAligned(AlignedHeader heapChunk) {
            return true;
        }

        @Override
        public UnsignedWord getAllocationStart(AlignedHeader heapChunk) {
            return AlignedHeapChunk.getObjectsStart(heapChunk);
        }
    }

    @RawStructure
    public static interface AlignedHeader
    extends HeapChunk.Header<AlignedHeader> {
    }
}

