/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapPolicyOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionType;

public class HeapPolicyOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "AlignedHeapChunkSize": {
                return OptionDescriptor.create((String)"AlignedHeapChunkSize", (OptionType)OptionType.Debug, Long.class, (String)"The size of an aligned chunk.", HeapPolicyOptions.class, (String)"AlignedHeapChunkSize", HeapPolicyOptions.AlignedHeapChunkSize, (boolean)false);
            }
            case "AllocationBeforePhysicalMemorySize": {
                return OptionDescriptor.create((String)"AllocationBeforePhysicalMemorySize", (OptionType)OptionType.Debug, Long.class, (String)"Bytes that can be allocated before (re-)querying the physical memory size", HeapPolicyOptions.class, (String)"AllocationBeforePhysicalMemorySize", HeapPolicyOptions.AllocationBeforePhysicalMemorySize, (boolean)false);
            }
            case "LargeArrayThreshold": {
                return OptionDescriptor.create((String)"LargeArrayThreshold", (OptionType)OptionType.Debug, Long.class, (String)"The size at or above which an array will be allocated in its own unaligned chunk.  0 implies (AlignedHeapChunkSize / 8).", HeapPolicyOptions.class, (String)"LargeArrayThreshold", HeapPolicyOptions.LargeArrayThreshold, (boolean)false);
            }
            case "MaxSurvivorSpaces": {
                return OptionDescriptor.create((String)"MaxSurvivorSpaces", (OptionType)OptionType.Debug, Integer.class, (String)"Maximum number of survivor spaces.", HeapPolicyOptions.class, (String)"MaxSurvivorSpaces", HeapPolicyOptions.MaxSurvivorSpaces, (boolean)false);
            }
            case "MaximumHeapSizePercent": {
                return OptionDescriptor.create((String)"MaximumHeapSizePercent", (OptionType)OptionType.Debug, Integer.class, (String)"The maximum heap size as percent of physical memory", HeapPolicyOptions.class, (String)"MaximumHeapSizePercent", HeapPolicyOptions.MaximumHeapSizePercent, (boolean)false);
            }
            case "MaximumYoungGenerationSizePercent": {
                return OptionDescriptor.create((String)"MaximumYoungGenerationSizePercent", (OptionType)OptionType.Debug, Integer.class, (String)"The maximum size of the young generation as a percentage of the maximum heap size", HeapPolicyOptions.class, (String)"MaximumYoungGenerationSizePercent", HeapPolicyOptions.MaximumYoungGenerationSizePercent, (boolean)false);
            }
            case "TraceHeapChunks": {
                return OptionDescriptor.create((String)"TraceHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace heap chunks during collections, if +VerboseGC and +PrintHeapShape.", HeapPolicyOptions.class, (String)"TraceHeapChunks", HeapPolicyOptions.TraceHeapChunks, (boolean)false);
            }
            case "UserRequestedGCPolicy": {
                return OptionDescriptor.create((String)"UserRequestedGCPolicy", (OptionType)OptionType.Debug, String.class, (String)"Policy used when user code requests garbage collection.", HeapPolicyOptions.class, (String)"UserRequestedGCPolicy", HeapPolicyOptions.UserRequestedGCPolicy, (boolean)false);
            }
            case "UserRequestedGCThreshold": {
                return OptionDescriptor.create((String)"UserRequestedGCThreshold", (OptionType)OptionType.Debug, Long.class, (String)"With the skeptical policy for user-requested collections, the threshold for the young generation size to cause a collection.", HeapPolicyOptions.class, (String)"UserRequestedGCThreshold", HeapPolicyOptions.UserRequestedGCThreshold, (boolean)false);
            }
            case "ZapChunks": {
                return OptionDescriptor.create((String)"ZapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Fill unused memory chunks with a sentinel value.", HeapPolicyOptions.class, (String)"ZapChunks", HeapPolicyOptions.ZapChunks, (boolean)false);
            }
            case "ZapConsumedHeapChunks": {
                return OptionDescriptor.create((String)"ZapConsumedHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"After use, Fill memory chunks with a sentinel value.", HeapPolicyOptions.class, (String)"ZapConsumedHeapChunks", HeapPolicyOptions.ZapConsumedHeapChunks, (boolean)false);
            }
            case "ZapProducedHeapChunks": {
                return OptionDescriptor.create((String)"ZapProducedHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Before use, fill memory chunks with a sentinel value.", HeapPolicyOptions.class, (String)"ZapProducedHeapChunks", HeapPolicyOptions.ZapProducedHeapChunks, (boolean)false);
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 12;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("AlignedHeapChunkSize");
                    }
                    case 1: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("AllocationBeforePhysicalMemorySize");
                    }
                    case 2: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("LargeArrayThreshold");
                    }
                    case 3: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("MaxSurvivorSpaces");
                    }
                    case 4: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("MaximumHeapSizePercent");
                    }
                    case 5: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("MaximumYoungGenerationSizePercent");
                    }
                    case 6: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("TraceHeapChunks");
                    }
                    case 7: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("UserRequestedGCPolicy");
                    }
                    case 8: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("UserRequestedGCThreshold");
                    }
                    case 9: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("ZapChunks");
                    }
                    case 10: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("ZapConsumedHeapChunks");
                    }
                    case 11: {
                        return HeapPolicyOptions_OptionDescriptors.this.get("ZapProducedHeapChunks");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

