/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.aarch64.AdrpAddMacroInstructionNativeImagePatcher;
import com.oracle.svm.core.graal.aarch64.AdrpLdrMacroInstructionNativeImagePatcher;
import com.oracle.svm.core.graal.aarch64.MovSequenceNativeImagePatcher;
import com.oracle.svm.core.graal.aarch64.SingleInstructionNativeImagePatcher;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import java.util.function.Consumer;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.AARCH64.class})
public class AArch64NativeImagePatcher
implements Feature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(PatchConsumerFactory.NativePatchConsumerFactory.class, (Object)new PatchConsumerFactory.NativePatchConsumerFactory(){

            @Override
            public Consumer<Assembler.CodeAnnotation> newConsumer(final CompilationResult compilationResult) {
                return new Consumer<Assembler.CodeAnnotation>(){

                    @Override
                    public void accept(Assembler.CodeAnnotation annotation) {
                        if (annotation instanceof AArch64Assembler.SingleInstructionAnnotation) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new SingleInstructionNativeImagePatcher(annotation.instructionPosition, (AArch64Assembler.SingleInstructionAnnotation)annotation));
                        } else if (annotation instanceof AArch64MacroAssembler.MovSequenceAnnotation) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new MovSequenceNativeImagePatcher(annotation.instructionPosition, (AArch64MacroAssembler.MovSequenceAnnotation)annotation));
                        } else if (annotation instanceof AArch64MacroAssembler.AdrpLdrMacroInstruction) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new AdrpLdrMacroInstructionNativeImagePatcher((AArch64MacroAssembler.AdrpLdrMacroInstruction)annotation));
                        } else if (annotation instanceof AArch64MacroAssembler.AdrpAddMacroInstruction) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new AdrpAddMacroInstructionNativeImagePatcher((AArch64MacroAssembler.AdrpAddMacroInstruction)annotation));
                        }
                    }
                };
            }
        });
    }
}

