/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64SafepointCheckOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64SafepointCheckOp> TYPE = LIRInstructionClass.create(AArch64SafepointCheckOp.class);

    protected AArch64SafepointCheckOp() {
        super(TYPE);
    }

    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        assert (SubstrateOptions.MultiThreaded.getValue().booleanValue());
        SubstrateRegisterConfig threadRegister = (SubstrateRegisterConfig)crb.codeCache.getRegisterConfig();
        AArch64Address safepointAddress = AArch64Address.createUnscaledImmediateAddress((Register)threadRegister.getThreadRegister(), (int)Math.toIntExact(Safepoint.getThreadLocalSafepointRequestedOffset()));
        int safepointSize = AArch64Kind.QWORD.getSizeInBytes() * 8;
        try (AArch64MacroAssembler.ScratchRegister scratchRegister = masm.getScratchRegister();){
            Register scratch = scratchRegister.getRegister();
            masm.ldr(safepointSize, scratch, safepointAddress);
            masm.subs(safepointSize, scratch, scratch, 1);
            if (ThreadingSupportImpl.isRecurringCallbackSupported()) {
                masm.str(safepointSize, scratch, safepointAddress);
            }
        }
    }

    public AArch64Assembler.ConditionFlag getConditionFlag() {
        return AArch64Assembler.ConditionFlag.LE;
    }
}

