/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyLookup;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

public class SubstrateForeignCallsProvider
implements ArrayCopyForeignCalls {
    private final Map<ForeignCallSignature, SubstrateForeignCallLinkage> foreignCalls = new HashMap<ForeignCallSignature, SubstrateForeignCallLinkage>();
    protected ArrayCopyLookup arrayCopyLookup;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateForeignCallsProvider() {
    }

    public Map<ForeignCallSignature, SubstrateForeignCallLinkage> getForeignCalls() {
        return this.foreignCalls;
    }

    public void register(Providers providers, SnippetRuntime.SubstrateForeignCallDescriptor ... descriptors) {
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : descriptors) {
            SubstrateForeignCallLinkage linkage = new SubstrateForeignCallLinkage(providers, descriptor);
            this.foreignCalls.put(descriptor.getSignature(), linkage);
        }
    }

    public SubstrateForeignCallLinkage lookupForeignCall(ForeignCallDescriptor descriptor) {
        SubstrateForeignCallLinkage callTarget = this.foreignCalls.get(descriptor.getSignature());
        if (callTarget == null) {
            throw VMError.shouldNotReachHere("missing implementation for runtime call: " + descriptor);
        }
        return callTarget;
    }

    public ForeignCallDescriptor getDescriptor(ForeignCallSignature signature) {
        SubstrateForeignCallLinkage linkage = this.foreignCalls.get(signature);
        return linkage.getDescriptor();
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return LIRKind.fromJavaKind((Architecture)((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch, (JavaKind)javaKind);
    }

    public void registerArrayCopyForeignCallsDelegate(ArrayCopyLookup arraycopyForeignCalls) {
        this.arrayCopyLookup = arraycopyForeignCalls;
    }

    public ForeignCallDescriptor lookupCheckcastArraycopyDescriptor(boolean uninit) {
        if (this.arrayCopyLookup != null) {
            return this.arrayCopyLookup.lookupCheckcastArraycopyDescriptor(uninit);
        }
        throw VMError.unsupportedFeature("Fast checkcast ArrayCopy not supported yet.");
    }

    public ForeignCallDescriptor lookupArraycopyDescriptor(JavaKind kind, boolean aligned, boolean disjoint, boolean uninit, LocationIdentity killedLocation) {
        if (this.arrayCopyLookup != null) {
            return this.arrayCopyLookup.lookupArraycopyDescriptor(kind, aligned, disjoint, uninit, killedLocation);
        }
        throw VMError.unsupportedFeature("Fast ArrayCopy not supported yet.");
    }
}

