/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.graal.code.SubstrateLIRGenerator;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.debug.ControlFlowAnchored;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class VerificationMarkerNode
extends FixedWithNextNode
implements LIRLowerable,
ControlFlowAnchored {
    public static final NodeClass<VerificationMarkerNode> TYPE = NodeClass.create(VerificationMarkerNode.class);
    private final Object marker;

    public VerificationMarkerNode(Object marker) {
        super(TYPE, StampFactory.forVoid());
        this.marker = marker;
    }

    protected void afterClone(Node other) {
        throw VMError.shouldNotReachHere("Marker must be unique, therefore the node cannot be cloned");
    }

    public void generate(NodeLIRBuilderTool generator) {
        SubstrateLIRGenerator sgenerator = (SubstrateLIRGenerator)generator.getLIRGeneratorTool();
        sgenerator.emitVerificationMarker(this.marker);
    }
}

