/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.meta.SharedMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;

public class MethodSafepointInsertionPhase
extends Phase {
    public boolean checkContract() {
        return false;
    }

    protected void run(StructuredGraph graph) {
        if (graph.method().getAnnotation(Uninterruptible.class) != null) {
            return;
        }
        if (graph.method().getAnnotation(CFunction.class) != null || graph.method().getAnnotation(InvokeCFunctionPointer.class) != null) {
            return;
        }
        if (((SharedMethod)graph.method()).isEntryPoint()) {
            return;
        }
        for (ReturnNode returnNode : graph.getNodes(ReturnNode.TYPE)) {
            SafepointNode safepointNode = (SafepointNode)graph.add((Node)new SafepointNode());
            graph.addBeforeFixed((FixedNode)returnNode, (FixedWithNextNode)safepointNode);
        }
    }
}

