/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.nodes.DeadEndNode;
import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;

public abstract class NonSnippetLowerings {
    private final RuntimeConfiguration runtimeConfig;
    private final Predicate<ResolvedJavaMethod> mustNotAllocatePredicate;
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> getCachedExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> createExceptionDescriptors;
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> throwCachedExceptionDescriptors;
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> throwNewExceptionDescriptors;

    protected NonSnippetLowerings(RuntimeConfiguration runtimeConfig, Predicate<ResolvedJavaMethod> mustNotAllocatePredicate, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        this.runtimeConfig = runtimeConfig;
        this.mustNotAllocatePredicate = mustNotAllocatePredicate;
        lowerings.put(BytecodeExceptionNode.class, new BytecodeExceptionLowering());
        lowerings.put(ThrowBytecodeExceptionNode.class, new ThrowBytecodeExceptionLowering());
        lowerings.put(GetClassNode.class, new GetClassLowering());
        lowerings.put(InvokeNode.class, new InvokeLowering());
        lowerings.put(InvokeWithExceptionNode.class, new InvokeLowering());
    }

    static {
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.GET_CACHED_NULL_POINTER_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.GET_CACHED_OUT_OF_BOUNDS_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.GET_CACHED_CLASS_CAST_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.GET_CACHED_ARRAY_STORE_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION, ImplicitExceptions.GET_CACHED_ILLEGAL_ARGUMENT_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.GET_CACHED_ARITHMETIC_EXCEPTION);
        createExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.CREATE_NULL_POINTER_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.CREATE_OUT_OF_BOUNDS_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.CREATE_CLASS_CAST_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.CREATE_ARRAY_STORE_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION, ImplicitExceptions.CREATE_ILLEGAL_ARGUMENT_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.CREATE_DIVISION_BY_ZERO_EXCEPTION);
        throwCachedExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.THROW_CACHED_NULL_POINTER_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.THROW_CACHED_CLASS_CAST_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.THROW_CACHED_ARRAY_STORE_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION, ImplicitExceptions.THROW_CACHED_ILLEGAL_ARGUMENT_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.THROW_CACHED_ARITHMETIC_EXCEPTION);
        throwNewExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.THROW_NEW_NULL_POINTER_EXCEPTION);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.THROW_NEW_OUT_OF_BOUNDS_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.THROW_NEW_CLASS_CAST_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.THROW_NEW_ARRAY_STORE_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION, ImplicitExceptions.THROW_NEW_ILLEGAL_ARGUMENT_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.THROW_NEW_DIVISION_BY_ZERO_EXCEPTION);
    }

    private class InvokeLowering
    implements NodeLoweringProvider<FixedNode> {
        private InvokeLowering() {
        }

        @Override
        public void lower(FixedNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            Invoke invoke = (Invoke)node;
            if (invoke.callTarget() instanceof MethodCallTargetNode) {
                CallTargetNode loweredCallTarget;
                MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
                NodeInputList parameters = callTarget.arguments();
                ValueNode receiver = parameters.size() <= 0 ? null : (ValueNode)parameters.get(0);
                FixedGuardNode nullCheck = null;
                if (!callTarget.isStatic() && receiver.getStackKind() == JavaKind.Object && !StampTool.isPointerNonNull((ValueNode)receiver)) {
                    LogicNode isNull = (LogicNode)graph.unique((Node)IsNullNode.create((ValueNode)receiver));
                    nullCheck = (FixedGuardNode)graph.add((Node)new FixedGuardNode(isNull, DeoptimizationReason.NullCheckException, DeoptimizationAction.None, true));
                    graph.addBeforeFixed(node, (FixedWithNextNode)nullCheck);
                }
                SharedMethod method = (SharedMethod)callTarget.targetMethod();
                JavaType[] signature = method.getSignature().toParameterTypes((JavaType)(callTarget.isStatic() ? null : method.getDeclaringClass()));
                SubstrateCallingConventionType callType = SubstrateCallingConventionType.JavaCall;
                CallTargetNode.InvokeKind invokeKind = callTarget.invokeKind();
                SharedMethod[] implementations = method.getImplementations();
                LoadHubNode hub = null;
                if (invokeKind.isDirect()) {
                    loweredCallTarget = (CallTargetNode)graph.add((Node)new DirectCallTargetNode((ValueNode[])parameters.toArray((Object[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, callTarget.targetMethod(), (CallingConvention.Type)callType, invokeKind));
                } else if (implementations.length == 0) {
                    FixedGuardNode unreachedGuard = (FixedGuardNode)graph.add((Node)new FixedGuardNode((LogicNode)LogicConstantNode.forBoolean((boolean)true, (Graph)graph), DeoptimizationReason.UnreachedCode, DeoptimizationAction.None, true));
                    graph.addBeforeFixed(node, (FixedWithNextNode)unreachedGuard);
                    unreachedGuard.lower(tool);
                    loweredCallTarget = (CallTargetNode)graph.add((Node)new DirectCallTargetNode((ValueNode[])parameters.toArray((Object[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, (ResolvedJavaMethod)method, (CallingConvention.Type)callType, invokeKind));
                } else if (implementations.length == 1) {
                    SharedMethod uniqueImplementation = implementations[0];
                    loweredCallTarget = (CallTargetNode)graph.add((Node)new DirectCallTargetNode((ValueNode[])parameters.toArray((Object[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, (ResolvedJavaMethod)uniqueImplementation, (CallingConvention.Type)callType, invokeKind));
                } else {
                    int vtableEntryOffset = NonSnippetLowerings.this.runtimeConfig.getVTableOffset(method.getVTableIndex());
                    hub = (LoadHubNode)graph.unique((Node)new LoadHubNode(NonSnippetLowerings.this.runtimeConfig.getProviders().getStampProvider(), (ValueNode)graph.maybeAddOrUnique((Node)PiNode.create((ValueNode)receiver, (ValueNode)nullCheck))));
                    AddressNode address = (AddressNode)graph.unique((Node)new OffsetAddressNode((ValueNode)hub, (ValueNode)ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)vtableEntryOffset, (StructuredGraph)graph)));
                    ReadNode entry = (ReadNode)graph.add((Node)new ReadNode(address, NamedLocationIdentity.FINAL_LOCATION, FrameAccess.getWordStamp(), OnHeapMemoryAccess.BarrierType.NONE));
                    loweredCallTarget = (CallTargetNode)graph.add((Node)new IndirectCallTargetNode((ValueNode)entry, (ValueNode[])parameters.toArray((Object[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, (ResolvedJavaMethod)method, (CallingConvention.Type)callType, invokeKind));
                    graph.addBeforeFixed(node, (FixedWithNextNode)entry);
                }
                callTarget.replaceAndDelete((Node)loweredCallTarget);
                if (nullCheck != null) {
                    nullCheck.lower(tool);
                }
                if (hub != null) {
                    hub.lower(tool);
                }
            }
        }
    }

    private static class GetClassLowering
    implements NodeLoweringProvider<GetClassNode> {
        private GetClassLowering() {
        }

        @Override
        public void lower(GetClassNode node, LoweringTool tool) {
            StampProvider stampProvider = tool.getStampProvider();
            LoadHubNode loadHub = (LoadHubNode)node.graph().unique((Node)new LoadHubNode(stampProvider, node.getObject()));
            node.replaceAtUsagesAndDelete((Node)loadHub);
            tool.getLowerer().lower((Node)loadHub, tool);
        }
    }

    private class ThrowBytecodeExceptionLowering
    implements NodeLoweringProvider<ThrowBytecodeExceptionNode> {
        private ThrowBytecodeExceptionLowering() {
        }

        @Override
        public void lower(ThrowBytecodeExceptionNode node, LoweringTool tool) {
            Object arguments;
            ForeignCallDescriptor descriptor;
            if (NonSnippetLowerings.this.mustNotAllocatePredicate != null && NonSnippetLowerings.this.mustNotAllocatePredicate.test(node.graph().method())) {
                descriptor = (ForeignCallDescriptor)throwCachedExceptionDescriptors.get(node.getExceptionKind());
                arguments = Collections.emptyList();
            } else {
                descriptor = (ForeignCallDescriptor)throwNewExceptionDescriptors.get(node.getExceptionKind());
                arguments = node.getArguments();
            }
            assert (descriptor != null && descriptor.getArgumentTypes().length == arguments.size());
            StructuredGraph graph = node.graph();
            ForeignCallNode foreignCallNode = (ForeignCallNode)graph.add((Node)new ForeignCallNode(descriptor, node.stamp(NodeView.DEFAULT), (List)arguments));
            foreignCallNode.setStateDuring(node.stateBefore());
            node.replaceAndDelete((Node)foreignCallNode);
            DeadEndNode deadEnd = (DeadEndNode)graph.add((Node)new DeadEndNode());
            foreignCallNode.setNext((FixedNode)deadEnd);
        }
    }

    private class BytecodeExceptionLowering
    implements NodeLoweringProvider<BytecodeExceptionNode> {
        private BytecodeExceptionLowering() {
        }

        @Override
        public void lower(BytecodeExceptionNode node, LoweringTool tool) {
            Object arguments;
            ForeignCallDescriptor descriptor;
            if (NonSnippetLowerings.this.mustNotAllocatePredicate != null && NonSnippetLowerings.this.mustNotAllocatePredicate.test(node.graph().method())) {
                descriptor = (ForeignCallDescriptor)getCachedExceptionDescriptors.get(node.getExceptionKind());
                arguments = Collections.emptyList();
            } else {
                descriptor = (ForeignCallDescriptor)createExceptionDescriptors.get(node.getExceptionKind());
                arguments = node.getArguments();
            }
            assert (descriptor != null && descriptor.getArgumentTypes().length == arguments.size());
            StructuredGraph graph = node.graph();
            ForeignCallNode foreignCallNode = (ForeignCallNode)graph.add((Node)new ForeignCallNode(descriptor, node.stamp(NodeView.DEFAULT), (List)arguments));
            foreignCallNode.setStateAfter(node.createStateDuring());
            graph.replaceFixedWithFixed((FixedWithNextNode)node, (FixedWithNextNode)foreignCallNode);
        }
    }
}

