/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.image;

import com.oracle.svm.core.image.ImageHeapPartition;
import java.util.Comparator;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public interface ImageHeapObject {
    public long getSize();

    public Object getObject();

    public void setHeapPartition(ImageHeapPartition var1);

    public ImageHeapPartition getPartition();

    public void setOffsetInPartition(long var1);

    public long getOffsetInPartition();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static class SizeComparator
    implements Comparator<ImageHeapObject> {
        @Override
        public int compare(ImageHeapObject o1, ImageHeapObject o2) {
            return Long.signum(o1.getSize() - o2.getSize());
        }
    }
}

