/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.UnsupportedFeatureError;
import com.oracle.svm.core.jdk.VMErrorSubstitutions;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;

@TargetClass(value=VMError.class)
final class Target_com_oracle_svm_core_util_VMError {
    Target_com_oracle_svm_core_util_VMError() {
    }

    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.", mayBeInlined=true)
    @Substitute
    private static RuntimeException shouldNotReachHere() {
        throw Target_com_oracle_svm_core_util_VMError.shouldNotReachHere(null, null);
    }

    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.", mayBeInlined=true)
    @Substitute
    private static RuntimeException shouldNotReachHere(String msg) {
        throw Target_com_oracle_svm_core_util_VMError.shouldNotReachHere(msg, null);
    }

    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.", mayBeInlined=true)
    @Substitute
    private static RuntimeException shouldNotReachHere(Throwable ex) {
        throw Target_com_oracle_svm_core_util_VMError.shouldNotReachHere(null, ex);
    }

    @NeverInline(value="Prevent change of safepoint status and disabling of stack overflow check to leak into caller, especially when caller is not uninterruptible")
    @Uninterruptible(reason="Allow VMError to be used in uninterruptible code.")
    @Substitute
    private static RuntimeException shouldNotReachHere(String msg, Throwable ex) {
        ThreadStackPrinter.printBacktrace();
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        VMErrorSubstitutions.shutdown(msg, ex);
        return null;
    }

    @Substitute
    private static RuntimeException unimplemented() {
        return Target_com_oracle_svm_core_util_VMError.unsupportedFeature("unimplemented");
    }

    @Substitute
    private static RuntimeException unsupportedFeature(String msg) {
        throw new UnsupportedFeatureError(msg);
    }
}

