/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.JDKUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;

public class VMErrorSubstitutions {
    @Uninterruptible(reason="Allow use in uninterruptible code.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate during printing diagnostics.")
    static void shutdown(String msg, Throwable ex) {
        VMErrorSubstitutions.doShutdown(msg, ex);
    }

    @NeverInline(value="Starting a stack walk in the caller frame")
    private static void doShutdown(String msg, Throwable ex) {
        try {
            Log log = Log.log();
            log.autoflush(true);
            log.string("Fatal error");
            if (msg != null) {
                log.string(": ").string(msg);
            }
            if (ex != null) {
                log.string(": ").exception(ex);
            } else {
                log.newline();
            }
            SubstrateUtil.printDiagnostics(log, KnownIntrinsics.readCallerStackPointer(), KnownIntrinsics.readReturnAddress());
            log.string("Fatal error");
            if (msg != null) {
                log.string(": ").string(msg);
            }
            if (ex != null) {
                log.string(": ").string(ex.getClass().getName()).string(": ").string(JDKUtils.getRawMessage(ex));
            }
            log.newline();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }
}

