/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.option.XOptions;
import com.oracle.svm.core.properties.RuntimePropertyParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class RuntimeOptionParser {
    private static final String DEFAULT_OPTION_PREFIX = "-XX:";
    private static final String GRAAL_OPTION_PREFIX = "-Dgraal.";
    private final SortedMap<String, OptionDescriptor> sortedOptions = new TreeMap<String, OptionDescriptor>();
    private ArrayList<OptionsParsedListener> optionsParsedListeners;

    public static String[] parseAndConsumeAllOptions(String[] initialArgs) {
        String[] args = initialArgs;
        if (SubstrateOptions.ParseRuntimeOptions.getValue().booleanValue()) {
            args = RuntimeOptionParser.singleton().parse(args, DEFAULT_OPTION_PREFIX, SubstrateOptionsParser.BooleanOptionFormat.PLUS_MINUS, true);
            args = RuntimeOptionParser.singleton().parse(args, GRAAL_OPTION_PREFIX, SubstrateOptionsParser.BooleanOptionFormat.NAME_VALUE, true);
            args = XOptions.singleton().parse(args, true);
            args = RuntimePropertyParser.parse(args);
            RuntimeOptionParser.singleton().notifyOptionsParsed();
        }
        return args;
    }

    public Optional<OptionDescriptor> getDescriptor(String optionName) {
        return Optional.ofNullable((OptionDescriptor)this.sortedOptions.get(optionName));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public RuntimeOptionParser() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean updateRuntimeOptions(Set<OptionDescriptor> newRuntimeOptions) {
        boolean result = false;
        for (OptionDescriptor descriptor : newRuntimeOptions) {
            String name = descriptor.getName();
            if (!this.sortedOptions.containsKey(name)) {
                this.sortedOptions.put(name, descriptor);
                result = true;
                continue;
            }
            assert (descriptor == this.sortedOptions.get(name));
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerOptionsParsedListener(OptionsParsedListener listener) {
        if (this.optionsParsedListeners == null) {
            this.optionsParsedListeners = new ArrayList();
        }
        this.optionsParsedListeners.add(listener);
    }

    public static RuntimeOptionParser singleton() {
        return (RuntimeOptionParser)ImageSingletons.lookup(RuntimeOptionParser.class);
    }

    public String[] parse(String[] args, String optionPrefix) {
        return this.parse(args, optionPrefix, SubstrateOptionsParser.BooleanOptionFormat.PLUS_MINUS, false);
    }

    public String[] parse(String[] args, String optionPrefix, SubstrateOptionsParser.BooleanOptionFormat booleanOptionFormat, boolean systemExitOnError) {
        int newIdx = 0;
        EconomicMap values = OptionValues.newOptionMap();
        for (int oldIdx = 0; oldIdx < args.length; ++oldIdx) {
            String arg = args[oldIdx];
            if (arg.startsWith(optionPrefix)) {
                this.parseOptionAtRuntime(arg, optionPrefix, booleanOptionFormat, values, systemExitOnError);
                continue;
            }
            assert (newIdx <= oldIdx);
            args[newIdx] = arg;
            ++newIdx;
        }
        if (!values.isEmpty()) {
            RuntimeOptionValues.singleton().update((UnmodifiableEconomicMap)values);
        }
        if (newIdx == args.length) {
            return args;
        }
        return Arrays.copyOf(args, newIdx);
    }

    private void parseOptionAtRuntime(String arg, String optionPrefix, SubstrateOptionsParser.BooleanOptionFormat booleanOptionFormat, EconomicMap<OptionKey<?>, Object> values, boolean systemExitOnError) {
        SubstrateOptionsParser.OptionParseResult parseResult;
        block6: {
            block5: {
                parseResult = SubstrateOptionsParser.parseOption(this.sortedOptions, arg.substring(optionPrefix.length()), values, optionPrefix, booleanOptionFormat);
                if (parseResult.printFlags()) break block5;
                if (!parseResult.printFlagsWithExtraHelp()) break block6;
            }
            SubstrateOptionsParser.printFlags(parseResult::matchesFlagsRuntime, this.sortedOptions, optionPrefix, Log.logStream(), parseResult.printFlagsWithExtraHelp());
            System.exit(0);
        }
        if (!parseResult.isValid()) {
            if (systemExitOnError) {
                Log.logStream().println("error: " + parseResult.getError());
                System.exit(1);
            }
            throw new IllegalArgumentException(parseResult.getError());
        }
    }

    public OptionKey<?> lookupOption(String name, Collection<OptionDescriptor> fuzzyMatches) {
        OptionKey option;
        OptionDescriptor desc = (OptionDescriptor)this.sortedOptions.get(name);
        if (desc == null) {
            if (fuzzyMatches != null) {
                OptionsParser.collectFuzzyMatches(this.sortedOptions.values(), (String)name, fuzzyMatches);
            }
            option = null;
        } else {
            option = desc.getOptionKey();
        }
        return option;
    }

    public Collection<OptionDescriptor> getDescriptors() {
        return this.sortedOptions.values();
    }

    private void notifyOptionsParsed() {
        if (this.optionsParsedListeners != null) {
            for (OptionsParsedListener listener : this.optionsParsedListeners) {
                listener.onOptionsParsed();
            }
        }
    }

    public static interface OptionsParsedListener {
        public void onOptionsParsed();
    }
}

