/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateSegfaultHandler;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.snippets.CEntryPointSnippets;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Signal;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

class PosixSubstrateSegfaultHandler
extends SubstrateSegfaultHandler {
    private static final CEntryPointLiteral<Signal.AdvancedSignalDispatcher> advancedSignalDispatcher = CEntryPointLiteral.create(PosixSubstrateSegfaultHandler.class, (String)"dispatch", (Class[])new Class[]{Integer.TYPE, Signal.siginfo_t.class, Signal.ucontext_t.class});

    PosixSubstrateSegfaultHandler() {
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault signal handler.")
    @Uninterruptible(reason="Must be uninterruptible until it gets immune to safepoints")
    private static void dispatch(int signalNumber, Signal.siginfo_t sigInfo, Signal.ucontext_t uContext) {
        if (SubstrateOptions.useLLVMBackend()) {
            Isolate isolate = ((SingleIsolateSegfaultIsolateSetup)ImageSingletons.lookup(CEntryPointSnippets.IsolateCreationWatcher.class)).getIsolate();
            if (isolate.rawValue() == -1L) {
                return;
            }
            CEntryPointActions.enterIsolateFromCrashHandler(isolate);
        } else if (!PosixSubstrateSegfaultHandler.tryEnterIsolate(uContext)) {
            return;
        }
        PosixSubstrateSegfaultHandler.dump(uContext);
    }

    @Override
    protected void install() {
        int structSigActionSize = SizeOf.get(Signal.sigaction.class);
        Signal.sigaction structSigAction = (Signal.sigaction)StackValue.get((int)structSigActionSize);
        LibC.memset(structSigAction, WordFactory.signed((int)0), WordFactory.unsigned((int)structSigActionSize));
        structSigAction.sa_flags(Signal.SA_SIGINFO());
        structSigAction.sa_sigaction((Signal.AdvancedSignalDispatcher)advancedSignalDispatcher.getFunctionPointer());
        Signal.sigaction(Signal.SignalEnum.SIGSEGV, structSigAction, (Signal.sigaction)WordFactory.nullPointer());
    }

    static class SingleIsolateSegfaultIsolateSetup
    implements CEntryPointSnippets.IsolateCreationWatcher {
        private static final CGlobalData<Pointer> baseIsolate = CGlobalDataFactory.createWord();

        SingleIsolateSegfaultIsolateSetup() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible method")
        public void registerIsolate(Isolate isolate) {
            PointerBase value = (PointerBase)baseIsolate.get().compareAndSwapWord(0, (WordBase)((Isolate)WordFactory.zero()), (WordBase)isolate, LocationIdentity.ANY_LOCATION);
            if (!value.isNull()) {
                baseIsolate.get().writeWord(0, (WordBase)WordFactory.signed((int)-1));
            }
        }

        @Uninterruptible(reason="Called from uninterruptible method")
        public Isolate getIsolate() {
            return (Isolate)baseIsolate.get().readWord(0);
        }
    }
}

