/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.posix.headers.Time;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.WordFactory;

@TargetClass(className="jdk.internal.misc.VM", onlyWith={JDK11OrLater.class})
final class Target_jdk_internal_misc_VM {
    Target_jdk_internal_misc_VM() {
    }

    @Substitute
    public static long getNanoTimeAdjustment(long offsetInSeconds) {
        long maxDiffSecs = 0x100000000L;
        long minDiffSecs = -4294967296L;
        Time.timeval tv = (Time.timeval)StackValue.get(Time.timeval.class);
        int status = Time.gettimeofday(tv, (Time.timezone)WordFactory.nullPointer());
        assert (status != -1) : "linux error";
        long seconds = tv.tv_sec();
        long nanos = tv.tv_usec() * 1000L;
        long diff = seconds - offsetInSeconds;
        if (diff >= 0x100000000L || diff <= -4294967296L) {
            return -1L;
        }
        return diff * 1000000000L + nanos;
    }
}

