/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.windows.headers.MemoryAPI;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

@Platforms(value={Platform.WINDOWS.class})
class WindowsStackOverflowSupport
implements StackOverflowCheck.OSSupport {
    WindowsStackOverflowSupport() {
    }

    @Override
    @Uninterruptible(reason="Called while thread is being attached to the VM, i.e., when the thread state is not yet set up.")
    public UnsignedWord lookupStackEnd() {
        MemoryAPI.MEMORY_BASIC_INFORMATION minfo = (MemoryAPI.MEMORY_BASIC_INFORMATION)StackValue.get(MemoryAPI.MEMORY_BASIC_INFORMATION.class);
        MemoryAPI.VirtualQuery(minfo, minfo, SizeOf.unsigned(MemoryAPI.MEMORY_BASIC_INFORMATION.class));
        return (Pointer)minfo.AllocationBase();
    }
}

