/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.Arrays;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOf;
import org.graalvm.compiler.replacements.amd64.AMD64ArrayIndexOfNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

@Platforms(value={Platform.AMD64.class})
class AMD64ArrayIndexOfForeignCalls {
    private static final ForeignCallSignature[] ORIGINAL_FOREIGN_CALLS = new ForeignCallSignature[]{AMD64ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_BYTES, AMD64ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS, AMD64ArrayIndexOf.STUB_INDEX_OF_TWO_CONSECUTIVE_CHARS_COMPACT, AMD64ArrayIndexOf.STUB_INDEX_OF_1_BYTE, AMD64ArrayIndexOf.STUB_INDEX_OF_2_BYTES, AMD64ArrayIndexOf.STUB_INDEX_OF_3_BYTES, AMD64ArrayIndexOf.STUB_INDEX_OF_4_BYTES, AMD64ArrayIndexOf.STUB_INDEX_OF_1_CHAR, AMD64ArrayIndexOf.STUB_INDEX_OF_2_CHARS, AMD64ArrayIndexOf.STUB_INDEX_OF_3_CHARS, AMD64ArrayIndexOf.STUB_INDEX_OF_4_CHARS, AMD64ArrayIndexOf.STUB_INDEX_OF_1_CHAR_COMPACT, AMD64ArrayIndexOf.STUB_INDEX_OF_2_CHARS_COMPACT, AMD64ArrayIndexOf.STUB_INDEX_OF_3_CHARS_COMPACT, AMD64ArrayIndexOf.STUB_INDEX_OF_4_CHARS_COMPACT};
    static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = (SnippetRuntime.SubstrateForeignCallDescriptor[])Arrays.stream(ORIGINAL_FOREIGN_CALLS).map(call -> SnippetRuntime.findForeignCall(AMD64ArrayIndexOfForeignCalls.class, call.getName(), true, new LocationIdentity[0])).toArray(SnippetRuntime.SubstrateForeignCallDescriptor[]::new);

    AMD64ArrayIndexOfForeignCalls() {
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOfTwoConsecutiveBytes(byte[] array, int arrayLength, int fromIndex, int searchValue) {
        return AMD64ArrayIndexOfNode.indexOf2ConsecutiveBytes((byte[])array, (int)arrayLength, (int)fromIndex, (int)searchValue);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOfTwoConsecutiveChars(char[] array, int arrayLength, int fromIndex, int searchValue) {
        return AMD64ArrayIndexOfNode.indexOf2ConsecutiveChars((char[])array, (int)arrayLength, (int)fromIndex, (int)searchValue);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOfTwoConsecutiveCharsCompact(byte[] array, int arrayLength, int fromIndex, int searchValue) {
        return AMD64ArrayIndexOfNode.indexOf2ConsecutiveChars((byte[])array, (int)arrayLength, (int)fromIndex, (int)searchValue);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf1Byte(byte[] array, int arrayLength, int fromIndex, byte b) {
        return AMD64ArrayIndexOfNode.indexOf((byte[])array, (int)arrayLength, (int)fromIndex, (byte)b);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf2Bytes(byte[] array, int arrayLength, int fromIndex, byte b1, byte b2) {
        return AMD64ArrayIndexOfNode.indexOf((byte[])array, (int)arrayLength, (int)fromIndex, (byte)b1, (byte)b2);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf3Bytes(byte[] array, int arrayLength, int fromIndex, byte b1, byte b2, byte b3) {
        return AMD64ArrayIndexOfNode.indexOf((byte[])array, (int)arrayLength, (int)fromIndex, (byte)b1, (byte)b2, (byte)b3);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf4Bytes(byte[] array, int arrayLength, int fromIndex, byte b1, byte b2, byte b3, byte b4) {
        return AMD64ArrayIndexOfNode.indexOf((byte[])array, (int)arrayLength, (int)fromIndex, (byte)b1, (byte)b2, (byte)b3, (byte)b4);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf1Char(char[] array, int arrayLength, int fromIndex, char c) {
        return AMD64ArrayIndexOfNode.indexOf((char[])array, (int)arrayLength, (int)fromIndex, (char)c);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf2Chars(char[] array, int arrayLength, int fromIndex, char c1, char c2) {
        return AMD64ArrayIndexOfNode.indexOf((char[])array, (int)arrayLength, (int)fromIndex, (char)c1, (char)c2);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf3Chars(char[] array, int arrayLength, int fromIndex, char c1, char c2, char c3) {
        return AMD64ArrayIndexOfNode.indexOf((char[])array, (int)arrayLength, (int)fromIndex, (char)c1, (char)c2, (char)c3);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf4Chars(char[] array, int arrayLength, int fromIndex, char c1, char c2, char c3, char c4) {
        return AMD64ArrayIndexOfNode.indexOf((char[])array, (int)arrayLength, (int)fromIndex, (char)c1, (char)c2, (char)c3, (char)c4);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf1CharCompact(byte[] array, int arrayLength, int fromIndex, char c) {
        return AMD64ArrayIndexOfNode.indexOf((byte[])array, (int)arrayLength, (int)fromIndex, (char)c);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf2CharsCompact(byte[] array, int arrayLength, int fromIndex, char c1, char c2) {
        return AMD64ArrayIndexOfNode.indexOf((byte[])array, (int)arrayLength, (int)fromIndex, (char)c1, (char)c2);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf3CharsCompact(byte[] array, int arrayLength, int fromIndex, char c1, char c2, char c3) {
        return AMD64ArrayIndexOfNode.indexOf((byte[])array, (int)arrayLength, (int)fromIndex, (char)c1, (char)c2, (char)c3);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static int indexOf4CharsCompact(byte[] array, int arrayLength, int fromIndex, char c1, char c2, char c3, char c4) {
        return AMD64ArrayIndexOfNode.indexOf((byte[])array, (int)arrayLength, (int)fromIndex, (char)c1, (char)c2, (char)c3, (char)c4);
    }
}

