/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta.aarch64;

import com.oracle.svm.core.CodeSynchronizationOperations;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.RuntimeCodeInstaller;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import jdk.vm.ci.aarch64.AArch64;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.core.common.NumUtil;

public class AArch64RuntimeCodeInstallerPlatformHelper
implements RuntimeCodeInstaller.RuntimeCodeInstallerPlatformHelper {
    @Override
    public int getTrampolineCallSize() {
        return 12;
    }

    @Override
    public boolean targetWithinPCDisplacement(long pcDisplacement) {
        assert ((pcDisplacement & 3L) == 0L) : "Immediate has to be half word aligned";
        VMError.guarantee((pcDisplacement & 3L) == 0L, "Immediate has to be half word aligned");
        return NumUtil.isSignedNbit((int)28, (long)pcDisplacement);
    }

    static int getAdrpEncoding(int regEncoding, int immHi21) {
        int instruction = 0;
        int imm = immHi21 & NumUtil.getNbitNumberInt((int)21);
        instruction |= AArch64Assembler.Instruction.ADRP.encoding;
        instruction |= 0x10000000;
        instruction |= (imm & 3) << 29;
        instruction |= (imm >> 2 & 0x7FFFF) << 5;
        return instruction |= regEncoding;
    }

    static int getBrEncoding(int regEncoding) {
        int instruction = 0;
        instruction |= AArch64Assembler.Instruction.BR.encoding;
        instruction = (int)((long)instruction | 0xD6000000L);
        return instruction |= regEncoding << 5;
    }

    static int getLdrEncoding(int destRegEncoding, int srcRegEncoding, int immLo12) {
        assert ((immLo12 & 7) == 0) : "Immediate must be word aligned";
        VMError.guarantee((immLo12 & 7) == 0, "Immediate must be word aligned");
        int instruction = 0;
        instruction |= 0xF9400000;
        instruction |= (immLo12 >> 3 & 0x1FF) << 10;
        instruction |= srcRegEncoding << 5;
        return instruction |= destRegEncoding;
    }

    @Override
    public int insertTrampolineCalls(byte[] compiledBytes, int initialPos, Map<Long, Integer> directTargets) {
        int currentPos = NumUtil.roundUp((int)initialPos, (int)8);
        ByteOrder byteOrder = ConfigurationValues.getTarget().arch.getByteOrder();
        ByteBuffer codeBuffer = ByteBuffer.wrap(compiledBytes).order(byteOrder);
        int scratchRegEncoding = AArch64.rscratch1.encoding;
        for (Map.Entry<Long, Integer> entry : directTargets.entrySet()) {
            long targetAddress = entry.getKey();
            int trampolineOffset = entry.getValue();
            int relativePageDifference = AArch64Assembler.PatcherUtil.computeRelativePageDifference((int)currentPos, (int)trampolineOffset, (int)4096);
            int instruction = AArch64RuntimeCodeInstallerPlatformHelper.getAdrpEncoding(scratchRegEncoding, relativePageDifference);
            codeBuffer.putInt(trampolineOffset + 0, instruction);
            instruction = AArch64RuntimeCodeInstallerPlatformHelper.getLdrEncoding(scratchRegEncoding, scratchRegEncoding, currentPos & 0xFFF);
            codeBuffer.putInt(trampolineOffset + 4, instruction);
            instruction = AArch64RuntimeCodeInstallerPlatformHelper.getBrEncoding(scratchRegEncoding);
            codeBuffer.putInt(trampolineOffset + 8, instruction);
            codeBuffer.putLong(currentPos, targetAddress);
            currentPos += 8;
        }
        return currentPos;
    }

    @Override
    public void performCodeSynchronization(CodeInfo codeInfo) {
        CodeSynchronizationOperations.clearCache(CodeInfoAccess.getCodeStart(codeInfo).rawValue(), CodeInfoAccess.getCodeSize(codeInfo).rawValue());
        VMThreads.ActionOnTransitionToJavaSupport.requestAllThreadsSynchronizeCode();
    }
}

