/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NativeImageClassLoader
extends URLClassLoader {
    public final List<Path> imagecp = Collections.unmodifiableList(Arrays.stream(this.getURLs()).map(NativeImageClassLoader::urlToPath).collect(Collectors.toList()));
    public final List<Path> buildcp = Collections.unmodifiableList(Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()));

    NativeImageClassLoader(String[] classpath, ClassLoader parent) {
        super(NativeImageClassLoader.verifyClassPathAndConvertToURLs(classpath), parent);
    }

    private static URL[] verifyClassPathAndConvertToURLs(String[] classpath) {
        Stream<URL> pathStream = new LinkedHashSet<String>(Arrays.asList(classpath)).stream().flatMap(NativeImageClassLoader::toClassPathEntries);
        return (URL[])pathStream.map(v -> {
            try {
                return v.toAbsolutePath().toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw UserError.abort("Invalid classpath element '" + v + "'. Make sure that all paths provided with '" + "-imagecp" + "' are correct.", new Object[0]);
            }
        }).toArray(URL[]::new);
    }

    static Stream<Path> toClassPathEntries(String classPathEntry) {
        Path entry = ClasspathUtils.stringToClasspath(classPathEntry);
        if (entry.endsWith("$JavaCla$$pathWildcard$ubstitute$")) {
            try {
                return Files.list(entry.getParent()).filter(ClasspathUtils::isJar);
            }
            catch (IOException e) {
                return Stream.empty();
            }
        }
        if (Files.isReadable(entry)) {
            return Stream.of(entry);
        }
        return Stream.empty();
    }

    private static Path urlToPath(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw VMError.shouldNotReachHere();
        }
    }
}

