/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.ParallelExecutionException;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.JavaMainWrapper;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.ImageBuildTask;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ImageSingletonsSupportImpl;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.image.AbstractBootImage;
import com.oracle.svm.hosted.option.HostedOptionParser;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;

public class NativeImageGeneratorRunner
implements ImageBuildTask {
    private volatile NativeImageGenerator generator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exitStatus;
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        String[] classpath = NativeImageGeneratorRunner.extractImageClassPath(arguments);
        final int watchPID = NativeImageGeneratorRunner.extractWatchPID(arguments);
        TimerTask timerTask = null;
        if (watchPID >= 0) {
            VMError.guarantee(OS.getCurrent().hasProcFS, "-watchpid <pid> requires system with /proc");
            timerTask = new TimerTask(){
                int cmdlineHashCode = 0;

                @Override
                public void run() {
                    try {
                        int currentCmdlineHashCode = Arrays.hashCode(Files.readAllBytes(Paths.get("/proc/" + watchPID + "/cmdline", new String[0])));
                        if (this.cmdlineHashCode == 0) {
                            this.cmdlineHashCode = currentCmdlineHashCode;
                        } else if (currentCmdlineHashCode != this.cmdlineHashCode) {
                            System.exit(1);
                        }
                    }
                    catch (IOException e) {
                        System.exit(1);
                    }
                }
            };
            java.util.Timer timer = new java.util.Timer("native-image pid watcher");
            timer.scheduleAtFixedRate(timerTask, 0L, 1000L);
        }
        try {
            NativeImageClassLoader nativeImageClassLoader = NativeImageGeneratorRunner.installNativeImageClassLoader(classpath);
            exitStatus = new NativeImageGeneratorRunner().build(arguments.toArray(new String[0]), nativeImageClassLoader);
        }
        finally {
            NativeImageGeneratorRunner.unhookCustomClassLoaders();
            if (timerTask != null) {
                timerTask.cancel();
            }
        }
        System.exit(exitStatus);
    }

    private static void unhookCustomClassLoaders() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (loader instanceof NativeImageSystemClassLoader) {
            NativeImageSystemClassLoader customSystemClassLoader = (NativeImageSystemClassLoader)ClassLoader.getSystemClassLoader();
            customSystemClassLoader.setDelegate(null);
            Thread.currentThread().setContextClassLoader(customSystemClassLoader.getDefaultSystemClassLoader());
        }
    }

    public static NativeImageClassLoader installNativeImageClassLoader(String[] classpath) {
        if (!(ClassLoader.getSystemClassLoader() instanceof NativeImageSystemClassLoader)) {
            String badCustomClassLoaderError = "SystemClassLoader is the default system class loader. This might create problems when using reflection during class initialization at build-time. To fix this error add -Djava.system.class.loader=" + NativeImageSystemClassLoader.class.getCanonicalName();
            UserError.abort(badCustomClassLoaderError, new Object[0]);
        }
        NativeImageSystemClassLoader customSystemClassLoader = (NativeImageSystemClassLoader)ClassLoader.getSystemClassLoader();
        NativeImageClassLoader nativeImageClassLoader = new NativeImageClassLoader(classpath, customSystemClassLoader.getDefaultSystemClassLoader());
        Thread.currentThread().setContextClassLoader(nativeImageClassLoader);
        customSystemClassLoader.setDelegate(nativeImageClassLoader);
        return nativeImageClassLoader;
    }

    public static String[] extractImageClassPath(List<String> arguments) {
        int cpArgIndex = arguments.indexOf("-imagecp");
        String msgTail = " '-imagecp <image classpath>' argument.";
        if (cpArgIndex == -1) {
            throw UserError.abort("Missing" + msgTail, new Object[0]);
        }
        arguments.remove(cpArgIndex);
        try {
            String imageClasspath = arguments.remove(cpArgIndex);
            return imageClasspath.split(File.pathSeparator, Integer.MAX_VALUE);
        }
        catch (IndexOutOfBoundsException e) {
            throw UserError.abort("Missing <image classpath> for" + msgTail, new Object[0]);
        }
    }

    public static int extractWatchPID(List<String> arguments) {
        int cpIndex = arguments.indexOf("-watchpid");
        if (cpIndex >= 0) {
            if (cpIndex + 1 >= arguments.size()) {
                throw UserError.abort("ProcessID must be provided after the '-watchpid' argument.\n", new Object[0]);
            }
            arguments.remove(cpIndex);
            String pidStr = arguments.get(cpIndex);
            arguments.remove(cpIndex);
            return Integer.parseInt(pidStr);
        }
        return -1;
    }

    public static boolean isValidJavaVersion() {
        return Boolean.getBoolean("substratevm.IgnoreGraalVersionCheck") || JavaVersionUtil.JAVA_SPEC <= 8;
    }

    private static void reportToolUserError(String msg) {
        NativeImageGeneratorRunner.reportUserError("native-image " + msg);
    }

    private static boolean isValidArchitecture() {
        Architecture originalTargetArch = GraalAccess.getOriginalTarget().arch;
        return originalTargetArch instanceof AMD64 || originalTargetArch instanceof AArch64;
    }

    private static boolean isValidOperatingSystem() {
        OS currentOs = OS.getCurrent();
        return currentOs == OS.LINUX || currentOs == OS.DARWIN || currentOs == OS.WINDOWS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int buildImage(String[] arguments, NativeImageClassLoader classLoader) {
        if (!NativeImageGeneratorRunner.verifyValidJavaVersionAndPlatform()) {
            return 1;
        }
        Timer totalTimer = new Timer("[total]", false);
        ForkJoinPool analysisExecutor = null;
        ForkJoinPool compilationExecutor = null;
        OptionValues parsedHostedOptions = null;
        try (Timer.StopTimer ignored = totalTimer.start();){
            ImageClassLoader imageClassLoader;
            Timer classlistTimer = new Timer("classlist", false);
            try (Timer.StopTimer ignored1 = classlistTimer.start();){
                imageClassLoader = ImageClassLoader.create(NativeImageGenerator.defaultPlatform(classLoader), classLoader);
            }
            HostedOptionParser optionParser = new HostedOptionParser(imageClassLoader);
            Object[] remainingArgs = optionParser.parse(arguments);
            if (remainingArgs.length > 0) {
                throw UserError.abort("Unknown options: " + Arrays.toString(remainingArgs), new Object[0]);
            }
            parsedHostedOptions = new OptionValues(optionParser.getHostedValues());
            DebugContext debug = new DebugContext.Builder(parsedHostedOptions, (DebugHandlersFactory)new GraalDebugHandlersFactory(GraalAccess.getOriginalSnippetReflection())).build();
            String imageName = (String)SubstrateOptions.Name.getValue(parsedHostedOptions);
            if (imageName.length() == 0) {
                throw UserError.abort("No output file name specified. Use '" + SubstrateOptionsParser.commandArgument(SubstrateOptions.Name, "<output-file>") + "'.", new Object[0]);
            }
            totalTimer.setPrefix(imageName);
            classlistTimer.setPrefix(imageName);
            classlistTimer.print();
            HashMap<Method, CEntryPointData> entryPoints = new HashMap<Method, CEntryPointData>();
            Pair mainEntryPointData = Pair.empty();
            JavaMainWrapper.JavaMainSupport javaMainSupport = null;
            boolean isStaticExecutable = (Boolean)SubstrateOptions.StaticExecutable.getValue(parsedHostedOptions);
            boolean isSharedLibrary = (Boolean)SubstrateOptions.SharedLibrary.getValue(parsedHostedOptions);
            if (isStaticExecutable && isSharedLibrary) {
                throw UserError.abort("Cannot pass both option: " + SubstrateOptionsParser.commandArgument(SubstrateOptions.SharedLibrary, "+") + " and " + SubstrateOptionsParser.commandArgument(SubstrateOptions.StaticExecutable, "+"), new Object[0]);
            }
            AbstractBootImage.NativeImageKind imageKind = isSharedLibrary ? AbstractBootImage.NativeImageKind.SHARED_LIBRARY : (isStaticExecutable ? AbstractBootImage.NativeImageKind.STATIC_EXECUTABLE : AbstractBootImage.NativeImageKind.EXECUTABLE);
            String className = (String)SubstrateOptions.Class.getValue(parsedHostedOptions);
            if (imageKind.isExecutable && className.isEmpty()) {
                throw UserError.abort("Must specify main entry point class when building " + (Object)((Object)imageKind) + " native image. Use '" + SubstrateOptionsParser.commandArgument(SubstrateOptions.Class, "<fully-qualified-class-name>") + "'.", new Object[0]);
            }
            if (!className.isEmpty()) {
                Method mainEntryPoint;
                Class<?> mainClass;
                try {
                    mainClass = Class.forName(className, false, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    throw UserError.abort("Main entry point class '" + className + "' not found.", new Object[0]);
                }
                String mainEntryPointName = (String)SubstrateOptions.Method.getValue(parsedHostedOptions);
                if (mainEntryPointName.isEmpty()) {
                    throw UserError.abort("Must specify main entry point method when building " + (Object)((Object)imageKind) + " native image. Use '" + SubstrateOptionsParser.commandArgument(SubstrateOptions.Method, "<method-name>") + "'.", new Object[0]);
                }
                try {
                    mainEntryPoint = mainClass.getDeclaredMethod(mainEntryPointName, Integer.TYPE, CCharPointerPointer.class);
                }
                catch (NoSuchMethodException ignored2) {
                    Method javaMainMethod;
                    try {
                        javaMainMethod = ReflectionUtil.lookupMethod(mainClass, (String)mainEntryPointName, (Class[])new Class[]{String[].class});
                    }
                    catch (ReflectionUtil.ReflectionUtilError ex) {
                        throw UserError.abort(ex.getCause(), String.format("Method '%s.%s' is declared as the main entry point but it can not be found. Make sure that class '%s' is on the classpath and that method '%s(String[])' exists in that class.", mainClass.getName(), mainEntryPointName, mainClass.getName(), mainEntryPointName));
                    }
                    if (javaMainMethod.getReturnType() != Void.TYPE) {
                        throw UserError.abort("Java main method '" + mainClass.getName() + "." + mainEntryPointName + "(String[])' does not have the return type 'void'.", new Object[0]);
                    }
                    int mainMethodModifiers = javaMainMethod.getModifiers();
                    if (!Modifier.isStatic(mainMethodModifiers)) {
                        throw UserError.abort("Java main method '" + mainClass.getName() + "." + mainEntryPointName + "(String[])' is not static.", new Object[0]);
                    }
                    if (!Modifier.isPublic(mainMethodModifiers)) {
                        throw UserError.abort("Java main method '" + mainClass.getName() + "." + mainEntryPointName + "(String[])' is not public.", new Object[0]);
                    }
                    javaMainSupport = new JavaMainWrapper.JavaMainSupport(javaMainMethod);
                    mainEntryPoint = JavaMainWrapper.class.getDeclaredMethod("run", Integer.TYPE, CCharPointerPointer.class);
                }
                CEntryPoint annotation = mainEntryPoint.getAnnotation(CEntryPoint.class);
                if (annotation == null) {
                    throw UserError.abort("Entry point must have the '@" + CEntryPoint.class.getSimpleName() + "' annotation", new Object[0]);
                }
                Class<?>[] pt = mainEntryPoint.getParameterTypes();
                if (pt.length != 2 || pt[0] != Integer.TYPE || pt[1] != CCharPointerPointer.class || mainEntryPoint.getReturnType() != Integer.TYPE) {
                    throw UserError.abort("Main entry point must have signature 'int main(int argc, CCharPointerPointer argv)'.", new Object[0]);
                }
                mainEntryPointData = Pair.create((Object)mainEntryPoint, (Object)CEntryPointData.create(mainEntryPoint, imageKind.mainEntryPointName));
            }
            int maxConcurrentThreads = NativeImageOptions.getMaximumNumberOfConcurrentThreads(parsedHostedOptions);
            analysisExecutor = Inflation.createExecutor((DebugContext)debug, (int)NativeImageOptions.getMaximumNumberOfAnalysisThreads(parsedHostedOptions));
            compilationExecutor = Inflation.createExecutor((DebugContext)debug, (int)maxConcurrentThreads);
            this.generator = new NativeImageGenerator(imageClassLoader, optionParser, (Pair<Method, CEntryPointData>)mainEntryPointData);
            this.generator.run(entryPoints, javaMainSupport, imageName, imageKind, SubstitutionProcessor.IDENTITY, compilationExecutor, analysisExecutor, optionParser.getRuntimeOptionNames());
        }
        catch (InterruptImageBuilding e) {
            if (analysisExecutor != null) {
                analysisExecutor.shutdownNow();
            }
            if (compilationExecutor != null) {
                compilationExecutor.shutdownNow();
            }
            if (e.getReason().isPresent()) {
                NativeImageGeneratorRunner.info(e.getReason().get());
                int imageClassLoader = 0;
                return imageClassLoader;
            }
            int imageClassLoader = 3;
            return imageClassLoader;
        }
        catch (FallbackFeature.FallbackImageRequest e) {
            if (FallbackExecutor.class.getName().equals(SubstrateOptions.Class.getValue())) {
                NativeImageGeneratorRunner.reportFatalError(e, "FallbackImageRequest while building fallback image.");
                int imageClassLoader = 1;
                return imageClassLoader;
            }
            NativeImageGeneratorRunner.reportUserException(e, parsedHostedOptions, NativeImageGeneratorRunner::warn);
            int imageClassLoader = 2;
            return imageClassLoader;
        }
        catch (AnalysisError.ParsingError e) {
            NativeImageGeneratorRunner.reportFatalError(e);
            int imageClassLoader = 1;
            return imageClassLoader;
        }
        catch (AnalysisError | UserError.UserException e) {
            NativeImageGeneratorRunner.reportUserError(e, parsedHostedOptions);
            int imageClassLoader = 1;
            return imageClassLoader;
        }
        catch (ParallelExecutionException pee) {
            boolean hasUserError = false;
            for (Throwable exception : pee.getExceptions()) {
                if (exception instanceof UserError.UserException) {
                    NativeImageGeneratorRunner.reportUserError(exception, parsedHostedOptions);
                    hasUserError = true;
                    continue;
                }
                if (!(exception instanceof AnalysisError) || exception instanceof AnalysisError.ParsingError) continue;
                NativeImageGeneratorRunner.reportUserError(exception, parsedHostedOptions);
                hasUserError = true;
            }
            if (hasUserError) {
                int n = 1;
                return n;
            }
            if (pee.getExceptions().size() > 1) {
                System.err.println(pee.getExceptions().size() + " fatal errors detected:");
            }
            for (Throwable exception : pee.getExceptions()) {
                NativeImageGeneratorRunner.reportFatalError(exception);
            }
            int n = 1;
            return n;
        }
        catch (Throwable e) {
            NativeImageGeneratorRunner.reportFatalError(e);
            int n = 1;
            return n;
        }
        finally {
            NativeImageGenerator.clearSystemPropertiesForImage();
            ImageSingletonsSupportImpl.HostedManagement.clearInThread();
        }
        totalTimer.print();
        return 0;
    }

    public static boolean verifyValidJavaVersionAndPlatform() {
        if (!NativeImageGeneratorRunner.isValidJavaVersion()) {
            NativeImageGeneratorRunner.reportToolUserError("supports only Java 1.8 with an update version 40+. Detected Java version is: " + NativeImageGeneratorRunner.getJavaVersion());
            return false;
        }
        if (!NativeImageGeneratorRunner.isValidArchitecture()) {
            NativeImageGeneratorRunner.reportToolUserError("runs only on architecture AMD64. Detected architecture: " + GraalAccess.getOriginalTarget().arch.getClass().getSimpleName());
        }
        if (!NativeImageGeneratorRunner.isValidOperatingSystem()) {
            NativeImageGeneratorRunner.reportToolUserError("runs on Linux, Mac OS X and Windows only. Detected OS: " + System.getProperty("os.name"));
            return false;
        }
        return true;
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    private static void reportFatalError(Throwable e) {
        System.err.print("Fatal error:");
        e.printStackTrace();
    }

    private static void reportFatalError(Throwable e, String msg) {
        System.err.print("Fatal error: " + msg);
        e.printStackTrace();
    }

    public static void reportUserError(String msg) {
        System.err.println("Error: " + msg);
    }

    public static void reportUserError(Throwable e, OptionValues parsedHostedOptions) {
        NativeImageGeneratorRunner.reportUserException(e, parsedHostedOptions, NativeImageGeneratorRunner::reportUserError);
    }

    private static void reportUserException(Throwable e, OptionValues parsedHostedOptions, Consumer<String> report) {
        if (e instanceof UserError.UserException) {
            UserError.UserException ue = (UserError.UserException)e;
            for (String message : ue.getMessages()) {
                report.accept(message);
            }
        } else {
            report.accept(e.getMessage());
        }
        if (parsedHostedOptions != null && ((Boolean)NativeImageOptions.ReportExceptionStackTraces.getValue(parsedHostedOptions)).booleanValue()) {
            e.printStackTrace();
        } else {
            report.accept("Use " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportExceptionStackTraces, "+") + " to print stacktrace of underlying exception");
        }
    }

    private static void info(String msg) {
        System.out.println("Info: " + msg);
    }

    private static void warn(String msg) {
        System.err.println("Warning: " + msg);
    }

    @Override
    public int build(String[] args, NativeImageClassLoader imageClassLoader) {
        return this.buildImage(args, imageClassLoader);
    }

    @Override
    public void interruptBuild() {
        NativeImageGenerator generatorInstance = this.generator;
        if (generatorInstance != null) {
            generatorInstance.interruptBuild();
        }
    }

    public static class JDK9Plus {
        public static void main(String[] args) {
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"org.graalvm.truffle", (boolean)false);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.internal.vm.ci", (boolean)false);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.internal.vm.compiler", (boolean)false);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.internal.vm.compiler.management", (boolean)true);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"com.oracle.graal.graal_enterprise", (boolean)true);
            ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"jdk.internal.loader", (boolean)false);
            ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"sun.text.spi", (boolean)false);
            ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"jdk.internal.org.objectweb.asm", (boolean)false);
            NativeImageGeneratorRunner.main(args);
        }
    }
}

