/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.codegen;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Consumer;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class CCompilerInvoker {
    public final Path tempDirectory;
    public final CompilerInfo compilerInfo;

    protected CCompilerInvoker(Path tempDirectory) {
        this.tempDirectory = tempDirectory;
        try {
            this.compilerInfo = this.getCCompilerInfo();
            if (this.compilerInfo == null) {
                UserError.abort(String.format("Unable to detect supported %s native software development toolchain.", OS.getCurrent().name()), new Object[0]);
            }
        }
        catch (UserError.UserException err) {
            throw CCompilerInvoker.addSkipCheckingInfo(err);
        }
    }

    public static CCompilerInvoker create(Path tempDirectory) {
        OS hostOS = OS.getCurrent();
        switch (hostOS) {
            case LINUX: {
                return new LinuxCCompilerInvoker(tempDirectory);
            }
            case DARWIN: {
                return new DarwinCCompilerInvoker(tempDirectory);
            }
            case WINDOWS: {
                return new WindowsCCompilerInvoker(tempDirectory);
            }
        }
        throw UserError.abort("No CCompilerInvoker for operating system " + hostOS.name(), new Object[0]);
    }

    public void verifyCompiler() {
        if (SubstrateOptions.CheckToolchain.getValue().booleanValue()) {
            try {
                this.verify();
            }
            catch (UserError.UserException err) {
                throw CCompilerInvoker.addSkipCheckingInfo(err);
            }
        }
    }

    private static UserError.UserException addSkipCheckingInfo(UserError.UserException err) {
        ArrayList<String> messages = new ArrayList<String>();
        err.getMessages().forEach(messages::add);
        messages.add("To prevent native-toolchain checking provide command-line option " + SubstrateOptionsParser.commandArgument(SubstrateOptions.CheckToolchain, "-"));
        return UserError.abort(messages);
    }

    protected InputStream getCompilerErrorStream(Process compilingProcess) {
        return compilingProcess.getErrorStream();
    }

    protected abstract void verify();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompilerInfo getCCompilerInfo() {
        Path compilerPath = this.getCCompilerPath().toAbsolutePath();
        if (!SubstrateOptions.CheckToolchain.getValue().booleanValue()) {
            return new CompilerInfo(compilerPath, null, this.getClass().getSimpleName(), null, 0, 0, 0, null);
        }
        List<String> compilerCommand = this.createCompilerCommand(compilerPath, this.getVersionInfoOptions(), null, new Path[0]);
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(compilerCommand).directory(this.tempDirectory.toFile()).redirectErrorStream(true);
        pb.environment().put("LC_ALL", "C");
        CompilerInfo result = null;
        Process process = null;
        try {
            process = pb.start();
            try (Scanner scanner = new Scanner(process.getInputStream());){
                result = this.createCompilerInfo(compilerPath, scanner);
            }
            process.waitFor();
        }
        catch (InterruptedException ex) {
            throw new InterruptImageBuilding();
        }
        catch (IOException e) {
            UserError.abort(e, "Collecting native-compiler info with '" + SubstrateUtil.getShellCommandString(pb.command(), false) + "' failed");
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return result;
    }

    protected List<String> getVersionInfoOptions() {
        return Arrays.asList("-v");
    }

    protected abstract CompilerInfo createCompilerInfo(Path var1, Scanner var2);

    protected static String[] guessTargetTriplet(Scanner scanner) {
        while (scanner.findInLine("Target: ") == null) {
            scanner.nextLine();
        }
        scanner.useDelimiter("-");
        String arch = scanner.next();
        String vendor = scanner.next();
        String os = scanner.nextLine();
        os = os.startsWith("-") ? os.substring(1) : os;
        scanner.reset();
        return new String[]{arch, vendor, os};
    }

    protected static Class<? extends Architecture> guessArchitecture(String archStr) {
        switch (archStr) {
            case "x86_64": 
            case "x64": {
                return AMD64.class;
            }
            case "aarch64": {
                return AArch64.class;
            }
        }
        return null;
    }

    public void compileAndParseError(List<String> options, Path source, Path target, CompilerErrorHandler handler, DebugContext debug) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(this.createCompilerCommand(options, target.normalize(), source.normalize())).directory(this.tempDirectory.toFile());
        Process compilingProcess = null;
        try {
            List<String> lines;
            try (DebugContext.Scope s = debug.scope((Object)"InvokeCC");){
                debug.log("Using CompilerCommand: %s", (Object)SubstrateUtil.getShellCommandString(pb.command(), false));
            }
            compilingProcess = pb.start();
            try (InputStream compilerErrors = this.getCompilerErrorStream(compilingProcess);){
                lines = FileUtils.readAllLines(compilerErrors);
            }
            boolean errorReported = false;
            for (String line : lines) {
                if (!this.detectError(line)) continue;
                if (handler != null) {
                    handler.handle(pb, source, line);
                }
                errorReported = true;
            }
            int status = compilingProcess.waitFor();
            if (status != 0 && !errorReported && handler != null) {
                handler.handle(pb, source, lines.toString());
            }
        }
        catch (InterruptedException ex) {
            throw new InterruptImageBuilding();
        }
        catch (IOException ex) {
            throw UserError.abort(ex, "Unable to compile C-ABI query code. Make sure native software development toolchain is installed on your system.");
        }
        finally {
            if (compilingProcess != null) {
                compilingProcess.destroy();
            }
        }
    }

    protected boolean detectError(String line) {
        return line.contains(": error:") || line.contains(": fatal error:");
    }

    public static Optional<Path> lookupSearchPath(String name) {
        return Arrays.stream(System.getenv("PATH").split(File.pathSeparator)).map(entry -> Paths.get(entry, name)).filter(Files::isExecutable).findFirst();
    }

    public Path getCCompilerPath() {
        Path compilerPath;
        String userDefinedPath = SubstrateOptions.CCompilerPath.getValue();
        if (userDefinedPath != null) {
            compilerPath = Paths.get(userDefinedPath, new String[0]);
        } else {
            String executableName = this.asExecutableName(this.getDefaultCompiler());
            Optional<Path> optCompilerPath = CCompilerInvoker.lookupSearchPath(executableName);
            if (optCompilerPath.isPresent()) {
                compilerPath = optCompilerPath.get();
            } else {
                throw UserError.abort("Default native-compiler executable '" + executableName + "' not found via environment variable PATH", new Object[0]);
            }
        }
        if (Files.isDirectory(compilerPath, new LinkOption[0]) || !Files.isExecutable(compilerPath)) {
            String msgSubject = userDefinedPath != null ? SubstrateOptionsParser.commandArgument(SubstrateOptions.CCompilerPath, userDefinedPath) : "Default native-compiler '" + compilerPath + "'";
            throw UserError.abort(msgSubject + " does not specify a path to an executable.", new Object[0]);
        }
        return compilerPath;
    }

    protected abstract String getDefaultCompiler();

    public String asExecutableName(String basename) {
        return basename;
    }

    public List<String> createCompilerCommand(List<String> options, Path target, Path ... input) {
        return this.createCompilerCommand(this.compilerInfo.compilerPath, options, target, input);
    }

    private List<String> createCompilerCommand(Path compilerPath, List<String> options, Path target, Path ... input) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(compilerPath.toString());
        command.addAll(Arrays.asList(SubstrateOptions.CCompilerOption.getValue()));
        command.addAll(options);
        if (target != null) {
            command.addAll(this.addTarget(target));
        }
        for (Path elem : input) {
            command.add(elem.toString());
        }
        return command;
    }

    protected List<String> addTarget(Path target) {
        return Arrays.asList("-o", target.toString());
    }

    public static interface CompilerErrorHandler {
        public void handle(ProcessBuilder var1, Path var2, String var3);
    }

    public static final class CompilerInfo {
        public final Path compilerPath;
        public final String name;
        public final String shortName;
        public final String vendor;
        public final int versionMajor;
        public final int versionMinor0;
        public final int versionMinor1;
        public final String targetArch;

        public CompilerInfo(Path compilerPath, String vendor, String name, String shortName, int versionMajor, int versionMinor0, int versionMinor1, String targetArch) {
            this.compilerPath = compilerPath;
            this.name = name;
            this.vendor = vendor;
            this.shortName = shortName;
            this.versionMajor = versionMajor;
            this.versionMinor0 = versionMinor0;
            this.versionMinor1 = versionMinor1;
            this.targetArch = targetArch;
        }

        public String toString() {
            return String.join((CharSequence)"|", Arrays.asList(this.shortName, this.vendor, this.targetArch, String.format("%d.%d.%d", this.versionMajor, this.versionMinor0, this.versionMinor1)));
        }

        public void dump(Consumer<String> sink) {
            sink.accept("Name: " + this.name + " (" + this.shortName + ")");
            sink.accept("Vendor: " + this.vendor);
            sink.accept(String.format("Version: %d.%d.%d", this.versionMajor, this.versionMinor0, this.versionMinor1));
            sink.accept("Target architecture: " + this.targetArch);
            sink.accept("Path: " + this.compilerPath);
        }
    }

    private static class DarwinCCompilerInvoker
    extends CCompilerInvoker {
        DarwinCCompilerInvoker(Path tempDirectory) {
            super(tempDirectory);
        }

        @Override
        protected String getDefaultCompiler() {
            return "cc";
        }

        @Override
        protected CompilerInfo createCompilerInfo(Path compilerPath, Scanner scanner) {
            try {
                while (scanner.findInLine("Apple (clang|LLVM) version ") == null) {
                    scanner.nextLine();
                }
                scanner.useDelimiter("[. ]");
                int major = scanner.nextInt();
                int minor0 = scanner.nextInt();
                int minor1 = scanner.hasNextInt() ? scanner.nextInt() : 0;
                scanner.reset();
                String[] triplet = DarwinCCompilerInvoker.guessTargetTriplet(scanner);
                return new CompilerInfo(compilerPath, triplet[1], "LLVM", "clang", major, minor0, minor1, triplet[0]);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        @Override
        protected void verify() {
            if (DarwinCCompilerInvoker.guessArchitecture(this.compilerInfo.targetArch) != AMD64.class) {
                UserError.abort(String.format("Native-image building on Darwin currently only supports target architecture: %s (%s unsupported)", AMD64.class.getSimpleName(), this.compilerInfo.targetArch), new Object[0]);
            }
        }
    }

    private static class LinuxCCompilerInvoker
    extends CCompilerInvoker {
        LinuxCCompilerInvoker(Path tempDirectory) {
            super(tempDirectory);
        }

        @Override
        protected String getDefaultCompiler() {
            return LibCBase.singleton().getTargetCompiler();
        }

        @Override
        protected CompilerInfo createCompilerInfo(Path compilerPath, Scanner scanner) {
            try {
                String[] triplet = LinuxCCompilerInvoker.guessTargetTriplet(scanner);
                while (scanner.findInLine("gcc version ") == null) {
                    scanner.nextLine();
                }
                scanner.useDelimiter("[. ]");
                int major = scanner.nextInt();
                int minor0 = scanner.nextInt();
                int minor1 = scanner.nextInt();
                return new CompilerInfo(compilerPath, triplet[1], "GNU project C and C++ compiler", "gcc", major, minor0, minor1, triplet[0]);
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        @Override
        protected void verify() {
            Class<?> substrateTargetArch = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch.getClass();
            Class<? extends Architecture> guessed = LinuxCCompilerInvoker.guessArchitecture(this.compilerInfo.targetArch);
            if (guessed == null) {
                UserError.abort(String.format("Native toolchain (%s) has no matching native-image target architecture.", this.compilerInfo.targetArch), new Object[0]);
            }
            if (guessed != substrateTargetArch) {
                UserError.abort(String.format("Native toolchain (%s) implies native-image target architecture %s but configured native-image target architecture is %s.", this.compilerInfo.targetArch, guessed, substrateTargetArch), new Object[0]);
            }
        }
    }

    private static class WindowsCCompilerInvoker
    extends CCompilerInvoker {
        WindowsCCompilerInvoker(Path tempDirectory) {
            super(tempDirectory);
        }

        @Override
        public String asExecutableName(String basename) {
            String suffix = ".exe";
            if (basename.endsWith(suffix)) {
                return basename;
            }
            return basename + suffix;
        }

        @Override
        protected String getDefaultCompiler() {
            return "cl";
        }

        @Override
        protected List<String> addTarget(Path target) {
            return Arrays.asList("/Fe" + target.toString());
        }

        @Override
        protected InputStream getCompilerErrorStream(Process compilingProcess) {
            return compilingProcess.getInputStream();
        }

        @Override
        protected List<String> getVersionInfoOptions() {
            return Collections.emptyList();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected CompilerInfo createCompilerInfo(Path compilerPath, Scanner outerScanner) {
            try (Scanner scanner = new Scanner(outerScanner.nextLine());){
                String targetArch = null;
                if (scanner.hasNext("\u7528\u4e8e")) {
                    scanner.next();
                    targetArch = scanner.next();
                }
                if (scanner.findInLine("Microsoft.*\\(R\\) C/C\\+\\+") == null) {
                    CompilerInfo compilerInfo = null;
                    return compilerInfo;
                }
                scanner.useDelimiter("\\D");
                while (!scanner.hasNextInt()) {
                    scanner.next();
                }
                int major = scanner.nextInt();
                int minor0 = scanner.nextInt();
                int minor1 = scanner.nextInt();
                if (targetArch == null) {
                    scanner.reset();
                    while (scanner.hasNext()) {
                        targetArch = scanner.next();
                    }
                }
                CompilerInfo compilerInfo = new CompilerInfo(compilerPath, "microsoft", "C/C++ Optimizing Compiler", "cl", major, minor0, minor1, targetArch);
                return compilerInfo;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }

        @Override
        protected void verify() {
            if (JavaVersionUtil.JAVA_SPEC >= 11) {
                if (this.compilerInfo.versionMajor < 19) {
                    UserError.abort("Java " + JavaVersionUtil.JAVA_SPEC + " native-image building on Windows requires Visual Studio 2015 version 14.0 or later (C/C++ Optimizing Compiler Version 19.* or later)", new Object[0]);
                }
            } else {
                VMError.guarantee(JavaVersionUtil.JAVA_SPEC == 8, "Native-image building is only supported for Java 8 and Java 11 or later");
                if (this.compilerInfo.versionMajor != 16 || this.compilerInfo.versionMinor0 != 0) {
                    UserError.abort("Java 8 native-image building on Windows requires Microsoft Windows SDK 7.1", new Object[0]);
                }
            }
            if (WindowsCCompilerInvoker.guessArchitecture(this.compilerInfo.targetArch) != AMD64.class) {
                UserError.abort(String.format("Native-image building on Windows currently only supports target architecture: %s (%s unsupported)", AMD64.class.getSimpleName(), this.compilerInfo.targetArch), new Object[0]);
            }
        }
    }
}

