/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.WeakIdentityHashMap;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.classinitialization.ClassInitializationConfiguration;
import com.oracle.svm.hosted.classinitialization.ClassInitializationFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.ClassOrPackageConfig;
import com.oracle.svm.hosted.classinitialization.EarlyClassInitializerAnalysis;
import com.oracle.svm.hosted.classinitialization.InitKind;
import java.lang.reflect.Proxy;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

public class ConfigurableClassInitialization
implements ClassInitializationSupport {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    private final ClassInitializationConfiguration classInitializationConfiguration = new ClassInitializationConfiguration();
    private final Map<Class<?>, InitKind> classInitKinds = new ConcurrentHashMap();
    private static final int START_OF_THE_TRACE = 4;
    private static final Map<Class<?>, StackTraceElement[]> initializedClasses = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Object, StackTraceElement[]> instantiatedObjects = Collections.synchronizedMap(new WeakIdentityHashMap());
    private boolean configurationSealed;
    private final ImageClassLoader loader;
    private UnsupportedFeatures unsupportedFeatures;
    protected MetaAccessProvider metaAccess;
    static EarlyClassInitializerAnalysis earlyClassInitializerAnalysis = new EarlyClassInitializerAnalysis();

    public ConfigurableClassInitialization(MetaAccessProvider metaAccess, ImageClassLoader loader) {
        this.metaAccess = metaAccess;
        this.loader = loader;
    }

    @Override
    public void setConfigurationSealed(boolean sealed) {
        this.configurationSealed = sealed;
        if (this.configurationSealed && ClassInitializationFeature.Options.PrintClassInitialization.getValue().booleanValue()) {
            List<ClassOrPackageConfig> allConfigs = this.classInitializationConfiguration.allConfigs();
            allConfigs.sort(Comparator.comparing(ClassOrPackageConfig::getName));
            String path = Paths.get(Paths.get(SubstrateOptions.Path.getValue(), new String[0]).toString(), "reports").toAbsolutePath().toString();
            ReportUtils.report((String)"initializer configuration", (String)path, (String)"initializer_configuration", (String)"txt", writer -> {
                for (ClassOrPackageConfig config : allConfigs) {
                    writer.append(config.getName()).append(" -> ").append(config.getKind().toString()).append(" reasons: ").append(String.join((CharSequence)" and ", config.getReasons())).append(System.lineSeparator());
                }
            });
        }
    }

    @Override
    public void setUnsupportedFeatures(UnsupportedFeatures unsupportedFeatures) {
        this.unsupportedFeatures = unsupportedFeatures;
    }

    private InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz, true);
    }

    @Override
    public InitKind specifiedInitKindFor(Class<?> clazz) {
        return (InitKind)((Object)this.classInitializationConfiguration.lookupKind(clazz.getTypeName()).getLeft());
    }

    @Override
    public boolean canBeProvenSafe(Class<?> clazz) {
        InitKind initKind = this.specifiedInitKindFor(clazz);
        return initKind == null || initKind.isDelayed() && this.isStrictlyDefined(clazz) == false;
    }

    private Boolean isStrictlyDefined(Class<?> clazz) {
        return (Boolean)this.classInitializationConfiguration.lookupKind(clazz.getTypeName()).getRight();
    }

    @Override
    public Set<Class<?>> classesWithKind(InitKind kind) {
        return this.classInitKinds.entrySet().stream().filter(e -> e.getValue() == kind).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public boolean shouldInitializeAtRuntime(ResolvedJavaType type) {
        return this.computeInitKindAndMaybeInitializeClass(ConfigurableClassInitialization.getJavaClass(type)) != InitKind.BUILD_TIME;
    }

    @Override
    public boolean shouldInitializeAtRuntime(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz) != InitKind.BUILD_TIME;
    }

    @Override
    public void maybeInitializeHosted(ResolvedJavaType type) {
        this.computeInitKindAndMaybeInitializeClass(ConfigurableClassInitialization.getJavaClass(type));
    }

    private InitKind ensureClassInitialized(Class<?> clazz, boolean allowErrors) {
        try {
            UNSAFE.ensureClassInitialized(clazz);
            return InitKind.BUILD_TIME;
        }
        catch (NoClassDefFoundError ex) {
            if (NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                if (!allowErrors) {
                    System.out.println("Warning: class initialization of class " + clazz.getTypeName() + " failed with exception " + ex.getClass().getTypeName() + (ex.getMessage() == null ? "" : ": " + ex.getMessage()) + ". This class will be initialized at run time because option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.AllowIncompleteClasspath, "+") + " is used for image building. " + ConfigurableClassInitialization.instructionsToInitializeAtRuntime(clazz));
                }
                return InitKind.RUN_TIME;
            }
            return this.reportInitializationError(allowErrors, clazz, ex);
        }
        catch (Throwable t) {
            return this.reportInitializationError(allowErrors, clazz, t);
        }
    }

    private InitKind reportInitializationError(boolean allowErrors, Class<?> clazz, Throwable t) {
        if (allowErrors) {
            return InitKind.RUN_TIME;
        }
        String msg = "Class initialization of " + clazz.getTypeName() + " failed. " + ConfigurableClassInitialization.instructionsToInitializeAtRuntime(clazz);
        if (this.unsupportedFeatures != null) {
            this.unsupportedFeatures.addMessage(clazz.getTypeName(), null, msg, null, t);
            return InitKind.RUN_TIME;
        }
        throw UserError.abort(t, msg);
    }

    private static String instructionsToInitializeAtRuntime(Class<?> clazz) {
        return "Use the option " + SubstrateOptionsParser.commandArgument(ClassInitializationFeature.Options.ClassInitialization, clazz.getTypeName(), "initialize-at-run-time") + " to explicitly request delayed initialization of this class.";
    }

    private static Class<?> getJavaClass(ResolvedJavaType type) {
        return OriginalClassProvider.getJavaClass((SnippetReflectionProvider)GraalAccess.getOriginalSnippetReflection(), (ResolvedJavaType)type);
    }

    public void initializeAtRunTime(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClassByName(name, false);
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.RUN_TIME, reason, true);
            this.initializeAtRunTime(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.RUN_TIME, reason, false);
        }
    }

    public void initializeAtBuildTime(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClassByName(name, false);
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.BUILD_TIME, reason, true);
            this.initializeAtBuildTime(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.BUILD_TIME, reason, false);
        }
    }

    public void rerunInitialization(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClassByName(name, false);
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.RERUN, reason, true);
            this.rerunInitialization(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.RERUN, reason, false);
        }
    }

    public void initializeAtRunTime(Class<?> clazz, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.RUN_TIME, reason, true);
        this.setSubclassesAsRunTime(clazz);
        ConfigurableClassInitialization.checkEagerInitialization(clazz);
        if (!UNSAFE.shouldBeInitialized(clazz)) {
            throw UserError.abort("The class " + clazz.getTypeName() + " has already been initialized; it is too late to register " + clazz.getTypeName() + " for build-time initialization (" + reason + "). " + ConfigurableClassInitialization.classInitializationErrorMessage(clazz, "Try avoiding this conflict by avoiding to initialize the class that caused initialization of " + clazz.getTypeName() + " or by not marking " + clazz.getTypeName() + " for build-time initialization."), new Object[0]);
        }
        this.computeInitKindAndMaybeInitializeClass(clazz, false);
        InitKind previousKind = this.classInitKinds.put(clazz, InitKind.RUN_TIME);
        if (previousKind == InitKind.BUILD_TIME) {
            throw UserError.abort("Class is already initialized, so it is too late to register delaying class initialization: " + clazz.getTypeName() + " for reason: " + reason, new Object[0]);
        }
        if (previousKind == InitKind.RERUN) {
            throw UserError.abort("Class is registered both for delaying and rerunning the class initializer: " + clazz.getTypeName() + " for reason: " + reason, new Object[0]);
        }
    }

    private static String classInitializationErrorMessage(Class<?> clazz, String action) {
        if (!SubstrateOptions.TraceClassInitialization.getValue().booleanValue()) {
            return "To see why " + clazz.getTypeName() + " got initialized use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.TraceClassInitialization, "+");
        }
        if (initializedClasses.containsKey(clazz)) {
            StackTraceElement[] trace = initializedClasses.get(clazz);
            String culprit = null;
            boolean containsLambdaMetaFactory = false;
            for (StackTraceElement stackTraceElement : trace) {
                if (stackTraceElement.getMethodName().equals("<clinit>")) {
                    culprit = stackTraceElement.getClassName();
                }
                if (!stackTraceElement.getClassName().equals("java.lang.invoke.LambdaMetafactory")) continue;
                containsLambdaMetaFactory = true;
            }
            if (containsLambdaMetaFactory) {
                return clazz.getTypeName() + " was initialized through a lambda (https://github.com/oracle/graal/issues/1218). Try marking " + clazz.getTypeName() + " for build-time initialization with " + SubstrateOptionsParser.commandArgument(ClassInitializationFeature.Options.ClassInitialization, clazz.getTypeName(), "initialize-at-build-time") + ".";
            }
            if (culprit != null) {
                return culprit + " caused initialization of this class with the following trace: \n" + ConfigurableClassInitialization.classInitializationTrace(clazz);
            }
            return clazz.getTypeName() + " has been initialized through the following trace:\n" + ConfigurableClassInitialization.classInitializationTrace(clazz);
        }
        return clazz.getTypeName() + " has been initialized without the native-image initialization instrumentation and the stack trace can't be tracked. " + action;
    }

    @Override
    public String objectInstantiationTraceMessage(Object obj, String action) {
        if (!SubstrateOptions.TraceClassInitialization.getValue().booleanValue()) {
            return " To see how this object got instantiated use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.TraceClassInitialization, "+") + ".";
        }
        if (instantiatedObjects.containsKey(obj)) {
            String culprit = null;
            StackTraceElement[] trace = instantiatedObjects.get(obj);
            boolean containsLambdaMetaFactory = false;
            for (StackTraceElement stackTraceElement : trace) {
                if (stackTraceElement.getMethodName().equals("<clinit>")) {
                    culprit = stackTraceElement.getClassName();
                }
                if (!stackTraceElement.getClassName().equals("java.lang.invoke.LambdaMetafactory")) continue;
                containsLambdaMetaFactory = true;
            }
            if (containsLambdaMetaFactory) {
                return " Object was instantiated through a lambda (https://github.com/oracle/graal/issues/1218). Try marking " + obj.getClass().getTypeName() + " for build-time initialization with " + SubstrateOptionsParser.commandArgument(ClassInitializationFeature.Options.ClassInitialization, obj.getClass().getTypeName(), "initialize-at-build-time") + ".";
            }
            if (culprit != null) {
                return " Object has been initialized by the " + culprit + " class initializer with a trace: \n " + ConfigurableClassInitialization.getTraceString(instantiatedObjects.get(obj)) + ". " + action;
            }
            return " Object has been initialized through the following trace:\n" + ConfigurableClassInitialization.getTraceString(instantiatedObjects.get(obj)) + ". " + action;
        }
        return " Object has been initialized without the native-image initialization instrumentation and the stack trace can't be tracked.";
    }

    private static String classInitializationTrace(Class<?> clazz) {
        return ConfigurableClassInitialization.getTraceString(initializedClasses.get(clazz));
    }

    private static String getTraceString(StackTraceElement[] trace) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement stackTraceElement = trace[i];
            b.append("\tat ").append(stackTraceElement.toString()).append("\n");
        }
        return b.toString();
    }

    public void rerunInitialization(Class<?> clazz, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.RERUN, reason, true);
        ConfigurableClassInitialization.checkEagerInitialization(clazz);
        try {
            UNSAFE.ensureClassInitialized(clazz);
        }
        catch (Throwable ex) {
            throw UserError.abort(ex, "Class initialization failed for " + clazz.getTypeName() + ". The class is requested for re-running (reason: " + reason + ")");
        }
        this.computeInitKindAndMaybeInitializeClass(clazz, false);
        InitKind previousKind = this.classInitKinds.put(clazz, InitKind.RERUN);
        if (previousKind != null) {
            if (previousKind == InitKind.BUILD_TIME) {
                throw UserError.abort("The information that the class should be initialized during image building has already been used, so it is too late to register the class initializer of" + clazz.getTypeName() + " for re-running. The reason for re-run request is " + reason, new Object[0]);
            }
            if (previousKind.isDelayed()) {
                throw UserError.abort("Class or a superclass is already registered for delaying the class initializer, so it is too late to register the class initializer of" + clazz.getTypeName() + " for re-running. The reason for re-run request is " + reason, new Object[0]);
            }
        }
    }

    public void initializeAtBuildTime(Class<?> aClass, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        this.classInitializationConfiguration.insert(aClass.getTypeName(), InitKind.BUILD_TIME, reason, true);
        this.forceInitializeHosted(aClass, reason, false);
    }

    private void setSubclassesAsRunTime(Class<?> clazz) {
        if (clazz.isInterface() && !this.metaAccess.lookupJavaType(clazz).declaresDefaultMethods()) {
            return;
        }
        this.loader.findSubclasses(clazz, false).stream().filter(c -> !c.equals(clazz)).filter(c -> !c.isInterface() || this.metaAccess.lookupJavaType(c).declaresDefaultMethods()).forEach(c -> this.classInitializationConfiguration.insert(c.getTypeName(), InitKind.RUN_TIME, "subtype of " + clazz.getTypeName(), true));
    }

    public void reportClassInitialized(Class<?> clazz) {
        assert (SubstrateOptions.TraceClassInitialization.getValue().booleanValue());
        initializedClasses.put(clazz, ConfigurableClassInitialization.relevantStackTrace());
    }

    public void reportObjectInstantiated(Object o) {
        assert (SubstrateOptions.TraceClassInitialization.getValue().booleanValue());
        instantiatedObjects.putIfAbsent(o, ConfigurableClassInitialization.relevantStackTrace());
    }

    private static StackTraceElement[] relevantStackTrace() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        ArrayList<StackTraceElement> filteredStack = new ArrayList<StackTraceElement>();
        assert (stack[3].getClassName().equals("org.graalvm.nativeimage.impl.clinit.ClassInitializationTracking"));
        int lastClinit = 4;
        boolean containsLambdaMetaFactory = false;
        for (int i = 4; i < stack.length; ++i) {
            StackTraceElement stackTraceElement = stack[i];
            if ("<clinit>".equals(stackTraceElement.getMethodName())) {
                lastClinit = i;
            }
            if (stackTraceElement.getClassName().equals("java.lang.invoke.LambdaMetafactory")) {
                containsLambdaMetaFactory = true;
            }
            filteredStack.add(stackTraceElement);
        }
        int lastClinitIndex = lastClinit - 4 + 1;
        ArrayList<StackTraceElement> finalStack = lastClinit != 4 & !containsLambdaMetaFactory ? filteredStack.subList(0, lastClinitIndex) : filteredStack;
        return finalStack.toArray(new StackTraceElement[0]);
    }

    @Override
    public void forceInitializeHosted(Class<?> clazz, String reason, boolean allowInitializationErrors) {
        if (clazz == null) {
            return;
        }
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.BUILD_TIME, reason, true);
        InitKind initKind = this.ensureClassInitialized(clazz, allowInitializationErrors);
        this.classInitKinds.put(clazz, initKind);
        this.forceInitializeHosted(clazz.getSuperclass(), "super type of " + clazz.getTypeName(), allowInitializationErrors);
        this.forceInitializeInterfaces(clazz.getInterfaces(), "super type of " + clazz.getTypeName());
    }

    private void forceInitializeInterfaces(Class<?>[] interfaces, String reason) {
        for (Class<?> iface : interfaces) {
            if (this.metaAccess.lookupJavaType(iface).declaresDefaultMethods()) {
                this.classInitializationConfiguration.insert(iface.getTypeName(), InitKind.BUILD_TIME, reason, true);
                this.ensureClassInitialized(iface, false);
                this.classInitKinds.put(iface, InitKind.BUILD_TIME);
            }
            this.forceInitializeInterfaces(iface.getInterfaces(), "super type of " + iface.getTypeName());
        }
    }

    @Override
    public boolean checkDelayedInitialization() {
        HashSet illegalyInitialized = new HashSet();
        for (Map.Entry<Class<?>, InitKind> entry : this.classInitKinds.entrySet()) {
            if (!entry.getValue().isDelayed() || UNSAFE.shouldBeInitialized(entry.getKey())) continue;
            illegalyInitialized.add(entry.getKey());
        }
        if (illegalyInitialized.size() > 0) {
            StringBuilder detailedMessage = new StringBuilder("Classes that should be initialized at run time got initialized during image building:\n ");
            illegalyInitialized.forEach(c -> {
                InitKind specifiedKind = this.specifiedInitKindFor((Class<?>)c);
                if (specifiedKind == null) {
                    detailedMessage.append(c.getTypeName()).append(" was unintentionally initialized at build time. ");
                    detailedMessage.append(ConfigurableClassInitialization.classInitializationErrorMessage(c, "Try marking this class for build-time initialization with " + SubstrateOptionsParser.commandArgument(ClassInitializationFeature.Options.ClassInitialization, c.getTypeName(), "initialize-at-build-time"))).append("\n");
                } else {
                    assert (specifiedKind.isDelayed()) : "Specified kind must be the same as actual kind for type " + c.getTypeName();
                    String reason = this.classInitializationConfiguration.lookupReason(c.getTypeName());
                    detailedMessage.append(c.getTypeName()).append(" the class was requested to be initialized at run time (").append(reason).append("). ").append(ConfigurableClassInitialization.classInitializationErrorMessage(c, "Try avoiding to initialize the class that caused initialization of " + c.getTypeName())).append("\n");
                }
            });
            throw UserError.abort(detailedMessage.toString(), new Object[0]);
        }
        return true;
    }

    private static void checkEagerInitialization(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            throw UserError.abort("Primitive types and array classes are initialized eagerly because initialization is side-effect free. It is not possible (and also not useful) to register them for run time initialization. Culprit: " + clazz.getTypeName(), new Object[0]);
        }
        if (clazz.isAnnotation()) {
            throw UserError.abort("Class initialization of annotation classes cannot be delayed to runtime. Culprit: " + clazz.getTypeName(), new Object[0]);
        }
    }

    private InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz, boolean memoize) {
        if (this.classInitKinds.containsKey(clazz)) {
            return this.classInitKinds.get(clazz);
        }
        if (clazz.isAnnotation()) {
            this.forceInitializeHosted(clazz, "all annotations are initialized", false);
            return InitKind.BUILD_TIME;
        }
        if (clazz.isEnum() && !UNSAFE.shouldBeInitialized(clazz)) {
            if (memoize) {
                this.forceInitializeHosted(clazz, "enums referred in annotations must be initialized", false);
            }
            return InitKind.BUILD_TIME;
        }
        InitKind clazzResult = this.computeInitKindForClass(clazz);
        InitKind superResult = InitKind.BUILD_TIME;
        if (clazz.getSuperclass() != null) {
            superResult = superResult.max(this.computeInitKindAndMaybeInitializeClass(clazz.getSuperclass(), memoize));
        }
        superResult = superResult.max(this.processInterfaces(clazz, memoize));
        if (memoize && superResult == InitKind.BUILD_TIME && clazzResult == InitKind.RUN_TIME && this.canBeProvenSafe(clazz) && earlyClassInitializerAnalysis.canInitializeWithoutSideEffects(clazz)) {
            clazzResult = this.ensureClassInitialized(clazz, true);
        }
        InitKind result = superResult.max(clazzResult);
        if (memoize) {
            if (!result.isDelayed()) {
                result = result.max(this.ensureClassInitialized(clazz, false));
            }
            InitKind previous = this.classInitKinds.put(clazz, result);
            assert (previous == null || previous == result) : "Overwriting existing value: previous " + (Object)((Object)previous) + " new " + (Object)((Object)result);
        }
        return result;
    }

    private InitKind processInterfaces(Class<?> clazz, boolean memoizeEager) {
        InitKind result = InitKind.BUILD_TIME;
        for (Class<?> iface : clazz.getInterfaces()) {
            result = this.metaAccess.lookupJavaType(iface).declaresDefaultMethods() ? result.max(this.computeInitKindAndMaybeInitializeClass(iface, memoizeEager)) : result.max(this.processInterfaces(iface, memoizeEager));
        }
        return result;
    }

    private InitKind computeInitKindForClass(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            return InitKind.BUILD_TIME;
        }
        if (clazz.isAnnotation()) {
            return InitKind.BUILD_TIME;
        }
        if (Proxy.isProxyClass(clazz) && ConfigurableClassInitialization.isProxyFromAnnotation(clazz)) {
            return InitKind.BUILD_TIME;
        }
        if (clazz.getTypeName().contains("$$StringConcat")) {
            return InitKind.BUILD_TIME;
        }
        if (this.specifiedInitKindFor(clazz) != null) {
            return this.specifiedInitKindFor(clazz);
        }
        return InitKind.RUN_TIME;
    }

    private static boolean isProxyFromAnnotation(Class<?> clazz) {
        for (Class<?> interfaces : clazz.getInterfaces()) {
            if (!interfaces.isAnnotation()) continue;
            return true;
        }
        return false;
    }
}

