/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class ToJson
implements AutoCloseable {
    private static final String EMPTY = "";
    private static final String NEW_LINE = "\n";
    private static final char TAB = '\t';
    private static final String OPEN_OBJECT = "{";
    private static final String CLOSE_OBJECT = "}";
    private static final String OPEN_ARRAY = "[";
    private static final String CLOSE_ARRAY = "]";
    private static final char QUOTE = '\"';
    private static final char SLASH = '\\';
    private static final BitSet ESC = Arrays.asList(Character.valueOf('\\'), Character.valueOf('\"'), Character.valueOf('\b'), Character.valueOf('\f'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\t'), Character.valueOf('/')).stream().collect(BitSet::new, BitSet::set, BitSet::or);
    private static final Map<Character, Character> MAP = new HashMap<Character, Character>();
    private final PrintWriter writer;
    private final boolean pretty;
    private final String newPrefix;
    private final String prefi;
    private final String colon;
    private int depth = 0;
    private String pref;
    private final List<String> prepends = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;

        @Override
        public String get(int index) {
            while (this.size() <= index) {
                this.add(this.getFill(this.size()));
            }
            return (String)super.get(index);
        }

        private String getFill(int size) {
            return size == 0 ? ToJson.EMPTY : (String)super.get(size - 1) + '\t';
        }
    };

    public ToJson(PrintWriter writer) {
        this(writer, false);
    }

    public ToJson(PrintWriter writer, boolean pretty) {
        this.writer = writer;
        this.pretty = pretty;
        if (pretty) {
            this.prefi = ",\n";
            this.newPrefix = NEW_LINE;
            this.colon = ": ";
        } else {
            this.prefi = ",";
            this.newPrefix = EMPTY;
            this.colon = ":";
        }
        this.pref = this.newPrefix;
        writer.append(OPEN_OBJECT);
        ++this.depth;
    }

    private void prepend() {
        if (this.pretty) {
            this.writer.append(this.prepends.get(this.depth));
        }
    }

    public void put(String name, JsonValue value) {
        if (value != null) {
            this.writer.print(this.pref);
            this.putProperty(name, value);
            this.pref = this.prefi;
        }
    }

    private void putProperty(String name, JsonValue value) {
        this.prepend();
        this.dumpString(name);
        this.writer.append(this.colon);
        value.dump(this);
    }

    private void dumpString(String string) {
        this.writer.append('\"');
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (ESC.get(c)) {
                this.writer.append('\\');
                this.writer.append(MAP.getOrDefault(Character.valueOf(c), Character.valueOf(c)).charValue());
                continue;
            }
            this.writer.append(c);
        }
        this.writer.append('\"');
    }

    private void dumpElement(String element) {
        this.writer.print(element);
    }

    private void dumpNumber(Number number) {
        this.writer.print(number);
    }

    private void dumpArray(Stream<JsonValue> values) {
        this.writer.append(OPEN_ARRAY);
        ++this.depth;
        String[] prefix = new String[]{this.newPrefix};
        ((Stream)values.sequential()).forEach(val -> {
            if (val != null) {
                this.writer.print(prefix[0]);
                this.prepend();
                val.dump(this);
                prefix[0] = this.prefi;
            }
        });
        --this.depth;
        if (this.pretty && !prefix[0].equals(NEW_LINE)) {
            this.writer.append(NEW_LINE);
            this.prepend();
        }
        this.writer.append(CLOSE_ARRAY);
    }

    private void dumpObject(Stream<String> names, Function<String, JsonValue> func) {
        this.writer.append(OPEN_OBJECT);
        ++this.depth;
        String[] prefix = new String[]{this.newPrefix};
        ((Stream)names.sequential()).forEach(name -> {
            JsonValue val = (JsonValue)func.apply((String)name);
            if (val != null) {
                this.writer.print(prefix[0]);
                this.putProperty((String)name, val);
                prefix[0] = this.prefi;
            }
        });
        --this.depth;
        if (this.pretty && !prefix[0].equals(NEW_LINE)) {
            this.writer.append(NEW_LINE);
            this.prepend();
        }
        this.writer.append(CLOSE_OBJECT);
    }

    @Override
    public void close() {
        --this.depth;
        assert (this.depth == 0);
        this.writer.append(CLOSE_OBJECT);
        this.writer.close();
    }

    static {
        MAP.put(Character.valueOf('\b'), Character.valueOf('b'));
        MAP.put(Character.valueOf('\f'), Character.valueOf('f'));
        MAP.put(Character.valueOf('\n'), Character.valueOf('n'));
        MAP.put(Character.valueOf('\r'), Character.valueOf('r'));
        MAP.put(Character.valueOf('\t'), Character.valueOf('t'));
    }

    public static abstract class JsonObject
    extends JsonValue {
        public static JsonObject get(final Stream<String> names, final Function<String, JsonValue> func) {
            return names == null || func == null ? null : new JsonObject(){

                @Override
                Stream<String> getNames() {
                    return names;
                }

                @Override
                JsonValue getValue(String name) {
                    return (JsonValue)func.apply(name);
                }
            };
        }

        abstract Stream<String> getNames();

        abstract JsonValue getValue(String var1);

        @Override
        final void dump(ToJson access) {
            this.build();
            Stream<String> names = this.getNames();
            if (names == null) {
                JsonValue.NULL.dump(access);
            } else {
                access.dumpObject(names, this::getValue);
            }
        }
    }

    public static abstract class JsonArray
    extends JsonValue {
        public static JsonArray get(final Stream<JsonValue> values) {
            return values == null ? null : new JsonArray(){

                @Override
                Stream<JsonValue> getValues() {
                    return values;
                }
            };
        }

        abstract Stream<JsonValue> getValues();

        @Override
        final void dump(ToJson access) {
            this.build();
            Stream<JsonValue> values = this.getValues();
            if (values == null) {
                JsonValue.NULL.dump(access);
            } else {
                access.dumpArray(values);
            }
        }
    }

    public static abstract class JsonString
    extends JsonValue {
        public static JsonString get(final String string) {
            return string == null ? null : new JsonString(){

                @Override
                String getString() {
                    return string;
                }
            };
        }

        abstract String getString();

        @Override
        final void dump(ToJson access) {
            this.build();
            String string = this.getString();
            if (string == null) {
                JsonValue.NULL.dump(access);
            } else {
                access.dumpString(string);
            }
        }
    }

    public static abstract class JsonNumber
    extends JsonValue {
        public static JsonNumber get(final Number number) {
            return number == null ? null : new JsonNumber(){

                @Override
                Number getNumber() {
                    return number;
                }
            };
        }

        abstract Number getNumber();

        @Override
        final void dump(ToJson access) {
            this.build();
            Number number = this.getNumber();
            if (number == null) {
                JsonValue.NULL.dump(access);
            } else {
                access.dumpNumber(number);
            }
        }
    }

    private static abstract class JsonElement
    extends JsonValue {
        private JsonElement() {
        }

        static JsonElement get(final String element) {
            return new JsonElement(){

                @Override
                String getElement() {
                    return element;
                }
            };
        }

        abstract String getElement();

        @Override
        final void dump(ToJson access) {
            access.dumpElement(this.getElement());
        }
    }

    public static abstract class JsonValue {
        public static final JsonValue NULL = JsonElement.get("null");
        public static final JsonValue TRUE = JsonElement.get("true");
        public static final JsonValue FALSE = JsonElement.get("false");

        abstract void dump(ToJson var1);

        protected void build() {
        }
    }
}

