/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jdk.internal.module.Modules;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ModuleSupport {
    private ModuleSupport() {
    }

    public static ResourceBundle getResourceBundle(String bundleName, Locale locale, ClassLoader loader) {
        Class<?> bundleClass;
        try {
            bundleClass = loader.loadClass(bundleName);
        }
        catch (ClassNotFoundException ex) {
            return ModuleSupport.getResourceBundleFallback(bundleName, locale, loader);
        }
        return ResourceBundle.getBundle(bundleName, locale, bundleClass.getModule());
    }

    private static ResourceBundle getResourceBundleFallback(String bundleName, Locale locale, ClassLoader loader) {
        for (Module module : ModuleLayer.boot().modules()) {
            try {
                return ResourceBundle.getBundle(bundleName, locale, module);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return ResourceBundle.getBundle(bundleName, locale, loader);
    }

    public static boolean hasSystemModule(String moduleName) {
        return ModuleFinder.ofSystem().find(moduleName).isPresent();
    }

    public static List<String> getModuleResources(Collection<String> names) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : names) {
            Optional<ModuleReference> moduleReference = ModuleFinder.ofSystem().find(name);
            if (!moduleReference.isPresent()) {
                throw new RuntimeException("Unable find ModuleReference for module " + name);
            }
            try {
                ModuleReader moduleReader = moduleReference.get().open();
                try {
                    result.addAll(moduleReader.list().collect(Collectors.toList()));
                }
                finally {
                    if (moduleReader == null) continue;
                    moduleReader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable get list of resources in module" + name, e);
            }
        }
        return result;
    }

    static void openModule(Class<?> declaringClass, Class<?> accessingClass) {
        Module declaringModule = declaringClass.getModule();
        String packageName = declaringClass.getPackageName();
        Module accessingModule = accessingClass.getModule();
        if (accessingModule.isNamed()) {
            if (!declaringModule.isOpen(packageName, accessingModule)) {
                Modules.addOpens(declaringModule, packageName, accessingModule);
            }
        } else {
            Modules.addOpensToAllUnnamed(declaringModule, packageName);
        }
    }

    public static ClassLoader getPlatformClassLoader() {
        return ClassLoader.getPlatformClassLoader();
    }

    public static void exportAndOpenAllPackagesToUnnamed(String name, boolean optional) {
        Optional<Module> value = ModuleLayer.boot().findModule(name);
        if (value.isEmpty()) {
            if (!optional) {
                throw new NoSuchElementException("No module in boot layer named " + name + ". Available modules: " + ModuleLayer.boot());
            }
            return;
        }
        Module module = value.get();
        Set<String> packages = module.getPackages();
        for (String pkg : packages) {
            Modules.addExportsToAllUnnamed(module, pkg);
            Modules.addOpensToAllUnnamed(module, pkg);
        }
    }

    public static void exportAndOpenPackageToUnnamed(String name, String pkg, boolean optional) {
        Optional<Module> value = ModuleLayer.boot().findModule(name);
        if (value.isEmpty()) {
            if (!optional) {
                throw new NoSuchElementException(name);
            }
            return;
        }
        Module module = value.get();
        Modules.addExportsToAllUnnamed(module, pkg);
        Modules.addOpensToAllUnnamed(module, pkg);
    }

    public static String getModuleName(Class<?> clazz) {
        return clazz.getModule().getName();
    }

    public static void findResourcesInModules(Predicate<String> resourceNameFilter, BiConsumer<String, InputStream> operation) throws IOException {
        for (ResolvedModule resolvedModule : ModuleLayer.boot().configuration().modules()) {
            ModuleReference modRef = resolvedModule.reference();
            ModuleReader moduleReader = modRef.open();
            try {
                List resources = moduleReader.list().filter(resourceNameFilter).collect(Collectors.toList());
                for (String resName : resources) {
                    Optional<InputStream> content = moduleReader.open(resName);
                    if (content.isEmpty()) continue;
                    InputStream is = content.get();
                    operation.accept(resName, is);
                    is.close();
                }
            }
            finally {
                if (moduleReader == null) continue;
                moduleReader.close();
            }
        }
    }
}

